/***********************************************************
 * include in your console program, then call function     *
 * color();, recall anytime you use a clrscr, in the color *
 * function, change the variables red, and grey, to        *
 * whatever colors you want to use that are in the enum.   *
 * red is the foreground (text) grey is the background.    *
 ***********************************************************/

#include <windows.h>

enum Color
{ 
        Black = 0,
        Blue =   FOREGROUND_BLUE, 
        Green =  FOREGROUND_GREEN, 
        Red =    FOREGROUND_RED, 
        Cyan =  FOREGROUND_GREEN | FOREGROUND_BLUE, 
        Purple = FOREGROUND_RED | FOREGROUND_BLUE, 
        Orange = FOREGROUND_RED | FOREGROUND_GREEN, 
        Yellow = FOREGROUND_RED | FOREGROUND_GREEN | FOREGROUND_INTENSITY,
        Grey =   FOREGROUND_RED | FOREGROUND_GREEN | FOREGROUND_BLUE, 
        White =  FOREGROUND_RED | FOREGROUND_GREEN | FOREGROUND_BLUE | FOREGROUND_INTENSITY, 
};

void color();
void textcolor(Color FgColor,Color BgColor);
void clrscr();

void color()
{ 
        textcolor(Red,Grey);
        clrscr(); 
        textcolor(Red,Grey);  
}//end function

void textcolor (Color FgColor,Color BgColor) 
{ 
        HANDLE hconsole = GetStdHandle (STD_OUTPUT_HANDLE); 
        SetConsoleTextAttribute (hconsole, FgColor | BgColor << 4); 
} 

void clrscr() 
{ 
        HANDLE hconsole = GetStdHandle (STD_OUTPUT_HANDLE); 
        CONSOLE_SCREEN_BUFFER_INFO csbi; 
        GetConsoleScreenBufferInfo (hconsole,&csbi); 
        COORD coordScreen={0,0};
        DWORD cCharsWritten;
        DWORD dwConSize=csbi.dwSize.X * csbi.dwSize.Y; 
        FillConsoleOutputCharacter (hconsole,' ',dwConSize,coordScreen,&cCharsWritten); 
        FillConsoleOutputAttribute (hconsole,csbi.wAttributes,dwConSize,coordScreen,&cCharsWritten); 
}
