/*rexx**************************************************/
/* rlgBISF v1.0: Uninstall rlgBISF                     */
/* This REXX script is used to remove all rlgBISF v1.0 */
/* files from the install directory and to remove the  */
/* entry from the OS2.INI File.  Also removes WPS      */
/* objects related to rlgBISF.                         */
/*******************************************************/
/* Confirm deletion */
say ''
say '*************************************************************'
say '************** rlgBISF v1.0 Uninstall utility ***************'
say '*************************************************************'
say ''
say 'Do you wish to remove rlgBISF v1.0 from your system? (y/N):'
parse upper pull option
if option \= 'Y' then 
    exit

/* Load REXXUTIL */
call RXFUNCADD 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs'
call SysLoadFuncs

call remove_objects
call remove_ini
call remove_files

say 'rlgBISF v1.0 uninstall process is complete.'
return
/***********************************************************/

remove_files:
File.0  = 13
File.1  = 'BISFhlp.txt'
File.2  = 'readme.txt'
File.3  = 'activity.log'
File.4  = 'restore.cmd'
File.5  = 'rlgBISF.exe'
File.6  = 'rlgBISF.INI'
File.7  = 'install.cmd'
File.8  = 'register.txt'
File.9  = 'rlgBISF.ico'
File.10 = 'FILE_ID.DIZ'
File.11 = 'FILES.LST'
File.12 = 'vrobjdll.url'
File.13 = 'uninstal.cmd'

say ''
/* Delete files */
say '...Deleting rlgBISF v1.0 Files'
do index = 1 to File.0
   rc = SysFileDelete( File.index )
   select
      when rc = 0 then
         say '   'File.index' deleted'
      when rc = 2 then
         say '   'File.index' could not be found.  Continuing...'
   Otherwise
      say '   An error occurred removing 'File.index'.  Return code = 'rc
   end
end
say ''
say 'rlgBISF v1.0 program files have been deleted.'
return

remove_ini:
/* Remove rlgBISF entries from OS2.INI File */
Program = 'rlgBISF'
say '...Removing rlgBISF v1.0 entry from OS2.INI'
rc = SysIni( 'USER', Program, 'ALL:', 'Names.')
if Names.0 = 0 then do
   say '   No entry found in OS2.INI for rlgBISF v1.0.'
end
else do
   rc = SysIni( 'USER', Program, 'DELETE:')
   if rc = 'ERROR:' then do
      say '   An error occurred while removing the entry for rlgBISF v1.0'
   end
   else do
      say '   rlgBISF v1.0 entry removed from OS2.INI'
   end
end
return

remove_objects:
say ''
say '...Removing rlgBISF from the desktop'
obj.  = ''
obj.0 = 7
obj.1 = '<rlgBISF_shadow_pgm>'
obj.2 = '<rlgBISF_vrobjdll>'
obj.3 = '<rlgBISF_register>'
obj.4 = '<rlgBISF_bisfhlp>'
obj.5 = '<rlgBISF_readme>'
obj.6 = '<rlgBISF_program>'
obj.7 = '<rlgBISF_folder>'
do i = 1 to obj.0
    rc = SysDestroyObject(obj.i)
    if rc = 1 then
        say '   ' || obj.i || ' has been removed'
    else
        say '   Error removing ' || obj.i || ' rc = ' || rc || ', continuing. . .'
end
say ''
return
