/*
 * search.c - Search on Text
 */

#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>

#include <os2.h>

#include "qpager.h"
#include "screen.h"

static  UCHAR   searchKey[256] = ""    ;
static  UCHAR   searchBuf[256] = { 0 } ;

/*
 * match - check key macth on a line
 */

static  UCHAR   matchBuf[2048] ;

static  BOOL    match(LINEPTR lp, PUCHAR key)
{
    PUCHAR  p ;
    int     len, bump ;

    kanjiConv(lp->line, matchBuf, lp->code) ;
    len = strlen(key) ;
    
    for (p = matchBuf ; *p != '\0' ; ) {
        if (*p >= 0x80 && *p < 0xa0) {
	    bump = 2 ;
        } else if (*p >= 0xe0 && *p < 0xff) {
	    bump = 2 ;
	} else {
	    bump = 1 ;
	}
	if (*p == *key) {
	    if (strncmp(p, key, len) == 0) {
	        return TRUE ;
	    }
	}
	p += bump ;
    }
    return FALSE ;
}

/*
 * cmdSearchForw - Search Forward
 */

FILEPTR cmdSearchForw(FILEPTR fptr)
{
    LINEPTR p ;
    
    strcpy(searchBuf, searchKey) ;
    if (scrEnter("search forward  ", searchBuf, 64) == NULL) {
        dispPage(fptr) ;
	return fptr ;
    }
    strcpy(searchKey, searchBuf) ;

    sprintf(searchBuf, "looking for %-128s", searchKey) ;
    scrPutLine(nLines, searchBuf) ; scrShow() ;
    
    p = linesNext(fptr, fptr->curln) ;
    while (p != NULL && p != linesTop(fptr)) {
        if (match(p, searchKey)) {
	    break ;
	}
        p = linesNext(fptr, p) ;
    }
    if (p != NULL) {
        fptr->curln = p ;
    }
    dispPage(fptr) ;

    return fptr ;
}

/*
 * cmdSearchBack - Search Backward
 */

FILEPTR cmdSearchBack(FILEPTR fptr)
{
    LINEPTR p ;
    
    strcpy(searchBuf, searchKey) ;
    if (scrEnter("search backward ", searchBuf, 64) == NULL) {
        dispPage(fptr) ;
	return fptr ;
    }
    strcpy(searchKey, searchBuf) ;

    sprintf(searchBuf, "looking for %-128s", searchKey) ;
    scrPutLine(nLines, searchBuf) ; scrShow() ;

    p = linesPrev(fptr, fptr->curln) ;
    while (p != NULL && p != linesBot(fptr)) {
        if (match(p, searchKey)) {
	    break ;
	}
        p = linesPrev(fptr, p) ;
    }
    if (p != NULL) {
        fptr->curln = p ;
    }
    dispPage(fptr) ;

    return fptr ;
}

/*
 * subroutine for GOTO command
 */

static  void    gotoDirect(FILEPTR fptr, int nline)
{
    LINEPTR p ;
    
    if ((p = fptr->curln) == NULL) {
        p = linesTop(fptr) ;
    } else if (nline < p->nline) {
        p = linesTop(fptr) ;
    } else {
        nline -= p->nline ;
    }
    while (p != NULL && nline > 0) {
        p = linesNext(fptr, p) ;
	nline -= 1 ;
    }
    fptr->curln = p ;	
}

static  void    gotoForward(FILEPTR fptr, int nline)
{
    LINEPTR p ;
    
    if ((p = fptr->curln) == NULL) {
        p = linesTop(fptr) ;
    }
    while (p != NULL && nline > 0) {
        p = linesNext(fptr, p) ;
	nline -= 1 ;
    }
    fptr->curln = p ;
}

static  void    gotoBackward(FILEPTR fptr, int nline)
{
    LINEPTR p ;
    
    if ((p = fptr->curln) == NULL) {
        fptr->curln = linesTop(fptr) ;
	return ;
    }
    while (p != NULL && nline > 0) {
        p = linesPrev(fptr, p) ;
	nline -= 1 ;
    }
    fptr->curln = p ;
}

/*
 * cmdGotoLine - Goto Line (direct or relative)
 */

FILEPTR cmdGotoLine(FILEPTR fptr)
{
    int     nline ;

    strcpy(searchBuf, "") ;
    if (scrEnter("goto line ", searchBuf, 64) == NULL) {
        dispPage(fptr) ;
	return fptr ;
    }
    if (isdigit(searchBuf[0])) {
	nline  = atoi(searchBuf) ;
	gotoDirect(fptr, nline)  ;
    } else if (searchBuf[0] == '+' && isdigit(searchBuf[1])) {
	nline  = atoi(&searchBuf[1]) ;
	gotoForward(fptr, nline) ;
    } else if (searchBuf[0] == '-' && isdigit(searchBuf[1])) {
	nline  = atoi(&searchBuf[1]) ;
	gotoBackward(fptr, nline) ;
    } else if (searchBuf[0] == '$') {
        nline = fptr->nline - (nLines / 2) ;
        gotoDirect(fptr, nline) ;
    }
    dispPage(fptr) ;
    return fptr ;
}
