/*
 * display.c - Display Text (adjusting to Screen)
 */

#include <os2.h>
#include <stdio.h>
#include <stdlib.h>

#include "qpager.h"
#include "screen.h"

/*
 * dispLine - Display a Text Line, counting number of line on screen
 */

static  UCHAR   buffText[2048] ;
static  UCHAR   buffDisp[2048] ;

int     dispLine(int i, LINEPTR p, BOOL disp)
{
    int     n, col, pos, ts ;
    UCHAR   ch ;
    
    if (p == NULL) {
        strcpy(buffText, "~") ;
    } else {
        kanjiConv(p->line, buffText, p->code) ;
    }

    buffDisp[0] = '\0' ;

    for (n = col = pos = 0 ; buffText[pos] != '\0' ; ) {
        ch = buffText[pos] ;
	if ((ch >= 0x81 && ch <= 0xa0) || ch >= 0xe0) {     /* KANJI */
	    if ((col + 2) <= nCols) {
	        buffDisp[col++] = buffText[pos++] ;
		buffDisp[col++] = buffText[pos++] ;
		buffDisp[col] = '\0' ;
	    } else {
	        if (disp && (i + n) < nLines) {
                    scrPutLine((i + n), buffDisp) ;
                }
		n += 1 ; buffDisp[col = 0] = '\0' ;
	    }
	} else if (ch >= 0x20) {                            /* ANK */
	    if ((col + 1) <= nCols) {
	        buffDisp[col++] = buffText[pos++] ;
		buffDisp[col] = '\0' ;
	    } else {
	        if (disp && (i + n) < nLines) {
		    scrPutLine((i + n), buffDisp) ;
		}
		n += 1 ; buffDisp[col = 0] = '\0' ;
            }
        } else if (ch == '\b') {                            /* BS */
	    pos += 1 ;
	    if (col > 0) {
	        col -= 1 ;
	    }
	} else if (ch == '\t') {                            /* TAB */
	    for (ts = col + 1 ; (ts % 8) != 0 ; ts++) ;
	    if (ts <= nCols) {
	        pos += 1 ;
	        buffDisp[col++] = ' ' ;
		while ((col % 8) != 0) {
		    buffDisp[col++] = ' ' ;
		}
		buffDisp[col] = '\0' ;
	    } else {
	        if (disp & (i + n) < nLines) {
		    scrPutLine((i + n), buffDisp) ;
		}
		n += 1 ; buffDisp[col = 0] = '\0' ;
	    }
	} else {                                            /* CTRL */
	    if ((col + 2) <= nCols) {
	        buffDisp[col++] = '^' ;
		buffDisp[col++] = buffText[pos++] + 0x40 ;
		buffDisp[col] = '\0' ;
	    } else {
	        if (disp && (i + n) < nLines) {
		    scrPutLine((i + n), buffDisp) ;
		}
		n += 1 ; buffDisp[col = 0] = '\0' ;
	    }
	}
    }
    if (disp && (i + n) < nLines) {
        scrPutLine((i + n), buffDisp) ;
    }
    n += 1 ;

    if (disp) {
        scrShow() ;
    }
    return n ;
}

/*
 * dispStat -  Display Current File Status
 */

static  UCHAR   buffStat[256] ;

int     dispStat(FILEPTR fptr)
{
    PUCHAR  p ;
    ULONG   n ;
    
    if (fptr == NULL) {
        sprintf(buffStat, "NO FILE") ;
        scrPutLine(nLines, buffStat) ;
	return 0 ;
    }
    
    if (fptr->stat == IO_READ) {
        p = "reading" ;
    } else if (fptr->stat == IO_ERROR) {
        p = "error" ;
    } else {
        p = "" ;
    }
    if (fptr->curln == NULL) {
        n = 0 ;
    } else {
        n = fptr->curln->nline ;
    }
    sprintf(buffStat, "[%s] %d/%d %s", fptr->name, n, fptr->nline, p) ;
    scrPutLine(nLines, buffStat) ;
    scrShow() ;
    return 0 ;
}

/*
 * dispPage - Display Current File's Current Page
 */
 
int     dispPage(FILEPTR fptr)
{
    int     n ;
    LINEPTR p ;
    
    if (fptr == NULL) {
        return -1 ;
    }
    if ((p = fptr->curln) == NULL) {
        p = linesTop(fptr) ;
    }
    
    /*
     * dispay a page of lines
     */

    for (n = 0 ; n < nLines && p != NULL ; p = linesNext(fptr, p)) {
        n += dispLine(n, p, TRUE) ;
    }
    for ( ; n < nLines ; n++) {
        dispLine(n, NULL, TRUE) ;
    }

    /*
     * display Status
     */
    
    dispStat(fptr) ;
    
    return n ;
}

/*
 * dispEof - Check if reached to EOF
 */
 
BOOL    dispEof(FILEPTR fptr)
{
    int     n ;
    LINEPTR p ;
    
    if (fptr == NULL) {
        return TRUE ;
    }
    for (n = 0, p = fptr->curln ; p != NULL ; p = linesNext(fptr, p)) {
        if ((n += dispLine(n, p, FALSE)) > nLines) {
	    return FALSE ;
	}
    }
    if (fptr->stat == IO_READ) {
        return FALSE ;
    }
    return TRUE ;
}

/*
 * dispFull - Check if page is full of text
 */

BOOL    dispFull(FILEPTR fptr)
{
    int     n ;
    LINEPTR p ;

    if (fptr == NULL) {
        return FALSE ;
    }
    for (n = 0, p = fptr->curln ; p != NULL ; p = linesNext(fptr, p)) {
        if ((n += dispLine(n, p, FALSE)) > nLines) {
	    return TRUE ;
	}
    }
    return FALSE ;
}
