/* this is a REXX script for PMDF usage */
/* invoke from PMDF with: %dumpairq     */

/* script to decode the "airqi" table. This table */
/* contains info about hooked PSD functions */
/* irq numbers and their associated irq vectors */
/* and type/properties of interrupts */

trace 'o'
numeric digits 20

address df 'querydf path'
if rc = 30 then do
   say 'Run this script as a PMDF command !'
   exit 0;
end

address df "cmd output .lmo 'acpi'"
if output.0 > 2 then do
   /*
    for newer ACPI.PSD, airqi Table is located within ACPI.PSD
    for ACPI.PSD v 3.23.12, it can be found at 4:107d4
    for ACPI.PSD v 3.23.13, it can be found at 4:10884
    for ACPI.PSD v 3.23.14, it can be found at 4:107f8
    for ACPI.PSD v 3.23.15, it can be found at 4:106a0
    for ACPI.PSD v 3.23.16, it can be found at 4:1057c

    ACPI Version string at 3:15f
   */
   MEMOBJ = 3
   OFFSET = x2d(15f)
   n = 3+MEMOBJ
   parse var output.n . . baseaddr .

   address df 'cmd ver da %(' baseaddr ' + ' d2x(OFFSET) ')'
   parse var ver.2 . version
   say version
   version = word(ver.2,8)
   if version == '3.23.12' then do
      OBJOFFSET = x2d(107d4)
   end
   else if version == '3.23.13' then do
      OBJOFFSET = x2d(10884)
   end
   else if version == '3.23.14' then do
      OBJOFFSET = x2d(107f8)
   end
   else if version == '3.23.15' then do
      OBJOFFSET = x2d(106a0)
   end
   else if version == '3.23.16' then do
      OBJOFFSET = x2d(1057c)
   end
   else do
      say 'unknown ACPI version !'
      signal bailout
   end

   OBJNUM = 4
   NUMENTRIES=64
   last = output.0-1
   do i=4 to last
      parse var output.i obj . vbase .
      if x2d(obj) == OBJNUM then do
         leave
      end
   end
end
else do
   OBJOFFSET = 0
   NUMENTRIES=48
   address df "cmd output ln airqi"
   parse var output.2 vbase .
end

say 'Info about irqi_usFlags:'
say '0x0080: SPI IRQ (ACPI SPI Handler interrupt)'
say '0x0040: LSI IRQ (local SW interrupt)'
say '0x0020: IPI IRQ (interprocessor interrupt)'
say '0x0010: candidate for routing to VDM if not claimed by PDD'
say '0x0008: NPX IRQ'
say '0x0004: shareable IRQ'
say '0x0002: system IRQ (slave IRQ)'
say '0x0001: IRQ shared by more than one DD'
say
say

do i=0 to (NUMENTRIES-1)
   addr = '%('vbase'+'d2x(OBJOFFSET)'+'d2x(i*16)')'

   address df 'cmd output dd 'addr' l4'
   idx = output.0-1
   parse var output.idx . irqi_pdirqHead 21 irqi_usFlags 25 irqi_ucIRQVec 27 irqi_ucIRQNum irqi_PSDHandler .

   /* fix bug: strip additional whitespace for first parsed variable */
   irqi_pdirqHead = strip(irqi_pdirqHead)

   say 'irqi_pdirqHead:  %'irqi_pdirqHead' (linear address)'
   say 'irqi_ucIRQNum:   'x2d(irqi_ucIRQNum)
   say 'irqi_ucIRQVec:   0x'irqi_ucIRQVec
   say 'irqi_usFlags:    0x'irqi_usFlags
   say 'irqi_PSDHandler: %'irqi_PSDHandler' (linear address)'
   say '---------------------------------------------------'
end
bailout:
return 0
