/* this is a REXX script for PMDF usage */
/* invoke from PMDF with: %drvintr    */

/* script to decode the drivers that have an interrupt hooked */
/* for this, the "airqi" table is queried. It contains the info */
/* which driver or drivers hook what interrupts */

trace 'o'
if \IfCalledFromPMDF() then do
   return 1
end /* do */

numeric digits 20
TAB = d2c(9)

address df "cmd output .lmo 'acpi'"
if output.0 > 2 then do
   /*
    for newer ACPI.PSD, airqi Table is located within ACPI.PSD
    for ACPI.PSD v 3.23.12, it can be found at 4:107d4
    for ACPI.PSD v 3.23.13, it can be found at 4:10884
    for ACPI.PSD v 3.23.14, it can be found at 4:107f8
    for ACPI.PSD v 3.23.15, it can be found at 4:106a0
    for ACPI.PSD v 3.23.16, it can be found at 4:1057c

    ACPI Version string at 3:15f
   */
   MEMOBJ = 3
   OFFSET = x2d(15f)
   n = 3+MEMOBJ
   parse var output.n . . baseaddr .

   address df 'cmd ver da %(' baseaddr ' + ' d2x(OFFSET) ')'
   parse var ver.2 . version
   say version
   version = word(ver.2,8)
   if version == '3.23.12' then do
      OBJOFFSET = x2d(107d4)
   end
   else if version == '3.23.13' then do
      OBJOFFSET = x2d(10884)
   end
   else if version == '3.23.14' then do
      OBJOFFSET = x2d(107f8)
   end
   else if version == '3.23.15' then do
      OBJOFFSET = x2d(106a0)
   end
   else if version == '3.23.16' then do
      OBJOFFSET = x2d(1057c)
   end
   else do
      say 'unknown ACPI version !'
      signal bailout
   end

   OBJNUM = 4
   last = output.0-1
   do i=4 to last
      parse var output.i obj . vbase .
      if x2d(obj) == OBJNUM then do
         leave
      end
   end
   airqi = d2x(OBJOFFSET+x2d(vbase))
   len = 'l100'
end /* do */
else do
   address df 'cmd output ln airqi'
   parse var output.2 2 airqi .
   len = 'lc0'
end /* do */

address df 'cmd r0 dw _R0DS l1'
last = r0.0-1
parse var r0.last 12 r0ds .

address df 'cmd drivers .lmpo'

address df 'cmd airqis dd 'airqi' 'len
last = airqis.0-1
do n=2 to last
   parse var airqis.n 12 dirq . +15 irq .
   do while dirq <> 0
      say 'irq:'||x2d(irq)||' --------------------------------------'
      address df 'cmd dirqs dd 'dirq' l3'
      parse var dirqs.2 12 dirq 21 cs 25 ip . 34 ds .
      if x2d(ds) <> x2d(r0ds) then do
         address df 'cmd devs .d dev 'ds':0000'
         last2 = devs.0-1
         do o=2 to last2
            say devs.o
         end /* do */
         say TAB||TAB||DriverNameFromDS(ds)
      end /* do */
      else do
         address df 'cmd lns ln 'cs':'ip
         if lns.2 <> 'No Symbols Found' then do
            parse var lns.2 . . routine
         end
         else do
            routine = lns.2
         end
         say '         DevStrat: 'routine' ('cs':'ip')'
      end /* do */
      say
   end
end
bailout:
return 0

IfCalledFromPMDF: procedure
address df 'querydf path'
if rc == 30 then do
   say 'run this script from PMDF'
   return 0
end
else do /* do */
   return 1
end /* do */


DriverNameFromDS: procedure expose drivers.
parse arg ds
last = drivers.0-1
do n=2 to last
   parse var drivers.n . . . drivername
   n = n+1
   parse var drivers.n keyword .
   n = n+1
   do while n <= last & drivers.n <> ''
      if keyword == 'obj' then
         parse var drivers.n . . . . . . . found .
      else
         parse var drivers.n . . . . . found .
      if x2d(ds) == x2d(found) then do
         signal quit
      end /* do */
      n = n+1
   end /* do */
end /* do */
quit:
if n>last then do
   drivername = 'unknown driver'
end
return drivername


