#include <stdio.h>
#include <functional>
#include <type_traits>
#include <typeinfo>

#define WR         /*read-write*/
#define RC         /*recursive*/
#define API        /*namespace-api*/

#define interface  class
#define mixin      class

#define extends    public
#define implements public
#define imports    private
#define export     using
#define transitive /*export-not-required*/
#define DI         /*dependency-injection*/

#define var        auto /*new-heap-var*/
#define let        /*new-heap-let-type*/

#define free       delete               // Free memory (not "delete variable")
#define with       std::function        // Method with External Method
#define cls        this                 // Calling Chain Link to Self
#define mix        (*this)              // Calling to Mix-in

#define at         class
#define on         class

#define type       typename
#define type_of    enable_if_same_type

#define include    if constexpr
#define PURE_C     1
#define STD_API    1
#define OS2_API    1
#define X11_API    1

#define size_of(x) ( sizeof (x) )
#define array_size(x) ( sizeof (x) )
#define array_length(x) ( sizeof (x) / sizeof (x[0]) )

#define t_id(x) ( typeid (x).hash_code () )
#define t_name(x) ( typeid (x).name () )

#define error(ec) ( exit (ec + (fprintf (stderr, "Error: %d, %s(), %s, line %d." "\n", \
                                                 ec, __FUNCTION__, __FILE__, __LINE__) * 0)) )

typedef void struct_ptr;

typedef unsigned char      byte;
typedef unsigned long      ulong;
typedef unsigned short     ushort;
typedef unsigned long long ulong64;

typedef unsigned long      hfile;
typedef unsigned long      hmq;
typedef unsigned long      hwnd;

template <typename T, typename U> inline constexpr
     int enable_if_same_type = std::is_same <T, U>::value;

/* * */

// ࠭  窨.
namespace painting_toolbox
{
  // ஡  ⥩.
  template <class T> interface IHolder
  {
    public:
      virtual void WR add (ulong, T *) = 0;
      virtual void WR remove (ulong) = 0;

      virtual int is_empty () = 0;
    ;
  };

  // ஡  ⥩.
  template <class T> interface ITHolder
  {
    protected:
      virtual int check_is_empty () = 0;
    ;
  };

  // ஡  ⥩.
  template <class T> mixin WR THolder : implements ITHolder <T>
  {
    public:
      THolder () {}
      ~THolder () {}
    ;

    protected:
      void WR inc_counter ();
      void WR dec_counter ();

      int check_is_empty ();
    ;

    private:
      ulong counter = 0;
    ;
  };

  template <class T> void THolder <T>::inc_counter ()
  {
    counter ++;
  }

  template <class T> void THolder <T>::dec_counter ()
  {
    counter --;
  }

  template <class T> int THolder <T>::check_is_empty ()
  {
    return (counter == 0) ? 1 : 0;
  }

  // ।  쬠.
  interface IDrawStick
  {
    public:
      virtual void draw () = 0;
    ;
  };

  // ࠭.
  class Pencil : implements IDrawStick 
  {
    public:
      Pencil () {}
      virtual ~Pencil () {}
 
      void draw ();
    ;
  };

  void Pencil::draw ()
  {
    printf ("Pencil::draw ()" "\n");
  }

  // 窠.
  class Brush : implements IDrawStick
  {
    public:
      Brush () {}
      virtual ~Brush () {}
    
      void draw ();
    ;
  };

  void Brush::draw ()
  {
    printf ("Brush::draw ()" "\n");
  }

  // ⥩  祬 㣮.
  template <class T> class WR Container : implements IHolder <T>, 
                                             imports THolder <T>
  {
    public:
      Container () {}
      virtual ~Container () {}

      void add (ulong, T *);
      void remove (ulong);

      int is_empty ();
    ;
  };

  template <class T> void Container <T>::add (ulong id, T *item)
  {
    printf ("Container::add ()" "\n");

    mix.inc_counter ();
  }

  template <class T> void Container <T>::remove (ulong id)
  {
    printf ("Container::remove ()" "\n");

    mix.dec_counter ();
  }

  template <class T> int Container <T>::is_empty ()
  {
    printf ("Container::is_empty ()" "\n");

    return mix.check_is_empty ();
  }

  // ஡  祬 㣮.
  template <class T> class WR Box : implements IHolder <T>, 
                                       imports THolder <T>
  {
    public:
      Box () {}
      virtual ~Box () {}

      void add (ulong, T *);
      void remove (ulong);

      int is_empty ();
    ;
  };

  template <class T> void Box <T>::add (ulong id, T *item)
  {
    printf ("Box::add ()" "\n");

    mix.inc_counter ();
  }

  template <class T> void Box <T>::remove (ulong id)
  {
    printf ("Box::remove ()" "\n");

    mix.dec_counter ();
  }

  template <class T> int Box <T>::is_empty ()
  {
    printf ("Box::is_empty ()" "\n");

    return mix.check_is_empty ();
  }
}

export painting_toolbox::IDrawStick;
export painting_toolbox::Pencil;
export painting_toolbox::Brush;
export painting_toolbox::Container;
export painting_toolbox::Box;

/* * */

int main ()
{
  // ࠭.
  var *pencil = new Pencil ();

  // 窠.
  let IDrawStick *brush = new Brush ();

  // ஡  ࠭蠬.
  var *pencil_box = new Box <Pencil> ();

  // ⥩  ஡  ࠭蠬  窠.
  var *container = new Container <Box <IDrawStick>> ();

  // ...
  pencil->draw ();
  brush->draw ();

  pencil_box->add (0xFF, pencil);

  printf ("%d" "\n", pencil_box->is_empty ());
  printf ("%d" "\n", container->is_empty ());

  free container;
  free pencil_box;
  free brush;
  free pencil;
    
  //  , 祬 ஡.
        return 0;
}
