#include <stdio.h>
#include <functional>
#include <type_traits>
#include <typeinfo>

#define WR         /*read-write*/
#define RC         /*recursive*/
#define API        /*namespace-api*/

#define interface  class
#define mixin      class

#define extends    public
#define implements public
#define imports    private
#define export     using
#define transitive /*export-not-required*/
#define DI         /*dependency-injection*/

#define var        auto /*new-heap-var*/
#define let        /*new-heap-let-type*/

#define free       delete               // Free memory (not "delete variable")
#define with       std::function        // Method with External Method
#define cls        this                 // Calling Chain Link to Self
#define mix        (*this)              // Calling to Mix-in

#define at         class
#define on         class

#define type       typename
#define type_of    enable_if_same_type

#define include    if constexpr
#define PURE_C     1
#define STD_API    1
#define OS2_API    1
#define X11_API    1

#define size_of(x) ( sizeof (x) )
#define array_size(x) ( sizeof (x) )
#define array_length(x) ( sizeof (x) / sizeof (x[0]) )

#define t_id(x) ( typeid (x).hash_code () )
#define t_name(x) ( typeid (x).name () )

#define error(ec) ( exit (ec + (fprintf (stderr, "Error: %d, %s(), %s, line %d." "\n", \
                                                 ec, __FUNCTION__, __FILE__, __LINE__) * 0)) )

typedef void struct_ptr;

typedef unsigned char      byte;
typedef unsigned long      ulong;
typedef unsigned short     ushort;
typedef unsigned long long ulong64;

typedef unsigned long      hfile;
typedef unsigned long      hmq;
typedef unsigned long      hwnd;

template <typename T, typename U> inline constexpr
     int enable_if_same_type = std::is_same <T, U>::value;

/* * */

//  窠.
namespace window_manager
{
  interface IFrameWindow
  {
    // ...
  };

  interface IClientWindow
  {
    // ...
  };

  /* * */

  void show (IFrameWindow WR *window)
  {
    // ...
  }

  void hide (IFrameWindow WR *window)
  {
    // ...
  }
}

export window_manager::IFrameWindow;
export window_manager::IClientWindow;
export window_manager::show;
export window_manager::hide;

/* * */

// ⮪  । ᮮ饭.
namespace thread_manager
{
  hmq create_queue ()
  {
    return 0;
  }

  void destroy (hmq WR *queue)
  {
    *queue = 0;
  }

  struct Message
  {
    // ...
  };

  struct WR Reply
  {
    // ...
  };
}

export thread_manager::create_queue;
export thread_manager::destroy;
export thread_manager::Message;
export thread_manager::Reply;

/* * */

// ࠡ稪 ᮮ饭.
namespace message_filter
{
  interface IMessageFilter
  {
    // ...
  };

  mixin TMessageFilter
  {
    // ...
  };
}

export message_filter::IMessageFilter;
export message_filter::TMessageFilter;

/* * */

// ᪫ .
namespace layout_manager
{
  interface ILayoutManager
  {
    // ...
  };

  mixin TLayoutManager
  {
    // ...
  };
}

export layout_manager::ILayoutManager;
export layout_manager::TLayoutManager;

/* * */

// .
namespace wp_folder
{
  namespace interfaces
  {
    template <interface F, interface C> interface AFolder
    {
      public:
        virtual WR AFolder * set_title (char *) API = 0;
        virtual WR AFolder * set_doc_name (char *) API = 0;
      ;
    };
    
    template <interface F, interface C> interface IFolder : extends AFolder <F, C>
    {
      // ...
    };

    template <interface F, interface C> mixin WR TFolder
    {
      // ...
    };
  }

  export IFolder = interfaces::IFolder <IFrameWindow, IClientWindow>;
  export TFolder = interfaces::TFolder <IFrameWindow, IClientWindow>;

  /* * */

  void set_title (IFolder WR *folder, char *title, char *doc_name = NULL)
  {
    folder->set_title (title)->set_doc_name ((doc_name) ? doc_name : (char *) "");
  }
}

export wp_folder::IFolder;
export wp_folder::TFolder;
export wp_folder::set_title;

/* * */

// 窠 ࠡ祣 ⮫.
namespace wp_shell
{
  class WR Folder : implements IFolder,
                       imports TFolder
  {
    public:
      Folder (char *title, IMessageFilter DI *filter,
                           ILayoutManager DI *layout_manager, with <void (let Folder WR *)> init = NULL)
      {
        include (PURE_C | STD_API)
        {
          printf ("%s" "\n", title);
        }

        /*

        ... window = create_window (..., [=] (hwnd folder_window) {
                                                                    bind_and_lock_in_place (folder_window/local_state, this);
                                                                  });

        */

        if (init) init (cls);
      }

      virtual ~Folder () 
      {

        /*

        ... destroy (&window);

        */

      }

      IFolder * set_title (char *);
      IFolder * set_doc_name (char *);
    ;

    private:
      hwnd window = 0;

      // ...

    ;
  };

  IFolder * Folder::set_title (char *title)
  {
    printf ("%s" "\n", title);

    return cls;
  }

  IFolder * Folder::set_doc_name (char *doc_name)
  {
    printf ("%s" "\n", doc_name);

    return cls;
  }
}

export wp_shell::Folder;

/* * */

// ﭨ ணࠬ (ᠭ ,   ᠬ ).
struct ProgramState
{
  // ...

  ~ProgramState ()
  {
    // ...
  }
};

//   (ᠭ ,   ᠬ ).
struct MainWindow
{
  Folder *folder = NULL;

  ~MainWindow ()
  {
    free folder;
  }
};

// ࠡ稪 ᮮ饭.
template <interface W> class MessageFilter : implements IMessageFilter,
                                                imports TMessageFilter
{
  public:
    MessageFilter () {}
    virtual ~MessageFilter () {}
  ;

  /*

  private:
    ulong messages[] = {
                         { WM_MENUSELECT, MENU_ITEM_ID_ABOUT, MENU_ID_HELP },
                         ...
                       };

    #include "..."
  ;

  */

  private:
    class menu
    {
      at items
      {
        at Help
        {
          on About
          {
            public:
              ulong selected (ProgramState WR *state, Reply WR *reply, W WR *window, Message *message);

              // ...

            ;
          };
        };
      };
    };

    // ...

  ;
};

template <interface W> ulong MessageFilter <W>::menu::items::Help::About::selected (ProgramState *state, Reply *reply, W *window, Message *message)
{
  return 0;
}

template <interface W> class LayoutManager : implements ILayoutManager,
                                                imports TLayoutManager
{
  public:
    LayoutManager () {}
    virtual ~LayoutManager () {}
  ;

  /*

  private:
    ulong messages[] = {
                         { WM_APPLYLAYOUT, 0, 0 },
                         ...
                       };

    #include "..."
  ;

  */

  // ...

};

// ---   䮫 ---

int main ()
{
  hmq queue = create_queue ();

  var *state = new ProgramState {};

  var *main_window = new MainWindow {
   .folder = new Folder (
      "Hello, World!", new MessageFilter <IFolder> (),
                       new LayoutManager <IFolder> (), [] (var *folder) {
                                                                          set_title (folder, "Folder", "Icon view");
                                                                        })
  };

  /*

  Application::run (queue, &state, &main_window, [=] () {
                                                          show (main_window->folder);
                                                        });

  */

  free main_window; free state;

  destroy (&queue);

  return 0;
}
