/* Copyright (c) 1986, Greg McGary */
/* Assembler scanner hacked into a Text scanner by Tom Horsley 1988 */

#include	<bool.h>
#include	<stdio.h>
#include	<string.h>
#include	<ctype.h>
#include	<id.h>

char *getTextId();
void setTextArgs();

static void clrCtype();
static void setCtype();

#define	I1	0x01	/* 1st char of an identifier [a-zA-Z_] */
#define	NM	0x02	/* digit [0-9a-fA-FxX] */
#define SQ	0x04	/* squeeze these out (.,',-) */
#define	EF	0x80	/* EOF */

/* Text character classes */
#define	ISID1ST(c)	((rct)[c]&(I1))
#define	ISIDREST(c)	((rct)[c]&(I1|NM|SQ))
#define	ISNUMBER(c)	((rct)[c]&(NM))
#define	ISEOF(c)	((rct)[c]&(EF))
#define	ISBORING(c)	(!((rct)[c]&(I1|NM|EF)))
#define ISIDSQUEEZE(c)	((rct)[c]&(SQ))

static char idctype[] = {

	EF,

	/*      0       1       2       3       4       5       6       7   */
	/*    -----   -----   -----   -----   -----   -----   -----   ----- */

	/*000*/	0,	0,	0,	0,	0,	0,	0,	0,
	/*010*/	0,	0,	0,	0,	0,	0,	0,	0,
	/*020*/	0,	0,	0,	0,	0,	0,	0,	0,
	/*030*/	0,	0,	0,	0,	0,	0,	0,	0,
	/*040*/	0,	0,	0,	0,	0,	0,	0,	SQ,
	/*050*/	0,	0,	0,	0,	0,	SQ,	SQ,	0,
	/*060*/	NM,	NM,	NM,	NM,	NM,	NM,	NM,	NM,	
	/*070*/	NM,	NM,	0,	0,	0,	0,	0,	0,
	/*100*/	0,	I1|NM,	I1|NM,	I1|NM,	I1|NM,	I1|NM,	I1|NM,	I1,
	/*110*/	I1,	I1,	I1,	I1,	I1|NM,	I1,	I1,	I1,
	/*120*/	I1,	I1,	I1,	I1,	I1,	I1,	I1,	I1,
	/*130*/	I1|NM,	I1,	I1,	0,	0,	0,	0,	I1,
	/*140*/	0,	I1|NM,	I1|NM,	I1|NM,	I1|NM,	I1|NM,	I1|NM,	I1,
	/*150*/	I1,	I1,	I1,	I1,	I1|NM,	I1,	I1,	I1,
	/*160*/	I1,	I1,	I1,	I1,	I1,	I1,	I1,	I1,
	/*170*/	I1|NM,	I1,	I1,	0,	0,	0,	0,	0,

	/*200*/	0,	0,	0,	0,	0,	0,	0,	0,
	/*210*/	0,	0,	0,	0,	0,	0,	0,	0,
	/*220*/	0,	0,	0,	0,	0,	0,	0,	0,
	/*230*/	0,	0,	0,	0,	0,	0,	0,	0,
	/*240*/	0,	0,	0,	0,	0,	0,	0,	0,
	/*250*/	0,	0,	0,	0,	0,	0,	0,	0,
	/*260*/	0,	0,	0,	0,	0,	0,	0,	0,
	/*270*/	0,	0,	0,	0,	0,	0,	0,	0,
	/*300*/	0,	0,	0,	0,	0,	0,	0,	0,
	/*310*/	0,	0,	0,	0,	0,	0,	0,	0,
	/*320*/	0,	0,	0,	0,	0,	0,	0,	0,
	/*330*/	0,	0,	0,	0,	0,	0,	0,	0,
	/*340*/	0,	0,	0,	0,	0,	0,	0,	0,
	/*350*/	0,	0,	0,	0,	0,	0,	0,	0,
	/*360*/	0,	0,	0,	0,	0,	0,	0,	0,
	/*370*/	0,	0,	0,	0,	0,	0,	0,	0,

};

/* 
        Grab the next identifier the text source file opened with the
	handle `inFILE'.  This state machine is built for speed, not
	elegance.
*/
char *
getTextId(inFILE, flagP)
	FILE		*inFILE;
	int		*flagP;
{
	static char	idBuf[BUFSIZ];
	register char	*rct = &idctype[1];
	register int	c;
	register char	*id = idBuf;

top:
	c = getc(inFILE);
	while (ISBORING(c))
		c = getc(inFILE);
	if (ISEOF(c)) {
		return NULL;
	}
	id = idBuf;
	*id++ = c;
	if (ISID1ST(c)) {
		*flagP = IDN_NAME;
		while (ISIDREST(c = getc(inFILE)))
			if (! ISIDSQUEEZE(c)) *id++ = c;
	} else if (ISNUMBER(c)) {
		*flagP = IDN_NUMBER;
		while (ISNUMBER(c = getc(inFILE)))
			*id++ = c;
	} else {
		if (isprint(c))
			fprintf(stderr, "junk: `%c'", c);
		else
			fprintf(stderr, "junk: `\\%03o'", c);
		goto top;
	}

	*id = '\0';
	ungetc(c, inFILE);
	*flagP |= IDN_LITERAL;
	return idBuf;
}

static void
setCtype(chars, type)
	char		*chars;
	int		type;
{
	char		*rct = &idctype[1];

	while (*chars)
		rct[*chars++] |= type;
}
static void
clrCtype(chars, type)
	char		*chars;
	int		type;
{
	char		*rct = &idctype[1];

	while (*chars)
		rct[*chars++] &= ~type;
}

extern char	*MyName;
static void
usage(lang)
	char		*lang;
{
	fprintf(stderr, "Usage: %s -S%s([(+|-)a<cc>] [(+|-)s<cc>]\n", MyName, lang);
	exit(1);
}
static char *textDocument[] =
{
"The Text scanner arguments take the form -Stext<arg>, where",
"<arg> is one of the following: (<cc> denotes one or more characters)",
"  (+|-)a<cc> . . Include (or exculde) <cc> in ids.",
"  (+|-)s<cc> . . Squeeze (or don't squeeze) <cc> out of ids.",
NULL
};
void
setTextArgs(lang, op, arg)
	char		*lang;
	int		op;
	char		*arg;
{
	if (op == '?') {
		document(textDocument);
		return;
	}
	switch (*arg++)
	{
	case 'a':
		if (op == '+') {
			setCtype(arg, I1) ;
		} else {
			clrCtype(arg, I1) ;
		}
		break;
	case 's':
		if (op == '+') {
			setCtype(arg, SQ) ;
		} else {
			clrCtype(arg, SQ) ;
		}
		break;
	default:
		if (lang)
			usage(lang);
		break;
	}
}
