
# line 2 "iid.y"
/* This is the yacc definition for the iid command language.
 * The main program, scanner, and parser are defined here.
 * The utility functions invoked from here are in iidfun.c
 */

#include "iiddef.h"


# line 11 "iid.y"
typedef union  {
   set_type *     setdef ;   
   id_type *      strdef ;
   id_list_type * listdef ;
} YYSTYPE;
# define SET 257
# define ID 258
# define SHELL_QUERY 259
# define SHELL_COMMAND 260
# define LID 261
# define AID 262
# define BEGIN 263
# define SETS 264
# define SS 265
# define FILES 266
# define SHOW 267
# define HELP 268
# define OFF 269
# define MATCH 270
# define OR 271
# define AND 272
# define NOT 273
#define yyclearin yychar = -1
#define yyerrok yyerrflag = 0
extern int yychar;
extern short yyerrflag;
#ifndef YYMAXDEPTH
#define YYMAXDEPTH 150
#endif
YYSTYPE yylval, yyval;
# define YYERRCODE 256

# line 257 "iid.y"


/* ScanLine - a global variable holding a pointer to the current
 * command being scanned.
 */
char *             ScanLine ;

/* ScanPtr - a global pointer to the current scan position in ScanLine.
 */
char *             ScanPtr ;

/* yytext - buffer holding the token.
 */
char               yytext [ MAXCMD ] ;

/* yyerror - process syntax errors.
 */
int
yyerror(s)
   char *     s ;
{
   if (*ScanPtr == '\0') {
      fprintf(stderr,"Syntax error near end of command.\n") ;
   } else {
      fprintf(stderr,"Syntax error on or before %s\n",ScanPtr) ;
   }
   return(0) ;
}

/* ScanInit - initialize the yylex routine for the new line of input.
 * Basically just initializes the global variables that hold the char
 * ptrs the scanner uses.
 */
void
ScanInit(line)
   char *    line ;
{
   /* skip the leading white space - the yylex routine is sensitive
    * to keywords in the first position on the command line.
    */
   
   while (isspace(*line)) ++line ;
   ScanLine = line ;
   ScanPtr = line ;
}

/* NameEq - compare two names for equality in a case insensitive manner.
 * return TRUE for equal, FALSE otherwise.
 */
int
NameEq(n1,n2)
   char *      n1 ;
   char *      n2 ;
{
   char        c1 ;
   char        c2 ;
   
   for ( ; ; ) {
      c1 = *n1++ ;
      c2 = *n2++ ;
      if (isalpha(c1)) c1 = tolower(c1) ;
      if (isalpha(c2)) c2 = tolower(c2) ;
      if (c1 != c2) return FALSE ;
      if (c1 == '\0') return TRUE ;
   }
}

/* yylex - the scanner for iid. Basically a kludge ad-hoc piece of junk,
 * but what the heck, if it works...
 *
 * Mostly just scans for non white space strings and returns ID for them.
 * Does check especially for '(' and ')'. Just before returning ID it
 * checks for command names if it is the first token on line or
 * AND, OR, LID, AID if it is in the middle of a line.
 */
int
yylex()
{
   char *      bp ;
   char        c ;
   int         code = ID ;
   char *      dp ;
   char *      sp ;
   int         val ;
   
   bp = ScanPtr ;
   while (isspace(*bp)) ++bp ;
   sp = bp ;
   c = *sp++ ;
   if ((c == '(') || (c == ')') || (c == '\0')) {
      ScanPtr = sp ;
      if (c == '\0') {
         --ScanPtr ;
      }
      return(c) ;
   } else {
      dp = yytext ;
      while (! ((c == '(') || (c == ')') || (c == '\0') || isspace(c))) {
         *dp++ = c ;
         c = *sp++ ;
      }
      *dp++ = '\0' ;
      ScanPtr = sp - 1 ;
      if (bp == ScanLine) {

         /* first token on line, check for command names */

         if (NameEq(yytext, "SS")) return(SS) ;
         if (NameEq(yytext, "FILES")) return(FILES) ;
         if (NameEq(yytext, "F")) return(FILES) ;
         if (NameEq(yytext, "HELP")) return(HELP) ;
         if (NameEq(yytext, "H")) return(HELP) ;
         if (NameEq(yytext, "?")) return(HELP) ;
         if (NameEq(yytext, "BEGIN")) return(BEGIN) ;
         if (NameEq(yytext, "B")) return(BEGIN) ;
         if (NameEq(yytext, "SETS")) return(SETS) ;
         if (NameEq(yytext, "SHOW")) return(SHOW) ;
         if (NameEq(yytext, "P")) return(SHOW) ;
         if (NameEq(yytext, "OFF")) return(OFF) ;
         if (NameEq(yytext, "Q")) return(OFF) ;
         if (NameEq(yytext, "QUIT")) return(OFF) ;
         if (yytext[0] == '!') {
            code = SHELL_COMMAND ;
         } else {
            code = SHELL_QUERY ;
         }
      } else {

         /* not first token, check for operator names */

         if (NameEq(yytext, "LID")) return(LID) ;
         if (NameEq(yytext, "AID")) return(AID) ;
         if (NameEq(yytext, "AND")) return(AND) ;
         if (NameEq(yytext, "OR")) return(OR) ;
         if (NameEq(yytext, "NOT")) return(NOT) ;
         if (NameEq(yytext, "MATCH")) return(MATCH) ;
         if ((yytext[0] == 's' || yytext[0] == 'S') && isdigit(yytext[1])) {
            
            /* this might be a set specification */
            
            sp = &yytext[1] ;
            val = 0 ;
            for ( ; ; ) {
               c = *sp++ ;
               if (c == '\0') {
                  if (val < NextSetNum) {
                     yylval.setdef = TheSets[val] ;
                     return(SET) ;
                  }
               }
               if (isdigit(c)) {
                  val = (val * 10) + (c - '0') ;
               } else {
                  break ;
               }
            }
         }
      }
      yylval.strdef = (id_type *)malloc(sizeof(id_type) + strlen(yytext)) ;
      if (yylval.strdef == NULL) {
         fatal("Out of memory in yylex") ;
      }
      yylval.strdef->next_id = NULL ;
      if (code == SHELL_COMMAND) {
         strcpy(yylval.strdef->id, &yytext[1]) ;
      } else {
         strcpy(yylval.strdef->id, yytext) ;
      }
      return(code) ;
   }
}

/* The main program for iid - parse the command line, initialize processing,
 * loop processing one command at a time.
 */
main(argc, argv)
   int         argc ;
   char *      argv [ ] ;
{
   int         c ;                     /* current option */
   char *      CmdPtr ;                /* Points to the command string */
   char        Command [ MAXCMD ] ;    /* Buffer for reading commands */
   int         Do1 = FALSE ;           /* TRUE if should only do 1 command */
   int         DoPrompt ;              /* TRUE if should write a prompt */
   int         errors = 0 ;            /* error count */

   _wildcard(&argc, &argv) ;
   DoPrompt = isatty(fileno(stdin)) ;
   while ((c = getopt(argc, argv, "Hac:")) != EOF) {
      switch(c) {
      case 'a':
         DefaultCommand = "aid -kmn" ;
         break ;
      case 'c':
         CmdPtr = optarg ;
         Do1 = TRUE ;
         break ;
      case 'H':
         fputs("\
iid: interactive ID database query tool. Call with:\n\
   iid [-a] [-c] [-H]\n\
\n\
-a\tUse the aid as the default query command (not lid).\n\
-c cmd\tExecute the single query cmd and exit.\n\
-H\tPrint this message and exit.\n\
\n\
To get help after starting program type 'help'.\n\
",stderr) ;
         exit(0) ;
      default:
         ++errors ;
         break ;
      }
   }
   if (argc != optind) {
      fputs("iid: Excess arguments ignored.\n",stderr) ;
      ++errors ;
   }
   if (errors) {
      fputs("run iid -H for help.\n",stderr) ;
      exit(1) ;
   }

   /* initialize global data */

   InitIid() ;

   /* run the parser */

   if (Do1) {           
      ScanInit(CmdPtr) ;
      exit(yyparse()) ;
   } else {
      for ( ; ; ) {
         if (DoPrompt) {
            fputs(Prompt, stdout) ;
            fflush(stdout) ;
         }
         gets(Command) ;
         if (feof(stdin)) {
            if (DoPrompt) fputs("\n", stdout) ;
            strcpy(Command, "off") ;
         }
         ScanInit(Command) ;
         errors += yyparse() ;
      }
   }
}
short yyexca[] ={
-1, 1,
	0, -1,
	-2, 0,
	};
# define YYNPROD 30
# define YYLAST 236
short yyact[]={

  21,   9,  10,  31,  44,   2,   6,  11,  12,   5,
   7,   8,  32,  31,  40,  39,  29,  28,  43,  35,
  13,  26,  14,  34,  27,   4,   3,  25,   1,  19,
  18,  15,   0,   0,   0,  30,   0,   0,   0,  33,
   0,   0,   0,   0,  36,   0,   0,  37,  38,   0,
   0,   0,   0,   0,  41,  42,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,  17,  22,   0,
   0,  23,  24,   0,   0,   0,   0,   0,   0,   0,
  20,   0,   0,  16,  32,  31 };
short yypact[]={

-258,-1000,-238, -40, -40,-236,-1000,-1000,-1000,-241,
-241,-1000,-1000,-1000,-259,-1000, -40,-1000,-1000,-1000,
-239, -40,-1000,-239,-239,-259,-1000,-243,-1000,-1000,
-243, -40, -40,-1000,-240,-1000, -37,-240,-240,-1000,
-1000,-1000,-269,-1000,-1000 };
short yypgo[]={

   0,  22,  31,  30,  29,  23,  24,  28,  26,  25 };
short yyr1[]={

   0,   7,   7,   7,   7,   7,   7,   7,   7,   7,
   8,   9,   1,   1,   1,   1,   2,   2,   2,   2,
   2,   3,   3,   4,   6,   6,   6,   6,   5,   5 };
short yyr2[]={

   0,   2,   2,   2,   2,   1,   1,   1,   2,   2,
   1,   1,   1,   3,   3,   2,   1,   1,   1,   2,
   3,   1,   2,   2,   1,   1,   2,   2,   1,   2 };
short yychk[]={

-1000,  -7, 263,  -8,  -9, 267, 264, 268, 269, 259,
 260, 265, 266, 258,  -1,  -2, 273, 257,  -3,  -4,
 270,  40, 258, 261, 262,  -1, 257,  -6, 258, 257,
  -6, 272, 271,  -1,  -5, 258,  -1,  -5,  -5, 258,
 257,  -1,  -1, 258,  41 };
short yydef[]={

   0,  -2,   0,   0,   0,   0,   5,   6,   7,   0,
   0,  10,  11,   1,   2,  12,   0,  16,  17,  18,
   0,   0,  21,   0,   0,   3,   4,   8,  24,  25,
   9,   0,   0,  15,  19,  28,   0,  22,  23,  26,
  27,  13,  14,  29,  20 };
#ifndef lint
static char *yaccpar_rcsid_sony = "$Header: yaccpar,v 1.2 89/09/14 09:30:12 root Exp $ SONY;";
#endif
#ifndef lint
static char yaccpar_sccsid[] = "@(#)yaccpar	4.1	(Berkeley)	2/11/83";
#endif not lint

#
# define YYFLAG -1000
# define YYERROR goto yyerrlab
# define YYACCEPT return(0)
# define YYABORT return(1)

/*	parser for yacc output	*/

#ifdef YYDEBUG
int yydebug = 0; /* 1 for debugging */
#endif
YYSTYPE yyv[YYMAXDEPTH]; /* where the values are stored */
int yychar = -1; /* current input token number */
int yynerrs = 0;  /* number of errors */
short yyerrflag = 0;  /* error recovery flag */

yyparse() {

	short yys[YYMAXDEPTH];
	short yyj, yym;
	register YYSTYPE *yypvt;
	register short yystate, *yyps, yyn;
	register YYSTYPE *yypv;
	register short *yyxi;

	yystate = 0;
	yychar = -1;
	yynerrs = 0;
	yyerrflag = 0;
	yyps= &yys[-1];
	yypv= &yyv[-1];

 yystack:    /* put a state and value onto the stack */

#ifdef YYDEBUG
	if( yydebug  ) printf( "state %d, char 0%o\n", yystate, yychar );
#endif
		if( ++yyps> &yys[YYMAXDEPTH] ) { yyerror( "yacc stack overflow" ); return(1); }
		*yyps = yystate;
		++yypv;
		*yypv = yyval;

 yynewstate:

	yyn = yypact[yystate];

	if( yyn<= YYFLAG ) goto yydefault; /* simple state */

	if( yychar<0 ) if( (yychar=yylex())<0 ) yychar=0;
	if( (yyn += yychar)<0 || yyn >= YYLAST ) goto yydefault;

	if( yychk[ yyn=yyact[ yyn ] ] == yychar ){ /* valid shift */
		yychar = -1;
		yyval = yylval;
		yystate = yyn;
		if( yyerrflag > 0 ) --yyerrflag;
		goto yystack;
		}

 yydefault:
	/* default state action */

	if( (yyn=yydef[yystate]) == -2 ) {
		if( yychar<0 ) if( (yychar=yylex())<0 ) yychar = 0;
		/* look through exception table */

		for( yyxi=yyexca; (*yyxi!= (-1)) || (yyxi[1]!=yystate) ; yyxi += 2 ) ; /* VOID */

		while( *(yyxi+=2) >= 0 ){
			if( *yyxi == yychar ) break;
			}
		if( (yyn = yyxi[1]) < 0 ) return(0);   /* accept */
		}

	if( yyn == 0 ){ /* error */
		/* error ... attempt to resume parsing */

		switch( yyerrflag ){

		case 0:   /* brand new error */

			yyerror( "syntax error" );
		yyerrlab:
			++yynerrs;

		case 1:
		case 2: /* incompletely recovered error ... try again */

			yyerrflag = 3;

			/* find a state where "error" is a legal shift action */

			while ( yyps >= yys ) {
			   yyn = yypact[*yyps] + YYERRCODE;
			   if( yyn>= 0 && yyn < YYLAST && yychk[yyact[yyn]] == YYERRCODE ){
			      yystate = yyact[yyn];  /* simulate a shift of "error" */
			      goto yystack;
			      }
			   yyn = yypact[*yyps];

			   /* the current yyps has no shift onn "error", pop stack */

#ifdef YYDEBUG
			   if( yydebug ) printf( "error recovery pops state %d, uncovers %d\n", *yyps, yyps[-1] );
#endif
			   --yyps;
			   --yypv;
			   }

			/* there is no state on the stack with an error shift ... abort */

	yyabort:
			return(1);


		case 3:  /* no shift yet; clobber input char */

#ifdef YYDEBUG
			if( yydebug ) printf( "error recovery discards char %d\n", yychar );
#endif

			if( yychar == 0 ) goto yyabort; /* don't discard EOF, quit */
			yychar = -1;
			goto yynewstate;   /* try again in the same state */

			}

		}

	/* reduction by production yyn */

#ifdef YYDEBUG
		if( yydebug ) printf("reduce %d\n",yyn);
#endif
		yyps -= yyr2[yyn];
		yypvt = yypv;
		yypv -= yyr2[yyn];
		yyval = yypv[1];
		yym=yyn;
			/* consult goto table to find next state */
		yyn = yyr1[yyn];
		yyj = yypgo[yyn] + *yyps + 1;
		if( yyj>=YYLAST || yychk[ yystate = yyact[yyj] ] != -yyn ) yystate = yyact[yypgo[yyn]];
		switch(yym){
			
case 1:
# line 39 "iid.y"
{
         /* cd to the directory specified as argument, flush sets */

         SetDirectory(yypvt[-0]. strdef ) ;
         FlushSets() ;
      } break;
case 3:
# line 47 "iid.y"
{
         /* print the list of files resulting from Query */

         PrintSet(yypvt[-0]. setdef ) ;
      } break;
case 4:
# line 53 "iid.y"
{
         /* run PAGER on the list of files in SET */

         RunPager(Pager, yypvt[-0]. setdef ) ;
      } break;
case 5:
# line 59 "iid.y"
{
         /* describe sets created so far */

         DescribeSets() ;
      } break;
case 6:
# line 65 "iid.y"
{
         /* run PAGER on the help file */

         RunPager(Pager, HelpSet) ;
      } break;
case 7:
# line 71 "iid.y"
{
         exit(0) ;
      } break;
case 8:
# line 75 "iid.y"
{
         /* run the shell command and eat the results as a file set */

         OneDescription(RunProg(yypvt[-1]. strdef ->id, yypvt[-0]. listdef )) ;
         free(yypvt[-1]. strdef ) ;
      } break;
case 9:
# line 82 "iid.y"
{
         /* run the shell command */

         RunShell(yypvt[-1]. strdef ->id, yypvt[-0]. listdef ) ;
         free(yypvt[-1]. strdef ) ;
      } break;
case 10:
# line 92 "iid.y"
{
         /* Turn on verbose query flag */

         VerboseQuery = TRUE ;
      } break;
case 11:
# line 101 "iid.y"
{
         /* Turn off verbose query flag */

         VerboseQuery = FALSE ;
      } break;
case 12:
# line 110 "iid.y"
{
         /* value of query is set associated with primitive */

         yyval. setdef  = yypvt[-0]. setdef  ;
      } break;
case 13:
# line 116 "iid.y"
{
         /* value of query is intersection of the two query sets */

         yyval. setdef  = SetIntersect(yypvt[-2]. setdef , yypvt[-0]. setdef ) ;
         if (VerboseQuery) {
            OneDescription(yyval. setdef ) ;
         }
      } break;
case 14:
# line 125 "iid.y"
{
         /* value of query is union of the two query sets */

         yyval. setdef  = SetUnion(yypvt[-2]. setdef , yypvt[-0]. setdef ) ;
         if (VerboseQuery) {
            OneDescription(yyval. setdef ) ;
         }
      } break;
case 15:
# line 134 "iid.y"
{
         /* value of query is inverse of other query */
         
         yyval. setdef  = SetInverse(yypvt[-0]. setdef ) ;
         if (VerboseQuery) {
            OneDescription(yyval. setdef ) ;
         }
      } break;
case 16:
# line 146 "iid.y"
{
         /* Value of primitive is value of recorded set */

         yyval. setdef  = yypvt[-0]. setdef  ;
      } break;
case 17:
# line 152 "iid.y"
{
         /* Value of primitive is obtained by running an lid query */

         yyval. setdef  = RunProg(LidCommand, yypvt[-0]. listdef ) ;
         if (VerboseQuery) {
            OneDescription(yyval. setdef ) ;
         }
      } break;
case 18:
# line 161 "iid.y"
{
         /* Value of primitive is obtained by running an aid query */

         yyval. setdef  = RunProg("aid -kmn", yypvt[-0]. listdef ) ;
         if (VerboseQuery) {
            OneDescription(yyval. setdef ) ;
         }
      } break;
case 19:
# line 170 "iid.y"
{
         /* Match names from database against pattern */
         yyval. setdef  = RunProg("pid -kmn", yypvt[-0]. listdef ) ;
         if (VerboseQuery) {
            OneDescription(yyval. setdef ) ;
         }
      } break;
case 20:
# line 178 "iid.y"
{
         /* value of primitive is value of query */

         yyval. setdef  = yypvt[-1]. setdef  ;
      } break;
case 21:
# line 187 "iid.y"
{
         /* make arg list holding single ID */

         yyval. listdef  = InitList() ;
         yyval. listdef  = ExtendList(yyval. listdef , yypvt[-0]. strdef ) ;
         LidCommand = DefaultCommand ;
      } break;
case 22:
# line 195 "iid.y"
{
         /* arg list is Id_list */

         yyval. listdef  = yypvt[-0]. listdef  ;
         LidCommand = "lid -kmn" ;
      } break;
case 23:
# line 205 "iid.y"
{
         /* arg list is Id_list */

         yyval. listdef  = yypvt[-0]. listdef  ;
      } break;
case 24:
# line 214 "iid.y"
{
         /* make arg list holding single ID */

         yyval. listdef  = InitList() ;
         yyval. listdef  = ExtendList(yyval. listdef , yypvt[-0]. strdef ) ;
      } break;
case 25:
# line 221 "iid.y"
{
         /* make arg list holding names from set */

         yyval. listdef  = InitList() ;
         yyval. listdef  = SetList(yyval. listdef , yypvt[-0]. setdef ) ;
      } break;
case 26:
# line 228 "iid.y"
{
         /* extend arg list with additional ID */

         yyval. listdef  = ExtendList(yypvt[-1]. listdef , yypvt[-0]. strdef ) ;
      } break;
case 27:
# line 234 "iid.y"
{
         /* extend arg list with additional file names */

         yyval. listdef  = SetList(yypvt[-1]. listdef , yypvt[-0]. setdef ) ;
      } break;
case 28:
# line 243 "iid.y"
{
         /* make arg list holding single ID */

         yyval. listdef  = InitList() ;
         yyval. listdef  = ExtendList(yyval. listdef , yypvt[-0]. strdef ) ;
      } break;
case 29:
# line 250 "iid.y"
{
         /* extend arg list with additional ID */

         yyval. listdef  = ExtendList(yypvt[-1]. listdef , yypvt[-0]. strdef ) ;
      } break;
		}
		goto yystack;  /* stack new state and value */

	}
