/* $Id: MsqlException.java,v 2.2 1998/11/13 01:54:35 borg Exp $ */
/* Copyright  1997-1998 George Reese, All Rights Reserved */
package com.imaginary.sql.msql;

import java.sql.SQLException;

/**
 * This class is an SQLException that has special constructors for
 * messages directly from mSQL.<BR>
 * Last modified $Date: 1998/11/13 01:54:35 $
 * @version $Revision: 2.2 $
 * @author George Reese (borg@imaginary.com)
 */
public class MsqlException extends SQLException {
    /**
     * Constructs an MsqlException based on an error message from mSQL.
     * @param data an error message
     */
    public MsqlException(String data) {
	super(data);
    }

    /**
     * Constructs an MsqlException based on some odd exception.
     * @param e the exception that caused this to be thrown.
     */
    public MsqlException(Exception e) {
	super(e.getMessage());
	if( e instanceof SQLException ) {
	    setNextException((SQLException)e);
	}
    }
}
