/*
 * Decompiled with CFR 0.152.
 */
import com.imaginary.sql.msql.MsqlDataSource;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Hashtable;
import javax.naming.InitialContext;
import javax.sql.DataSource;

public class JNDIUser {
    public static void main(String[] stringArray) {
        if (stringArray.length > 0 && stringArray[0].equals("install")) {
            try {
                JNDIUser.registerDataSource();
                System.out.println("Data source 'jdbc/test' installed.");
            }
            catch (Exception exception) {
                exception.printStackTrace();
                System.out.println("Install failed.");
            }
            return;
        }
        try {
            InitialContext initialContext = new InitialContext();
            initialContext.addToEnvironment("java.naming.factory.initial", "com.sun.jndi.fscontext.RefFSContextFactory");
            DataSource dataSource = (DataSource)initialContext.lookup("/tmp/jdbc/test");
            Connection connection = dataSource.getConnection("borg", "");
            Statement statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery("SELECT test_id, test_int, test_date, test_char, test_val FROM test ORDER BY test_id");
            System.out.println("Got results:");
            while (resultSet.next()) {
                int n = resultSet.getInt(1);
                String string = "";
                System.out.print("\tkey: " + n + "(");
                n = resultSet.getInt(2);
                if (!resultSet.wasNull()) {
                    System.out.print("test_int=" + n);
                    string = ",";
                }
                Date date = resultSet.getDate(3);
                if (!resultSet.wasNull()) {
                    System.out.print(String.valueOf(string) + "test_date=" + date);
                    string = ",";
                }
                String string2 = resultSet.getString(4);
                if (!resultSet.wasNull()) {
                    System.out.print(String.valueOf(string) + "test_char='" + string2 + "'");
                    string = ",";
                }
                string2 = resultSet.getString(5);
                if (!resultSet.wasNull()) {
                    System.out.print(String.valueOf(string) + "test_val='" + string2 + "'");
                }
                System.out.println(")");
            }
            connection.close();
            System.out.println("Done.");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void registerDataSource() throws Exception {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("java.naming.factory.initial", "com.sun.jndi.fscontext.RefFSContextFactory");
        InitialContext initialContext = new InitialContext(hashtable);
        MsqlDataSource msqlDataSource = new MsqlDataSource();
        msqlDataSource.setServerName("carthage.imaginary.com");
        msqlDataSource.setDatabaseName("test");
        initialContext.bind("/tmp/jdbc/test", (Object)msqlDataSource);
        initialContext.close();
    }
}

