/* REXX                                                              */
/* Allgemeine Installationsroutine                                   */
/* --- angepasst an LSZipWizard v.1.20ff. ---                        */
/* Lothar Sns, 2021                                                 */
/* ----------------------------------------------------------------- */
/* Funktionen:                                                       */
/* - prfen, ob notwendige Dateien vorhanden                         */
/* - WPS-Programmsymbol erzeugen                                     */
/* Voraussetzung:                                                    */
/* - Dateien befinden sich im aktuellen Verzeichnis                  */
/* Argumente:                                                        */
/* - (keine)    = Installieren/Update                                */
/* - /UNINSTALL = Deinstallieren                                     */
/* ----------------------------------------------------------------- */

ARG argument

/* RexxUtil-Funktionen laden                                         */
call RxFuncAdd 'SysLoadFuncs' , RexxUtil, 'SysLoadFuncs'
call SysLoadFuncs

/* Konstanten fr diese Installation (anpassen)                      */
Objid        = '<LSOE_ZIPWIZARD>'                         /* Pflicht */
ProgramTitle = 'LSZipWizard'                              /* Pflicht */
ExeFile      = 'LSZipWiz.EXE'                             /* Pflicht */
HelpFile     = 'LSZipWiz.HLP'                             /* Kann    */
HelpFile_EN  = 'LSZIP_EN.HLP'                             /* Kann    */
HelpFile_DE  = 'LSZIP_DE.HLP'                             /* Kann    */
AddFile1     = ''                                         /* Kann    */
AddFile2     = ''                                         /* Kann    */
Applicn      = 'LSZipWizard2'                             /* Kann    */
InstallDir   = Directory()        /* Default = aktuelles Verzeichnis */
WorkingDir   = Directory()                     /* Arbeitsverzeichnis */
HelpLang     = 'EN'                                       /* Kann    */

/* Weitere Optionen fr das Objekt                                   */
/* Parm = '%'   heit keine Parameter bergeben                      */
Parm         = ''
/* Zuordnungs-Angaben, mit Kommata trennen                           */
DateiType    = ',,'
DateiFilter  = '*.ZIP,*.*.ZIP,*.*.*.ZIP,,'

SELECT
when length(argument) < 1     then call Installieren
when argument == '/UNINSTALL' then call Deinstallieren
otherwise say 'Invalid argument. Nothing done.'
END
EXIT

/* ----------------------------------------------------------------- */
Installieren:
call SysCls

say 'Ŀ'
say '                  REXX installation routine                    '
say ''
say
say 'A program object will be created on the WPS desktop, named:'
say '    >>>' ProgramTitle '<<<'
say 'Subsequently, you might move it into any folder you like.'
say
say 'Installation directory:'
say '   ' InstallDir
say
say 'Enter help language {EN(default)|DE}:'
pull xlang
if xlang = 'DE' then HelpLang = 'DE'
say

/* Exe-File vorhanden?                                               */
say 'Lookup file:' ExeFile || '......'
if Stream(ExeFile,'C','Query Exists') = '' then do
      say 'File' ExeFile 'not found in' InstallDir
      say ExeFile 'must reside in this directory for the installation.'
      say 'Cancelled ...'
      RETURN
      end
say '... detected.'

/* HelpFile_EN  vorhanden?                                           */
if HelpFile_EN <> '' & HelpLang = 'EN' then do
   say 'Lookup file:' HelpFile_EN || '......'
   if Stream(HelpFile_EN,'C','Query Exists') = '' then do
      say 'File' HelpFile_EN 'not found in' InstallDir
      say HelpFile_EN 'must reside in this directory for the installation.'
      say 'Cancelled ...'
      RETURN
      end
   say '... detected.'
   end

/* HelpFile_DE  vorhanden?                                           */
if HelpFile_DE <> '' & HelpLang = 'DE' then do
   say 'Lookup file:' HelpFile_DE || '......'
   if Stream(HelpFile_DE,'C','Query Exists') = '' then do
      say 'File' HelpFile_DE 'not found in' InstallDir
      say HelpFile_DE 'must reside in this directory for the installation.'
      say 'Cancelled ...'
      RETURN
      end
   say '... detected.'
   end

/* AddFile1  vorhanden?                                              */
if AddFile1 <> '' then do
   say 'Lookup file:' AddFile1 || '......'
   if Stream(AddFile1,'C','Query Exists') = '' then do
      say 'File' AddFile1 'not found in' InstallDir
      say AddFile1 'must reside in this directory for the installation.'
      say 'Cancelled ...'
      RETURN
      end
   say '... detected.'
   end

/* AddFile2  vorhanden?                                              */
if AddFile2 <> '' then do
   say 'Lookup file:' AddFile2 || '......'
   if Stream(AddFile1,'C','Query Exists') = '' then do
      say 'File' AddFile2 'not found in' InstallDir
      say AddFile2 'must reside in this directory for the installation.'
      say 'Cancelled ...'
      RETURN
      end
   say '... detected.'
   end

/* HelpFile je Sprache kopieren */
select
when HelpLang = 'DE' then do
    '@copy' HelpFile_DE HelpFile '1>NUL 2>&1'
    end
otherwise do
    '@copy' HelpFile_EN HelpFile '1>NUL 2>&1'
    end
end

/* HelpFile vorhanden?          */
if HelpFile <> '%' then do
   say 'Lookup file:' HelpFile || '......'
   if Stream(HelpFile,'C','Query Exists') = '' then do
      say 'File' HelpFile 'not found in' InstallDir
      say HelpFile 'must reside in this directory for the installation.'
      say 'Cancelled ...'
      RETURN
      end
   say '... detected.'
   end

/* WPS-Objekt erzeugen (auf dem Desktop)   */
/* Optionen concatenieren (anpassen!)      */
OptionString = 'OBJECTID='objid||,
               ';PROGTYPE=PM'||,
               ';TITLE='ProgramTitle||,
               ';EXENAME='InstallDir'\'ExeFile||,
               ';STARTUPDIR='WorkingDir||,
               ';PARAMETERS='Parm||,
               ';ASSOCTYPE='DateiType||,
               ';ASSOCFILTER='DateiFilter||,
               ';'

/* Was soll passieren, wenn das Objekt schon existiert? */
Action = 'UPDATE'

say
say 'Create the program object ......'
rc1 = SysCreateObject('WPProgram',,
                     ProgramTitle,,
                     '<WP_DESKTOP>',,
                     OptionString,,
                     Action)
/* erfolgreich?  */
if rc1 = 0 then do
    say '... failed !!!'
    end
else do
    DateiType   = strip(DateiType,'T',',')
    DateiFilter = strip(DateiFilter,'T',',')
    say '... successfully installed/updated.'
    if length(DateiType)   > 0 then do
       say
       say 'The following [additional] file types are associated to the program:'
       say DateiType
       end
    if length(DateiFilter) > 0 then do
       say
       say 'The following [additional] file extensions are associated to the program:'
       say DateiFilter
       end
    end

say
say 'Installation routine completed.'
RETURN

/* ----------------------------------------------------------------- */
Deinstallieren:
call SysCls
say 'Ŀ'
say '                  REXX uninstallation routine                  '
say ''
say
say 'Do you really want to uninstall'
say '    >>>' ProgramTitle '<<< ?  (YES to continue, else to quit)'
parse pull answer
if answer \== 'YES' then do
   say '.... Nothing to do, quit.'
   RETURN
   end

say
say 'Clear current program settings ......'
ret = SysIni('USER',Applicn,'DELETE:')
say '.... done!'

say
say 'Destroy program object ......'
rc1 = SysDestroyObject(objid)
if rc1 \= 0 then do
   say '.... done!'
   end

say
say "Uninstallation routine completed."
say "You may cleanup the program's directory yourself later."
RETURN
/* ----------------------------------------------------------------- */


