/*
 * Decompiled with CFR 0.152.
 */
package jscicalc.graph;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Path2D;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JFrame;
import javax.swing.JPanel;
import jscicalc.graph.Point;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PointList
extends Vector<Point> {
    private final double eps = 1.0E-10;
    private static final long serialVersionUID = 1L;

    public void addToPath(Path2D.Double double_, AtomicBoolean atomicBoolean) {
        System.out.println("add to path");
        if (this.size() == 0) {
            return;
        }
        if (this.size() == 1) {
            Point point = (Point)this.firstElement();
            double_.moveTo(point.getX(), point.getY());
        } else {
            double[][] dArray = this.controlPoints(atomicBoolean);
            if (atomicBoolean.get()) {
                return;
            }
            Point point = (Point)this.firstElement();
            double d = point.getX();
            double d2 = point.getY();
            double_.moveTo(d, d2);
            for (int i = 1; i < this.size(); ++i) {
                double d3 = dArray[0][2 * i - 2];
                double d4 = dArray[0][2 * i - 1];
                double d5 = dArray[1][2 * i - 2];
                double d6 = dArray[1][2 * i - 1];
                point = (Point)this.elementAt(i);
                double d7 = point.getX();
                double d8 = point.getY();
                double_.curveTo(d3, d5, d4, d6, d7, d8);
                d = d7;
                d2 = d8;
            }
        }
    }

    private double gradient(int n, double[] dArray) {
        if (n == 0) {
            Point point = (Point)this.elementAt(n);
            Point point2 = (Point)this.elementAt(n + 1);
            double d = point2.getX() - point.getX();
            double d2 = point2.getY() - point.getY();
            return d2 / d - d * (dArray[n + 1] - dArray[n]) / 6.0 + d * dArray[n + 1] / 2.0;
        }
        Point point = (Point)this.elementAt(n - 1);
        Point point3 = (Point)this.elementAt(n);
        double d = point3.getX() - point.getX();
        double d3 = point3.getY() - point.getY();
        return d3 / d - d * (dArray[n] - dArray[n - 1]) / 6.0 - d * dArray[n - 1] / 2.0;
    }

    private double[][] controlPoints(AtomicBoolean atomicBoolean) {
        int n;
        int n2 = this.size();
        double[][] dArray = new double[2][2 * n2 - 2];
        double[][] dArray2 = new double[2 * n2 - 2][2 * n2 - 2];
        dArray2[0][0] = 3.0;
        for (int i = 1; i < n2 - 1; ++i) {
            if (atomicBoolean.get()) {
                return null;
            }
            dArray2[2 * i - 1][2 * i - 2] = 1.0;
            dArray2[2 * i - 1][2 * i - 1] = -2.0;
            dArray2[2 * i - 1][2 * i] = 2.0;
            dArray2[2 * i - 1][2 * i + 1] = -1.0;
            dArray2[2 * i][2 * i - 1] = 1.0;
            dArray2[2 * i][2 * i] = 1.0;
        }
        dArray2[2 * n2 - 3][2 * n2 - 3] = 3.0;
        PointList.LU_decompose(dArray2, atomicBoolean);
        if (atomicBoolean.get()) {
            return null;
        }
        double[] dArray3 = new double[2 * n2 - 2];
        dArray3[0] = 2.0 * ((Point)this.elementAt(0)).getX() + ((Point)this.elementAt(1)).getX();
        for (n = 1; n < n2 - 1; ++n) {
            if (atomicBoolean.get()) {
                return null;
            }
            dArray3[2 * n] = 2.0 * ((Point)this.elementAt(n)).getX();
        }
        dArray3[2 * n2 - 3] = ((Point)this.elementAt(n2 - 2)).getX() + 2.0 * ((Point)this.elementAt(n2 - 1)).getX();
        dArray[0] = PointList.LU_solve(dArray2, dArray3, atomicBoolean);
        if (atomicBoolean.get()) {
            return null;
        }
        dArray3[0] = 2.0 * ((Point)this.elementAt(0)).getY() + ((Point)this.elementAt(1)).getY();
        for (n = 1; n < n2 - 1; ++n) {
            dArray3[2 * n] = 2.0 * ((Point)this.elementAt(n)).getY();
        }
        dArray3[2 * n2 - 3] = ((Point)this.elementAt(n2 - 2)).getY() + 2.0 * ((Point)this.elementAt(n2 - 1)).getY();
        dArray[1] = PointList.LU_solve(dArray2, dArray3, atomicBoolean);
        if (atomicBoolean.get()) {
            return null;
        }
        return dArray;
    }

    private static void LU_decompose(double[][] dArray, AtomicBoolean atomicBoolean) {
        int n = dArray.length;
        for (int i = 0; i < n - 1; ++i) {
            System.out.print("-");
            for (int j = i + 1; j < n; ++j) {
                if (atomicBoolean.get()) {
                    return;
                }
                double[] dArray2 = dArray[j];
                int n2 = i;
                dArray2[n2] = dArray2[n2] / dArray[i][i];
                for (int k = i + 1; k < n; ++k) {
                    double[] dArray3 = dArray[j];
                    int n3 = k;
                    dArray3[n3] = dArray3[n3] - dArray[j][i] * dArray[i][k];
                }
            }
        }
    }

    private static double[] LU_solve(double[][] dArray, double[] dArray2, AtomicBoolean atomicBoolean) {
        int n;
        double d;
        int n2;
        int n3 = dArray2.length;
        double[] dArray3 = new double[n3];
        dArray3[0] = dArray2[0];
        for (n2 = 1; n2 < n3; ++n2) {
            System.out.print("+");
            if (atomicBoolean.get()) {
                return null;
            }
            d = 0.0;
            for (n = 0; n < n2; ++n) {
                d += dArray[n2][n] * dArray3[n];
            }
            dArray3[n2] = dArray2[n2] - d;
        }
        int n4 = n3 - 1;
        dArray3[n4] = dArray3[n4] / dArray[n3 - 1][n3 - 1];
        for (n2 = n3 - 2; n2 >= 0; --n2) {
            System.out.print("=");
            if (atomicBoolean.get()) {
                return null;
            }
            d = 0.0;
            for (n = n2 + 1; n < n3; ++n) {
                d += dArray[n2][n] * dArray3[n];
            }
            int n5 = n2;
            dArray3[n5] = dArray3[n5] - d;
            int n6 = n2;
            dArray3[n6] = dArray3[n6] / dArray[n2][n2];
        }
        return dArray3;
    }

    public static void main(String[] stringArray) {
        Path2D.Double double_ = new Path2D.Double();
        PointList pointList = new PointList();
        pointList.add(new Point(100.0, 280.0));
        pointList.add(new Point(200.0, 220.0));
        pointList.add(new Point(300.0, 200.0));
        pointList.add(new Point(400.0, 180.0));
        pointList.add(new Point(500.0, 120.0));
        AtomicBoolean atomicBoolean = new AtomicBoolean(false);
        pointList.addToPath(double_, atomicBoolean);
        MyView myView = new MyView(double_);
        JFrame jFrame = new JFrame("PointList Test");
        jFrame.setSize(600, 400);
        jFrame.setContentPane(myView);
        jFrame.setDefaultCloseOperation(3);
        jFrame.setVisible(true);
    }

    static class MyView
    extends JPanel {
        Path2D.Double path;
        private static final long serialVersionUID = 1L;

        MyView(Path2D.Double double_) {
            this.path = double_;
        }

        public void paint(Graphics graphics) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.draw(this.path);
        }
    }
}

