/*
 * Decompiled with CFR 0.152.
 */
package jscicalc.graph;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayDeque;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.Spring;
import javax.swing.SpringLayout;
import jscicalc.ReadOnlyCalculatorApplet;
import jscicalc.graph.Axis;
import jscicalc.graph.AxisData;
import jscicalc.graph.View;

public class AxisDialog
extends JFrame
implements ActionListener {
    private JLabel minimumLabel;
    private JLabel maximumLabel;
    private JLabel majorUnitLabel;
    private JLabel minorUnitLabel;
    private JTextField minimumTextBox;
    private JTextField maximumTextBox;
    private JTextField majorUnitTextBox;
    private JTextField minorUnitTextBox;
    private JLabel majorVisible;
    private JLabel minorVisible;
    private JCheckBox majorCheckBox;
    private JCheckBox minorCheckBox;
    private JButton applyButton;
    private JButton undoButton;
    private JButton okButton;
    private JButton cancelButton;
    private Spring smallGap;
    private Spring gap;
    private Spring buttonWidth;
    private Spring buttonHeight;
    private Spring textBoxWidth;
    private Spring labelWidth;
    private Spring visibleWidth;
    private ReadOnlyCalculatorApplet applet;
    private View view;
    private Axis axis;
    private ArrayDeque<AxisData> stack;
    private final boolean x;
    SpringLayout springLayout;
    private static final long serialVersionUID = 1L;

    public AxisDialog(ReadOnlyCalculatorApplet readOnlyCalculatorApplet, View view, Axis axis, boolean bl, String string) {
        super(string);
        this.applet = readOnlyCalculatorApplet;
        this.view = view;
        this.axis = axis;
        this.x = bl;
        this.stack = new ArrayDeque();
        this.minimumLabel = new JLabel("Minimum:");
        this.minimumLabel.setHorizontalAlignment(4);
        this.maximumLabel = new JLabel("Maximum:");
        this.maximumLabel.setHorizontalAlignment(4);
        this.majorUnitLabel = new JLabel("Major unit:");
        this.majorUnitLabel.setHorizontalAlignment(4);
        this.minorUnitLabel = new JLabel("Minor unit:");
        this.minorUnitLabel.setHorizontalAlignment(4);
        this.minimumTextBox = new JTextField();
        this.maximumTextBox = new JTextField();
        this.majorUnitTextBox = new JTextField();
        this.minorUnitTextBox = new JTextField();
        this.minimumLabel.setLabelFor(this.minimumTextBox);
        this.minimumLabel.setDisplayedMnemonic('n');
        this.minimumLabel.setToolTipText("Minimum value shown on chart");
        this.maximumLabel.setLabelFor(this.maximumTextBox);
        this.maximumLabel.setDisplayedMnemonic('x');
        this.maximumLabel.setToolTipText("Maximum value shown on chart");
        this.majorUnitLabel.setLabelFor(this.majorUnitTextBox);
        this.majorUnitLabel.setDisplayedMnemonic('j');
        this.majorUnitLabel.setToolTipText("Spacing between larger ticks with numerical scale");
        this.minorUnitLabel.setLabelFor(this.minorUnitTextBox);
        this.minorUnitLabel.setDisplayedMnemonic('i');
        this.minorUnitLabel.setToolTipText("Spacing between smalle ticks");
        this.majorCheckBox = new JCheckBox("visible", true);
        this.minorCheckBox = new JCheckBox("visible", true);
        this.applyButton = new JButton("Apply");
        this.applyButton.setMnemonic('A');
        this.applyButton.setToolTipText("Apply changes to graph");
        this.undoButton = new JButton("Undo");
        this.undoButton.setMnemonic('U');
        this.undoButton.setToolTipText("Undo most recently applied change");
        this.okButton = new JButton("OK");
        this.okButton.setMnemonic('O');
        this.okButton.setToolTipText("Apply changes to graph and quit");
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.setMnemonic('C');
        this.cancelButton.setToolTipText("Undo all changes and quit");
        this.undoButton.setEnabled(false);
        this.majorCheckBox.setMnemonic('s');
        this.minorCheckBox.setMnemonic('v');
        this.minimumTextBox.addFocusListener(new FieldFocusListener(this.minimumTextBox, false));
        this.maximumTextBox.addFocusListener(new FieldFocusListener(this.maximumTextBox, false));
        this.majorUnitTextBox.addFocusListener(new FieldFocusListener(this.majorUnitTextBox, true));
        this.minorUnitTextBox.addFocusListener(new FieldFocusListener(this.minorUnitTextBox, true));
        this.applyButton.addActionListener(new ApplyButtonListener());
        this.okButton.addActionListener(new OKButtonListener());
        this.undoButton.addActionListener(new UndoButtonListener());
        this.cancelButton.addActionListener(new CancelButtonListener());
        this.springLayout = new SpringLayout();
        this.setSizes();
        this.setDefaultCloseOperation(1);
        this.setResizable(false);
        Container container = this.getContentPane();
        container.setLayout(this.springLayout);
        container.add(this.minimumLabel);
        container.add(this.maximumLabel);
        container.add(this.majorUnitLabel);
        container.add(this.minorUnitLabel);
        container.add(this.minimumTextBox);
        container.add(this.maximumTextBox);
        container.add(this.majorUnitTextBox);
        container.add(this.minorUnitTextBox);
        container.add(this.majorCheckBox);
        container.add(this.minorCheckBox);
        container.add(this.applyButton);
        container.add(this.undoButton);
        container.add(this.okButton);
        container.add(this.cancelButton);
        this.layOut();
        this.setVisible(false);
    }

    private void layOut() {
        this.textBoxWidth = Spring.scale(this.buttonWidth, 1.0f);
        this.labelWidth = Spring.scale(this.buttonWidth, 1.0f);
        this.visibleWidth = Spring.scale(this.buttonWidth, 1.0f);
        SpringLayout.Constraints constraints = this.springLayout.getConstraints(this.minimumLabel);
        constraints.setWidth(this.labelWidth);
        constraints.setHeight(this.buttonHeight);
        constraints = this.springLayout.getConstraints(this.maximumLabel);
        constraints.setWidth(this.labelWidth);
        constraints.setHeight(this.buttonHeight);
        constraints = this.springLayout.getConstraints(this.majorUnitLabel);
        constraints.setWidth(this.labelWidth);
        constraints.setHeight(this.buttonHeight);
        constraints = this.springLayout.getConstraints(this.minorUnitLabel);
        constraints.setWidth(this.labelWidth);
        constraints.setHeight(this.buttonHeight);
        constraints = this.springLayout.getConstraints(this.minimumTextBox);
        constraints.setWidth(this.textBoxWidth);
        constraints.setHeight(this.buttonHeight);
        constraints = this.springLayout.getConstraints(this.maximumTextBox);
        constraints.setWidth(this.textBoxWidth);
        constraints.setHeight(this.buttonHeight);
        constraints = this.springLayout.getConstraints(this.majorUnitTextBox);
        constraints.setWidth(this.textBoxWidth);
        constraints.setHeight(this.buttonHeight);
        constraints = this.springLayout.getConstraints(this.minorUnitTextBox);
        constraints.setWidth(this.textBoxWidth);
        constraints.setHeight(this.buttonHeight);
        constraints = this.springLayout.getConstraints(this.majorCheckBox);
        constraints.setWidth(this.visibleWidth);
        constraints.setHeight(this.buttonHeight);
        constraints = this.springLayout.getConstraints(this.minorCheckBox);
        constraints.setWidth(this.visibleWidth);
        constraints.setHeight(this.buttonHeight);
        constraints = this.springLayout.getConstraints(this.applyButton);
        constraints.setWidth(this.buttonWidth);
        constraints.setHeight(this.buttonHeight);
        constraints = this.springLayout.getConstraints(this.undoButton);
        constraints.setWidth(this.buttonWidth);
        constraints.setHeight(this.buttonHeight);
        constraints = this.springLayout.getConstraints(this.okButton);
        constraints.setWidth(this.buttonWidth);
        constraints.setHeight(this.buttonHeight);
        constraints = this.springLayout.getConstraints(this.cancelButton);
        constraints.setWidth(this.buttonWidth);
        constraints.setHeight(this.buttonHeight);
        Container container = this.getContentPane();
        this.springLayout.putConstraint("North", (Component)this.minimumLabel, this.smallGap, "North", (Component)container);
        this.springLayout.putConstraint("West", (Component)this.minimumLabel, this.smallGap, "West", (Component)container);
        this.springLayout.putConstraint("North", (Component)this.maximumLabel, this.smallGap, "South", (Component)this.minimumLabel);
        this.springLayout.putConstraint("West", (Component)this.maximumLabel, this.smallGap, "West", (Component)container);
        this.springLayout.putConstraint("North", (Component)this.majorUnitLabel, this.gap, "South", (Component)this.maximumLabel);
        this.springLayout.putConstraint("West", (Component)this.majorUnitLabel, this.smallGap, "West", (Component)container);
        this.springLayout.putConstraint("North", (Component)this.minorUnitLabel, this.smallGap, "South", (Component)this.majorUnitLabel);
        this.springLayout.putConstraint("West", (Component)this.minorUnitLabel, this.smallGap, "West", (Component)container);
        this.springLayout.putConstraint("North", (Component)this.minimumTextBox, this.smallGap, "North", (Component)container);
        this.springLayout.putConstraint("West", (Component)this.minimumTextBox, this.smallGap, "East", (Component)this.minimumLabel);
        this.springLayout.putConstraint("North", (Component)this.maximumTextBox, this.smallGap, "South", (Component)this.minimumTextBox);
        this.springLayout.putConstraint("West", (Component)this.maximumTextBox, this.smallGap, "East", (Component)this.maximumLabel);
        this.springLayout.putConstraint("North", (Component)this.majorUnitTextBox, this.gap, "South", (Component)this.maximumTextBox);
        this.springLayout.putConstraint("West", (Component)this.majorUnitTextBox, this.smallGap, "East", (Component)this.majorUnitLabel);
        this.springLayout.putConstraint("North", (Component)this.minorUnitTextBox, this.smallGap, "South", (Component)this.majorUnitTextBox);
        this.springLayout.putConstraint("West", (Component)this.minorUnitTextBox, this.smallGap, "East", (Component)this.minorUnitLabel);
        this.springLayout.putConstraint("North", (Component)this.majorCheckBox, this.gap, "South", (Component)this.maximumTextBox);
        this.springLayout.putConstraint("West", (Component)this.majorCheckBox, this.smallGap, "East", (Component)this.majorUnitTextBox);
        this.springLayout.putConstraint("North", (Component)this.minorCheckBox, this.smallGap, "South", (Component)this.majorCheckBox);
        this.springLayout.putConstraint("West", (Component)this.minorCheckBox, this.smallGap, "East", (Component)this.minorUnitTextBox);
        this.springLayout.putConstraint("North", (Component)this.applyButton, this.gap, "South", (Component)this.minorUnitLabel);
        this.springLayout.putConstraint("West", (Component)this.applyButton, this.smallGap, "West", (Component)container);
        this.springLayout.putConstraint("North", (Component)this.undoButton, this.gap, "South", (Component)this.minorUnitLabel);
        this.springLayout.putConstraint("West", (Component)this.undoButton, this.smallGap, "East", (Component)this.applyButton);
        this.springLayout.putConstraint("North", (Component)this.okButton, this.gap, "South", (Component)this.minorUnitLabel);
        this.springLayout.putConstraint("West", (Component)this.okButton, this.smallGap, "East", (Component)this.undoButton);
        this.springLayout.putConstraint("North", (Component)this.cancelButton, this.gap, "South", (Component)this.minorUnitLabel);
        this.springLayout.putConstraint("West", (Component)this.cancelButton, this.smallGap, "East", (Component)this.okButton);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.setBounds();
        this.setVisible(true);
    }

    private boolean validateFields() {
        return true;
    }

    public void setBounds() {
        Object object;
        NumberFormat numberFormat;
        if ((float)this.minimumLabel.getFont().getSize() != this.applet.buttonTextSize() && this.setSizes()) {
            this.layOut();
        }
        if ((numberFormat = NumberFormat.getNumberInstance()) instanceof DecimalFormat) {
            object = (DecimalFormat)numberFormat;
            ((DecimalFormat)object).setNegativePrefix("\u2212");
        }
        object = this.stack.peekFirst();
        double d = 0.0;
        if (object == null) {
            object = new AxisData();
        } else {
            d = ((AxisData)object).maximum - ((AxisData)object).minimum;
        }
        if (this.x) {
            ((AxisData)object).minimum = this.view.getTransformation().toModelX(0.0);
            ((AxisData)object).maximum = this.view.getTransformation().toModelX(this.view.getWidth());
        } else {
            ((AxisData)object).minimum = this.view.getTransformation().toModelY(this.view.getHeight());
            ((AxisData)object).maximum = this.view.getTransformation().toModelY(0.0);
        }
        this.minimumTextBox.setText(numberFormat.format(((AxisData)object).minimum));
        this.maximumTextBox.setText(numberFormat.format(((AxisData)object).maximum));
        if (this.stack.size() == 0) {
            if (this.x) {
                ((AxisData)object).majorUnit = this.view.getTransformation().getXMajorUnit();
                ((AxisData)object).minorUnit = this.view.getTransformation().getXMinorUnit();
            } else {
                ((AxisData)object).minorUnit = this.view.getTransformation().getYMajorUnit();
                ((AxisData)object).minorUnit = this.view.getTransformation().getYMinorUnit();
            }
            this.majorUnitTextBox.setText(Double.toString(((AxisData)object).majorUnit));
            this.minorUnitTextBox.setText(Double.toString(((AxisData)object).minorUnit));
            this.majorCheckBox.setSelected(((AxisData)object).majorVisible);
            this.minorCheckBox.setSelected(((AxisData)object).minorVisible);
            this.stack.addFirst((AxisData)object);
        } else {
            double d2 = ((AxisData)object).maximum - ((AxisData)object).minimum;
            double d3 = (d2 - d) / 2.0;
            Iterator<AxisData> iterator = this.stack.iterator();
            if (iterator.hasNext()) {
                iterator.next();
                while (iterator.hasNext()) {
                    AxisData axisData = iterator.next();
                    axisData.maximum += d3;
                    axisData.minimum -= d3;
                }
            } else {
                System.err.println("AxisDialog.setBounds(): expected to find element on stack.");
            }
        }
    }

    public boolean setSizes() {
        boolean bl;
        this.setSize(this.applet.minSize() * 5 + this.applet.buttonWidth() * 4 + this.applet.getFrameInsets().left + this.applet.getFrameInsets().right, this.applet.minSize() * 4 + this.applet.strutSize() * 2 + this.applet.buttonHeight() * 5 + this.applet.getFrameInsets().top + this.applet.getFrameInsets().bottom);
        boolean bl2 = bl = (float)this.minimumLabel.getFont().getSize() != this.applet.buttonTextSize();
        if (bl) {
            this.smallGap = Spring.constant(this.applet.minSize());
            this.gap = Spring.constant(this.applet.strutSize());
            this.buttonWidth = Spring.constant(this.applet.buttonWidth());
            this.buttonHeight = Spring.constant(this.applet.buttonHeight());
            this.minimumLabel.setFont(this.minimumLabel.getFont().deriveFont(this.applet.buttonTextSize()));
            this.maximumLabel.setFont(this.maximumLabel.getFont().deriveFont(this.applet.buttonTextSize()));
            this.majorUnitLabel.setFont(this.majorUnitLabel.getFont().deriveFont(this.applet.buttonTextSize()));
            this.minorUnitLabel.setFont(this.minorUnitLabel.getFont().deriveFont(this.applet.buttonTextSize()));
            this.minimumTextBox.setFont(this.minimumTextBox.getFont().deriveFont(this.applet.buttonTextSize()));
            this.maximumTextBox.setFont(this.maximumTextBox.getFont().deriveFont(this.applet.buttonTextSize()));
            this.majorUnitTextBox.setFont(this.majorUnitTextBox.getFont().deriveFont(this.applet.buttonTextSize()));
            this.minorUnitTextBox.setFont(this.minorUnitTextBox.getFont().deriveFont(this.applet.buttonTextSize()));
            this.majorCheckBox.setFont(this.majorCheckBox.getFont().deriveFont(this.applet.buttonTextSize()));
            this.minorCheckBox.setFont(this.minorCheckBox.getFont().deriveFont(this.applet.buttonTextSize()));
            this.applyButton.setFont(this.applyButton.getFont().deriveFont(this.applet.buttonTextSize()));
            this.undoButton.setFont(this.undoButton.getFont().deriveFont(this.applet.buttonTextSize()));
            this.okButton.setFont(this.okButton.getFont().deriveFont(this.applet.buttonTextSize()));
            this.cancelButton.setFont(this.cancelButton.getFont().deriveFont(this.applet.buttonTextSize()));
        }
        return bl;
    }

    private boolean apply() {
        AxisData axisData = new AxisData();
        String string = this.minimumTextBox.getText();
        string = string.replace("\u2212", "-");
        try {
            axisData.minimum = Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        string = this.maximumTextBox.getText();
        string = string.replace("\u2212", "-");
        try {
            axisData.maximum = Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (axisData.maximum <= axisData.minimum) {
            JOptionPane.showMessageDialog(this, "The minimum must be less than the maximum.", "Java Scientific Calculator", 0);
            return false;
        }
        string = this.majorUnitTextBox.getText();
        string = string.replace("\u2212", "-");
        try {
            axisData.majorUnit = Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        string = this.minorUnitTextBox.getText();
        string = string.replace("\u2212", "-");
        try {
            axisData.minorUnit = Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (axisData.majorUnit < axisData.minorUnit) {
            JOptionPane.showMessageDialog(this, "The major unit must be no less than the minor unit.", "Java Scientific Calculator", 0);
            return false;
        }
        double d = axisData.majorUnit / axisData.minorUnit;
        if (d != Math.floor(d)) {
            JOptionPane.showMessageDialog(this, "The major unit must be an integer multiple the minor unit.", "Java Scientific Calculator", 0);
            return false;
        }
        axisData.majorVisible = this.majorCheckBox.isSelected();
        axisData.minorVisible = this.minorCheckBox.isSelected();
        if (axisData.equals(this.stack.peekFirst())) {
            return true;
        }
        boolean bl = !axisData.minMaxMatches(this.stack.peekFirst());
        this.stack.addFirst(axisData);
        this.undoButton.setEnabled(true);
        double d2 = (axisData.maximum + axisData.minimum) / 2.0;
        double d3 = axisData.maximum - axisData.minimum;
        if (this.x) {
            this.view.getTransformation().setOriginX(d2);
            this.view.getTransformation().setScaleX((double)this.view.getWidth() / d3);
            this.view.getTransformation().setXMajorUnit(axisData.majorUnit);
            this.view.getTransformation().setXMinorUnit(axisData.minorUnit);
        } else {
            this.view.getTransformation().setOriginY(d2);
            this.view.getTransformation().setScaleY((double)this.view.getHeight() / d3);
            this.view.getTransformation().setYMajorUnit(axisData.majorUnit);
            this.view.getTransformation().setYMinorUnit(axisData.minorUnit);
        }
        this.axis.setShowMajorUnit(axisData.majorVisible);
        this.axis.setShowMinorUnit(axisData.minorVisible);
        if (bl) {
            this.view.forceUpdate();
        }
        this.view.repaint();
        return true;
    }

    private boolean undo() {
        Object object;
        NumberFormat numberFormat;
        if (this.stack.size() <= 1) {
            return false;
        }
        AxisData axisData = this.stack.remove();
        if (this.stack.size() <= 1) {
            this.undoButton.setEnabled(false);
        }
        if ((numberFormat = NumberFormat.getNumberInstance()) instanceof DecimalFormat) {
            object = (DecimalFormat)numberFormat;
            ((DecimalFormat)object).setNegativePrefix("\u2212");
        }
        object = this.stack.peekFirst();
        this.minimumTextBox.setText(numberFormat.format(((AxisData)object).minimum));
        this.maximumTextBox.setText(numberFormat.format(((AxisData)object).maximum));
        this.majorUnitTextBox.setText(Double.toString(((AxisData)object).majorUnit));
        this.minorUnitTextBox.setText(Double.toString(((AxisData)object).minorUnit));
        this.majorCheckBox.setSelected(((AxisData)object).majorVisible);
        this.minorCheckBox.setSelected(((AxisData)object).minorVisible);
        double d = (((AxisData)object).maximum + ((AxisData)object).minimum) / 2.0;
        double d2 = ((AxisData)object).maximum - ((AxisData)object).minimum;
        if (this.x) {
            this.view.getTransformation().setOriginX(d);
            this.view.getTransformation().setScaleX((double)this.view.getWidth() / d2);
            this.view.getTransformation().setXMajorUnit(((AxisData)object).majorUnit);
            this.view.getTransformation().setXMinorUnit(((AxisData)object).minorUnit);
        } else {
            this.view.getTransformation().setOriginY(d);
            this.view.getTransformation().setScaleY((double)this.view.getHeight() / d2);
            this.view.getTransformation().setYMajorUnit(((AxisData)object).majorUnit);
            this.view.getTransformation().setYMinorUnit(((AxisData)object).minorUnit);
        }
        this.axis.setShowMajorUnit(((AxisData)object).majorVisible);
        this.axis.setShowMinorUnit(((AxisData)object).minorVisible);
        if (!axisData.minMaxMatches(this.stack.peekFirst())) {
            this.view.forceUpdate();
        }
        this.view.repaint();
        return true;
    }

    private void cancel() {
        AxisData axisData = this.stack.removeLast();
        double d = (axisData.maximum + axisData.minimum) / 2.0;
        double d2 = axisData.maximum - axisData.minimum;
        if (this.x) {
            this.view.getTransformation().setOriginX(d);
            this.view.getTransformation().setScaleX((double)this.view.getWidth() / d2);
            this.view.getTransformation().setXMajorUnit(axisData.majorUnit);
            this.view.getTransformation().setXMinorUnit(axisData.minorUnit);
        } else {
            this.view.getTransformation().setOriginY(d);
            this.view.getTransformation().setScaleY((double)this.view.getHeight() / d2);
            this.view.getTransformation().setYMajorUnit(axisData.majorUnit);
            this.view.getTransformation().setYMinorUnit(axisData.minorUnit);
        }
        this.axis.setShowMajorUnit(axisData.majorVisible);
        this.axis.setShowMinorUnit(axisData.minorVisible);
        this.view.forceUpdate();
        this.view.repaint();
    }

    public class CancelButtonListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            AxisDialog.this.cancel();
            AxisDialog.this.setVisible(false);
            AxisDialog.this.stack.clear();
        }
    }

    public class OKButtonListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            if (!AxisDialog.this.apply()) {
                return;
            }
            AxisDialog.this.setVisible(false);
            AxisDialog.this.stack.clear();
        }
    }

    public class UndoButtonListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            AxisDialog.this.undo();
        }
    }

    public class ApplyButtonListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            AxisDialog.this.apply();
        }
    }

    public class FieldFocusListener
    implements FocusListener {
        private JTextField textField;
        private boolean positive;

        FieldFocusListener(JTextField jTextField, boolean bl) {
            this.textField = jTextField;
            this.positive = bl;
        }

        public void focusGained(FocusEvent focusEvent) {
        }

        public void focusLost(FocusEvent focusEvent) {
            String string = this.textField.getText();
            string = string.replace("\u2212", "-");
            double d = 0.0;
            try {
                d = Double.parseDouble(string);
            }
            catch (NumberFormatException numberFormatException) {
                if (this.positive) {
                    this.textField.setText("1");
                } else {
                    this.textField.setText("0");
                }
                this.textField.requestFocusInWindow();
                return;
            }
            if (this.positive && d <= 0.0) {
                this.textField.setText("1");
                this.textField.requestFocusInWindow();
                return;
            }
            string = string.replace("-", "\u2212");
            this.textField.setText(string);
        }
    }
}

