/*
 * Decompiled with CFR 0.152.
 */
package jscicalc.graph;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import jscicalc.graph.Element;

public abstract class Axis
extends Element {
    protected boolean showMajorUnit;
    protected boolean showMinorUnit;
    protected int majorUnitTick;
    protected int minorUnitTick;
    NumberFormat numberFormat = NumberFormat.getNumberInstance();

    public Axis() {
        if (this.numberFormat instanceof DecimalFormat) {
            DecimalFormat decimalFormat = (DecimalFormat)this.numberFormat;
            decimalFormat.setNegativePrefix("\u2212");
        }
        this.majorUnitTick = 5;
        this.minorUnitTick = 2;
        this.setShowMajorUnit(true);
        this.setShowMinorUnit(true);
    }

    public void setShowMajorUnit(boolean bl) {
        this.showMajorUnit = bl;
    }

    public void setShowMinorUnit(boolean bl) {
        this.showMinorUnit = bl;
    }

    public boolean getShowMajorUnit() {
        return this.showMajorUnit;
    }

    public boolean getShowMinorUnit() {
        return this.showMinorUnit;
    }

    public int getMajorUnitTickLength() {
        return this.majorUnitTick;
    }

    public int getMinorUnitTickLength() {
        return this.minorUnitTick;
    }

    public String convertDouble(double d) {
        return this.numberFormat.format(d);
    }
}

