/*
 * Decompiled with CFR 0.152.
 */
package jscicalc.button;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import jscicalc.AngleType;
import jscicalc.CalculatorApplet;
import jscicalc.OObject;
import jscicalc.pobject.AFunction;
import jscicalc.pobject.Ans;
import jscicalc.pobject.Container;
import jscicalc.pobject.I;
import jscicalc.pobject.LParen;
import jscicalc.pobject.Mean;
import jscicalc.pobject.NullPObject;
import jscicalc.pobject.Numeral;
import jscicalc.pobject.PObject;
import jscicalc.pobject.PopStDev;
import jscicalc.pobject.RFunction;
import jscicalc.pobject.RParen;
import jscicalc.pobject.StDev;
import jscicalc.pobject.Trig;
import jscicalc.pobject.Variable;

public class CalculatorButton
extends JButton
implements ActionListener {
    protected CalculatorApplet applet;
    protected PObject pobject;
    protected char shortcut;
    protected String tooltip;
    private static final long serialVersionUID = 1L;

    protected CalculatorButton() {
    }

    private void setup(CalculatorApplet calculatorApplet, PObject pObject) {
        this.applet = calculatorApplet;
        this.setPObject(pObject);
        this.setText();
        this.setTextSize();
        this.addActionListener(this);
    }

    public void setPObject(PObject pObject) {
        if (pObject == null) {
            pObject = NullPObject.instance();
        }
        this.pobject = pObject;
        this.setText(pObject);
        this.tooltip = pObject.tooltip();
        this.shortcut = pObject.shortcut();
        this.setToolTipText();
    }

    public void setToolTipText() {
        if (this.tooltip.length() > 0) {
            if (this.shortcut == ' ') {
                this.setToolTipText("<html>" + this.tooltip + " [space]</html>");
            } else if (this.shortcut != '\u0000') {
                this.setToolTipText("<html>" + this.tooltip + " [" + this.shortcut + "]</html>");
            } else {
                this.setToolTipText("<html>" + this.tooltip + "</html>");
            }
        } else if (this.shortcut == ' ') {
            this.setToolTipText("<html>[space]</html>");
        } else if (this.shortcut != '\u0000') {
            this.setToolTipText("<html>[" + this.shortcut + "]</html>");
        } else {
            return;
        }
    }

    public CalculatorButton(CalculatorApplet calculatorApplet) {
        this.setup(calculatorApplet, NullPObject.instance());
    }

    public CalculatorButton(CalculatorApplet calculatorApplet, PObject pObject) {
        this.setup(calculatorApplet, pObject);
    }

    public void setText() {
        this.setText(this.pobject);
    }

    protected void setText(PObject pObject) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<html>");
        if (pObject != null) {
            stringBuilder.append(pObject.shortName());
        }
        stringBuilder.append("</html>");
        this.setText(stringBuilder.toString());
    }

    protected CalculatorApplet getApplet() {
        return this.applet;
    }

    public void setTextSize() {
        this.setFont(this.getFont().deriveFont(this.getApplet().buttonTextSize()));
    }

    public void setAngleType(AngleType angleType) {
        if (this.pobject instanceof Trig) {
            ((Trig)this.pobject).setScale(angleType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(ActionEvent actionEvent) {
        CalculatorApplet calculatorApplet = this.applet;
        synchronized (calculatorApplet) {
            if (this.getApplet().getMode() != 0) {
                this.getApplet().setMode(this.pobject);
                this.getApplet().requestFocusInWindow();
                return;
            }
            if (this.pobject instanceof Numeral) {
                char c = this.pobject.shortcut();
                switch (this.getApplet().getBase()) {
                    case BINARY: {
                        if (c != '2' && c != '3' && c != '4' && c != '5' && c != '6' && c != '7') break;
                        return;
                    }
                    case OCTAL: {
                        if (c != '8' && c != '9') break;
                        return;
                    }
                    case DECIMAL: {
                        if (c != 'A' && c != 'B' && c != 'C' && c != 'D' && c != 'E' && c != 'F') break;
                        return;
                    }
                }
            }
            if (this.pobject instanceof NullPObject || this.pobject == null) {
                return;
            }
            if (this.pobject instanceof Mean) {
                this.add(this.getApplet().statMean());
            } else if (this.pobject instanceof StDev) {
                this.add(this.getApplet().statSampleStDev());
            } else if (this.pobject instanceof PopStDev) {
                this.add(this.getApplet().statPopulationStDev());
            } else {
                this.setAngleType(this.applet.getAngleType());
                this.add(this.pobject);
            }
            this.getApplet().updateDisplay(true, true);
            if (this.getApplet().getShift()) {
                this.getApplet().setShift(false);
            }
            this.getApplet().requestFocusInWindow();
        }
    }

    protected void add(PObject pObject) {
        if (!(this.getApplet().getValue() instanceof OObject)) {
            return;
        }
        OObject oObject = this.getApplet().getValue();
        if (!(!this.getApplet().getParser().isEmpty() || pObject instanceof Numeral || pObject instanceof Variable || pObject instanceof AFunction || pObject instanceof RFunction || pObject instanceof LParen || pObject instanceof RParen || pObject instanceof I || pObject instanceof Container)) {
            Ans ans = new Ans();
            ans.setValue(oObject);
            this.getApplet().insert(ans);
            this.getApplet().updateDisplay(true, true);
            this.getApplet().insert(pObject);
        } else {
            this.getApplet().insert(pObject);
        }
    }

    public char shortcut() {
        return this.shortcut;
    }

    public String tooltip() {
        return new String(this.tooltip);
    }
}

