/*
 * Decompiled with CFR 0.152.
 */
package jscicalc;

import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.ListIterator;
import java.util.Vector;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultCaret;
import jscicalc.AngleType;
import jscicalc.Base;
import jscicalc.DisplayNavigator;
import jscicalc.LeftOrRight;
import jscicalc.Notation;
import jscicalc.OObject;
import jscicalc.ReadOnlyDisplayPanel;
import jscicalc.ScrollableLabel;
import jscicalc.StringArray;

public class DisplayLabel
extends ScrollableLabel {
    private DisplayCaret displayCaret;
    private ScrollData scrollData = new ScrollData(this);
    private boolean clearDisplay;
    public static final long BIAS = 1023L;
    public static final long E_MAX = 1023L;
    public static final long E_MIN = -1022L;
    private static final int DIGITS = 20;
    private static final String start = "<sub>&nbsp;</sub>&nbsp;<sup>&nbsp;</sup>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
    private static final long serialVersionUID = 1L;

    public DisplayLabel(ReadOnlyDisplayPanel readOnlyDisplayPanel) {
        super(readOnlyDisplayPanel, new DisplayNavigator());
        this.displayCaret = new DisplayCaret(this.scrollData);
        this.setNewExpression();
        this.textPane.setCaret(this.displayCaret);
        this.clearDisplay = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNewExpression() {
        OObject oObject;
        int n = this.getDigits();
        int n2 = 10;
        Base base = this.getBase();
        Notation notation = this.panel.getApplet().getNotation();
        double d = 1.0;
        if (this.panel.getApplet().getAngleType() == AngleType.DEGREES) {
            d = 1.0;
        }
        if ((oObject = this.panel.getApplet().getValue()) != null) {
            this.setExpression(oObject, n, n2, base, notation, d);
        }
        DisplayCaret displayCaret = this.displayCaret;
        synchronized (displayCaret) {
            this.displayCaret.updateFlag = true;
        }
    }

    protected void setCaretVisible(boolean bl) {
        this.caretVisible = false;
        this.updateCaretVisibility();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(boolean bl) {
        if (bl) {
            if (this.panel.getApplet().getMode() == 0) {
                DisplayCaret displayCaret = this.displayCaret;
                synchronized (displayCaret) {
                    if (this.clearDisplay) {
                        this.setNewExpression();
                    }
                    this.textPane.setText(this.expression);
                    this.textPane.getCaret().setDot(this.dotPosition);
                }
            } else {
                this.clear();
                this.textPane.setText(this.expression);
            }
        } else {
            this.clear();
            this.textPane.setText(this.expression);
        }
    }

    public synchronized void setExpression(OObject oObject, int n, int n2, Base base, Notation notation, double d) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<html><p style=\"font-size:");
        stringBuilder.append(Float.toString(this.panel.getApplet().displayTextSize()));
        stringBuilder.append("pt;font-family:");
        stringBuilder.append(UIManager.getFont("Label.font").getName());
        stringBuilder.append("\">");
        stringBuilder.append(start);
        this.navigator.dots().clear();
        int n3 = 53;
        this.navigator.dots().add(n3);
        StringArray stringArray = oObject.toHTMLStringVector(n, n2, base, notation, d);
        stringArray.removeDoubleSuperscripts();
        for (Vector vector : stringArray) {
            for (String string : vector) {
                stringBuilder.append(string);
            }
            this.navigator.dots().add(n3 += vector.size());
        }
        stringBuilder.append("</p></html>");
        this.expression = stringBuilder.toString();
        this.dotPosition = n3;
    }

    public synchronized void clear() {
        this.expression = start;
        this.dotPosition = 54;
        this.clearDisplay = true;
    }

    public Base getBase() {
        return this.panel.getApplet().getBase();
    }

    public int getDigits() {
        return 20;
    }

    public void left() {
        this.scrollData.left();
    }

    public void right() {
        this.scrollData.right();
    }

    final LeftOrRight getScrollDirections() {
        return this.scrollData.getScrollDirections();
    }

    private class ScrollData {
        private DisplayLabel displayLabel;
        private final Vector<Integer> dots;
        private Vector<Integer> distances;
        boolean atRight;

        public ScrollData(DisplayLabel displayLabel2) {
            this.dots = displayLabel2.navigator.dots();
            this.displayLabel = displayLabel2;
            this.distances = new Vector();
            this.atRight = true;
        }

        public void update() {
            this.distances = new Vector();
            if (this.dots.isEmpty()) {
                return;
            }
            ListIterator<Integer> listIterator = this.dots.listIterator();
            Rectangle rectangle = null;
            try {
                rectangle = DisplayLabel.this.textPane.modelToView(listIterator.next());
            }
            catch (BadLocationException badLocationException) {
                return;
            }
            if (rectangle == null) {
                return;
            }
            int n = rectangle.x;
            while (listIterator.hasNext()) {
                try {
                    rectangle = DisplayLabel.this.textPane.modelToView(listIterator.next());
                }
                catch (BadLocationException badLocationException) {
                    return;
                }
                if (rectangle == null) {
                    return;
                }
                int n2 = rectangle.x;
                this.distances.add(n2 - n);
                n = n2;
            }
        }

        final LeftOrRight getScrollDirections() {
            if (this.dots.isEmpty() || this.distances.size() != this.dots.size() - 1) {
                return LeftOrRight.NEITHER;
            }
            boolean bl = false;
            boolean bl2 = false;
            if (this.atRight) {
                bl2 = this.dots.lastElement() > this.displayLabel.dotPosition;
                double d = 0.0;
                ListIterator<Integer> listIterator = this.dots.listIterator();
                ListIterator<Integer> listIterator2 = this.distances.listIterator();
                while (listIterator2.hasNext() && listIterator.next() < this.displayLabel.dotPosition) {
                    d += (double)listIterator2.next().intValue();
                }
                bl = d > (double)this.displayLabel.getWidth();
            } else {
                bl = this.dots.firstElement() < this.displayLabel.dotPosition;
                double d = 0.0;
                ListIterator<Integer> listIterator = this.dots.listIterator(this.dots.size());
                ListIterator<Integer> listIterator3 = this.distances.listIterator(this.distances.size());
                while (listIterator3.hasPrevious() && listIterator.previous() > this.displayLabel.dotPosition) {
                    d += (double)listIterator3.previous().intValue();
                }
                boolean bl3 = bl2 = d > (double)this.displayLabel.getWidth();
            }
            if (bl && bl2) {
                return LeftOrRight.BOTH;
            }
            if (bl) {
                return LeftOrRight.LEFT;
            }
            if (bl2) {
                return LeftOrRight.RIGHT;
            }
            return LeftOrRight.NEITHER;
        }

        public void left() {
            int n = this.displayLabel.getWidth();
            if (this.atRight) {
                int n2;
                int n3 = 0;
                ListIterator<Integer> listIterator = this.dots.listIterator();
                ListIterator<Integer> listIterator2 = this.distances.listIterator();
                while (listIterator2.hasNext() && listIterator.next() < this.displayLabel.dotPosition) {
                    n3 += listIterator2.next().intValue();
                }
                if (n >= n3) {
                    return;
                }
                listIterator = this.dots.listIterator();
                listIterator2 = this.distances.listIterator();
                int n4 = listIterator.next();
                while (listIterator2.hasNext() && n3 - (n2 = listIterator2.next().intValue()) >= n) {
                    n3 -= n2;
                    n4 = listIterator.next();
                }
                this.displayLabel.dotPosition = n4;
                this.atRight = false;
            } else {
                ListIterator<Integer> listIterator = this.dots.listIterator();
                while (listIterator.hasNext() && listIterator.next() < this.displayLabel.dotPosition) {
                }
                listIterator.previous();
                if (!listIterator.hasPrevious()) {
                    return;
                }
                this.displayLabel.dotPosition = listIterator.previous();
            }
            this.displayLabel.textPane.getCaret().setDot(this.displayLabel.dotPosition);
        }

        public void right() {
            int n = this.displayLabel.getWidth();
            if (!this.atRight) {
                int n2;
                int n3 = 0;
                ListIterator<Integer> listIterator = this.dots.listIterator(this.dots.size());
                ListIterator<Integer> listIterator2 = this.distances.listIterator(this.distances.size());
                while (listIterator2.hasPrevious() && listIterator.previous() > this.displayLabel.dotPosition) {
                    n3 += listIterator2.previous().intValue();
                }
                if (n >= n3) {
                    return;
                }
                listIterator = this.dots.listIterator(this.dots.size());
                listIterator2 = this.distances.listIterator(this.distances.size());
                int n4 = listIterator.previous();
                while (listIterator2.hasPrevious() && n3 - (n2 = listIterator2.previous().intValue()) >= n) {
                    n3 -= n2;
                    n4 = listIterator.previous();
                }
                this.displayLabel.dotPosition = n4;
                this.atRight = true;
            } else {
                ListIterator<Integer> listIterator = this.dots.listIterator(this.dots.size());
                while (listIterator.hasPrevious() && listIterator.previous() > this.displayLabel.dotPosition) {
                }
                listIterator.next();
                if (!listIterator.hasNext()) {
                    return;
                }
                this.displayLabel.dotPosition = listIterator.next();
            }
            this.displayLabel.textPane.getCaret().setDot(this.displayLabel.dotPosition);
        }
    }

    private class DisplayCaret
    extends DefaultCaret {
        private ScrollData scrollData;
        public boolean updateFlag;
        private static final long serialVersionUID = 1L;

        public DisplayCaret(ScrollData scrollData) {
            this.scrollData = scrollData;
            this.updateFlag = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void paint(Graphics graphics) {
            DisplayCaret displayCaret = this;
            synchronized (displayCaret) {
                super.paint(graphics);
                if (this.updateFlag) {
                    this.scrollData.update();
                }
                this.updateFlag = false;
                this.notify();
            }
        }
    }
}

