/*
 * Decompiled with CFR 0.152.
 */
package jscicalc;

import java.awt.Color;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JApplet;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.Spring;
import javax.swing.SwingUtilities;
import javax.swing.border.BevelBorder;
import javax.swing.text.JTextComponent;
import jscicalc.AngleType;
import jscicalc.Base;
import jscicalc.CalculatorPanel;
import jscicalc.DataTransfer;
import jscicalc.DisplayPanel;
import jscicalc.Error;
import jscicalc.HistoryItem;
import jscicalc.Notation;
import jscicalc.OObject;
import jscicalc.Parser;
import jscicalc.ReadOnlyCalculatorApplet;
import jscicalc.SpecialButtonType;
import jscicalc.button.CalculatorButton;
import jscicalc.complex.Complex;
import jscicalc.graph.Graph;
import jscicalc.pobject.Mean;
import jscicalc.pobject.Mode;
import jscicalc.pobject.Numeral;
import jscicalc.pobject.PObject;
import jscicalc.pobject.PopStDev;
import jscicalc.pobject.StDev;

public class CalculatorApplet
extends JApplet
implements KeyListener,
ReadOnlyCalculatorApplet {
    private Graph graph;
    private OObject value;
    private AngleType angleType;
    private int mode;
    private boolean stat;
    private OObject memory;
    private Vector<Complex> statMemory;
    private Vector<Complex> statMemoryNeg;
    private int frameHeight;
    private CalculatorApplet applet = this;
    private DisplayPanel displayPanel;
    private CalculatorPanel calculatorPanel;
    private HashMap<SpecialButtonType, CalculatorPanel> calculatorPanels;
    private int mSize;
    private Parser parser;
    private boolean shift;
    private static final int bWidth = 23;
    private static final int bHeight = 10;
    private static final int sSize = 3;
    private static final int dHeight = 30;
    private static final float bTextSize = 4.0f;
    private static final float eTextSize = 6.4f;
    private static final float dTextSize = 9.2f;
    private static final float sTextSize = 2.5f;
    private Vector<HistoryItem> history;
    private static final int HISTORY_SIZE = 24;
    HistoryItem tempParserList;
    int historyPosition;
    private static final Color panelColour = Color.LIGHT_GRAY;
    protected JFrame jframe;
    private boolean shiftDown;
    private Notation notation;
    private JTextComponent textComponent;
    private DataTransfer dataTransfer;
    private final int minimumSize = 3;
    private Vector<Integer> sizes;
    private boolean graphical;
    private static final long serialVersionUID = 1L;

    public CalculatorApplet(String[] stringArray) {
        this.setGraphical(false);
        for (String string : stringArray) {
            if (!string.equals(new String("-g"))) continue;
            this.setGraphical(true);
        }
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                boolean bl;
                boolean bl2 = bl = mouseEvent.getButton() != 1;
                if (!bl) {
                    return;
                }
                JOptionPane.showMessageDialog(CalculatorApplet.this.applet, "<html>Copyright &#169; 2004&#8211;5, 2007&#8211;82011&#8211;12, John D Lamb &#60;J.D.Lamb@btinternet.com&#62;<br>This is free software; see the source for copying conditions.  There is NO warranty;<br>not even for MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.</html>", "About", 1);
            }
        });
    }

    public void init() {
        this.applet = this;
        this.frame(null);
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    CalculatorApplet.this.setup();
                }
            });
        }
        catch (Exception exception) {
            System.err.println("InterruptedException");
        }
    }

    public static void main(final String[] stringArray) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                CalculatorApplet.showFrame(stringArray);
            }
        });
    }

    private static void showFrame(String[] stringArray) {
        JFrame jFrame = CalculatorApplet.createFrame(stringArray);
        jFrame.setDefaultCloseOperation(3);
        jFrame.setVisible(true);
    }

    public static JFrame createFrame(String[] stringArray) {
        CalculatorApplet calculatorApplet = new CalculatorApplet(stringArray);
        System.out.println("Copyright (C) 2004\u20135, 2007\u20132008, 2011\u201312, John D Lamb <J.D.Lamb@btinternet.com>");
        System.out.println("This is free software; see the source for copying conditions.  There is NO");
        System.out.println("warranty; not even for MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.");
        JFrame jFrame = new JFrame("Scientific Calculator");
        calculatorApplet.frame(jFrame);
        calculatorApplet.setup();
        jFrame.setContentPane(calculatorApplet);
        jFrame.setResizable(false);
        jFrame.setUndecorated(false);
        jFrame.pack();
        return jFrame;
    }

    public void setup() {
        this.setTextComponent(null);
        this.graph = null;
        this.setValue(new Complex());
        this.setSizes();
        this.parser = new Parser();
        this.shift = false;
        this.angleType = AngleType.DEGREES;
        this.mode = 0;
        this.stat = false;
        this.notation = new Notation();
        this.memory = new Complex();
        this.statMemory = new Vector();
        this.statMemoryNeg = new Vector();
        this.addKeyListener(this);
        this.setFocusable(true);
        this.getContentPane().removeAll();
        this.displayPanel = new DisplayPanel(this);
        this.displayPanel.setBorder(new BevelBorder(1));
        this.setPanels();
        this.dataTransfer = new DataTransfer(this);
        this.calculatorPanel.getInputMap().put(KeyStroke.getKeyStroke(65485, 0), "copy");
        this.calculatorPanel.getInputMap().put(KeyStroke.getKeyStroke(67, 3, false), "copy");
        this.calculatorPanel.getActionMap().put("copy", this.dataTransfer);
        this.dataTransfer.setEnabled(true);
        this.setBase(Base.DECIMAL);
        this.history = new Vector();
        this.tempParserList = new HistoryItem(null, this.getAngleType(), this.getBase(), this.getNotation());
        this.historyPosition = -1;
        this.shiftDown = false;
        this.setOn(true);
        this.setValue(new Complex(0.0));
        this.updateDisplay(true, true);
        this.requestFocusInWindow();
    }

    private void setPanels() {
        this.displayPanel.setUp();
        this.calculatorPanels = new HashMap();
        for (SpecialButtonType specialButtonType : SpecialButtonType.values()) {
            CalculatorPanel calculatorPanel = CalculatorPanel.createPanel(this, specialButtonType, panelColour);
            this.calculatorPanels.put(specialButtonType, calculatorPanel);
        }
        this.setCalculatorPanel(SpecialButtonType.NONE);
    }

    private void setCalculatorPanel(SpecialButtonType specialButtonType) {
        if (this.calculatorPanel != null) {
            this.getContentPane().remove(this.calculatorPanel);
        }
        this.calculatorPanel = this.calculatorPanels.get((Object)specialButtonType);
        this.getContentPane().add(this.calculatorPanel);
        this.calculatorPanel.setDisplayPanel();
        this.repaint();
    }

    public void clearHistory() {
        this.history = new Vector();
        this.historyPosition = -1;
    }

    public void upHistory() {
        if (this.displayPanel.displayLabelHasCaret()) {
            this.setCaretToEntry();
        }
        if (this.historyPosition >= this.history.size() - 1) {
            return;
        }
        if (this.historyPosition == -1) {
            if (this.getValue() instanceof Error) {
                this.setValue(new Complex());
            }
            this.tempParserList.list = this.parser.getList();
            this.tempParserList.angleType = this.getAngleType();
            this.tempParserList.base = this.getBase();
            this.tempParserList.notation = this.getNotation();
        } else {
            this.history.elementAt((int)this.historyPosition).list = this.parser.getList();
            this.history.elementAt((int)this.historyPosition).angleType = this.getAngleType();
            this.history.elementAt((int)this.historyPosition).base = this.getBase();
            this.history.elementAt((int)this.historyPosition).notation = this.getNotation();
        }
        ++this.historyPosition;
        this.parser.setList(this.history.elementAt((int)this.historyPosition).list);
        this.setAngleType(this.history.elementAt((int)this.historyPosition).angleType);
        this.setBase(this.history.elementAt((int)this.historyPosition).base);
        this.setNotation(this.history.elementAt((int)this.historyPosition).notation);
        this.displayPanel.setExpression(this.parser);
    }

    public boolean downHistory() {
        if (this.historyPosition < 0) {
            if (this.displayPanel.displayLabelScrollable()) {
                this.setCaretToDisplay();
                return true;
            }
            return false;
        }
        this.history.elementAt((int)this.historyPosition).list = this.parser.getList();
        this.history.elementAt((int)this.historyPosition).angleType = this.getAngleType();
        this.history.elementAt((int)this.historyPosition).base = this.getBase();
        this.history.elementAt((int)this.historyPosition).notation = this.getNotation();
        --this.historyPosition;
        if (this.historyPosition == -1) {
            this.parser.setList(this.tempParserList.list);
            this.setAngleType(this.tempParserList.angleType);
            this.setBase(this.tempParserList.base);
            this.setNotation(this.tempParserList.notation);
        } else {
            this.parser.setList(this.history.elementAt((int)this.historyPosition).list);
            this.setAngleType(this.history.elementAt((int)this.historyPosition).angleType);
            this.setBase(this.history.elementAt((int)this.historyPosition).base);
            this.setNotation(this.history.elementAt((int)this.historyPosition).notation);
        }
        this.displayPanel.setExpression(this.parser);
        return true;
    }

    public void pushHistory() {
        LinkedList<PObject> linkedList = this.parser.getList();
        if (linkedList.size() == 0) {
            return;
        }
        this.history.add(0, new HistoryItem(linkedList, this.getAngleType(), this.getBase(), this.getNotation()));
        while (this.history.size() > 24) {
            this.history.removeElementAt(24);
        }
        this.historyPosition = -1;
    }

    public void right() {
        this.displayPanel.right();
    }

    public void left() {
        this.displayPanel.left();
    }

    public Action backward() {
        return this.displayPanel.backward();
    }

    public void newExpression() {
        this.displayPanel.newExpression();
    }

    public DisplayPanel displayPanel() {
        return this.displayPanel;
    }

    public void clear() {
        this.displayPanel.clear(this.getParser());
        this.displayPanel.setExpression(this.parser);
    }

    public void delete() {
        this.displayPanel.delete(this.getParser());
    }

    public void copy() {
        this.dataTransfer.copy();
    }

    public void insert(PObject pObject) {
        this.displayPanel.insert(pObject, this.getParser());
    }

    public void updateDisplay(boolean bl, boolean bl2) {
        if (this.displayPanel != null) {
            this.displayPanel.update(bl, bl2);
        }
        if (this.textComponent != null) {
            this.textComponent.setText(this.getValue().toString());
        }
    }

    public int displayHeight(int n) {
        return 30 * n;
    }

    public int buttonHeight(int n) {
        return 10 * n;
    }

    public int buttonWidth(int n) {
        return 23 * n;
    }

    public int strutSize(int n) {
        return 3 * n;
    }

    public int displayHeight() {
        return this.displayHeight(this.minSize());
    }

    public int buttonHeight() {
        return this.buttonHeight(this.minSize());
    }

    public int buttonWidth() {
        return this.buttonWidth(this.minSize());
    }

    public int strutSize() {
        return this.strutSize(this.minSize());
    }

    public void setMinSize(int n) {
        this.mSize = n;
        if (this.frame() == null) {
            return;
        }
        this.setPanels();
        this.frame().pack();
        if (this.graph != null) {
            this.graph.updateMenu();
        }
    }

    public int minSize() {
        return this.mSize;
    }

    public float buttonTextSize() {
        return (float)this.mSize * 4.0f;
    }

    public float entryTextSize() {
        return (float)this.mSize * 6.4f;
    }

    public float displayTextSize() {
        return (float)this.mSize * 9.2f;
    }

    public float extraTextSize() {
        return (float)this.mSize * 2.5f;
    }

    public void setShift(boolean bl) {
        this.shift = bl;
        if (this.shift) {
            if (this.stat) {
                this.setCalculatorPanel(SpecialButtonType.SHIFT_STAT);
            } else {
                switch (this.getBase()) {
                    case DECIMAL: {
                        this.setCalculatorPanel(SpecialButtonType.SHIFT);
                        break;
                    }
                    default: {
                        this.setCalculatorPanel(SpecialButtonType.SHIFT_HEX);
                        break;
                    }
                }
            }
        } else if (this.stat) {
            this.setCalculatorPanel(SpecialButtonType.STAT);
        } else {
            switch (this.getBase()) {
                case DECIMAL: {
                    this.setCalculatorPanel(SpecialButtonType.NONE);
                    break;
                }
                default: {
                    this.setCalculatorPanel(SpecialButtonType.HEX);
                }
            }
        }
    }

    public void setOn(boolean bl) {
        if (this.displayPanel != null) {
            this.displayPanel.setOn(bl);
            this.displayPanel.repaint();
        } else {
            System.out.println("no display panel");
        }
    }

    public boolean getOn() {
        if (this.displayPanel != null) {
            return this.displayPanel.getOn();
        }
        return false;
    }

    public boolean getShift() {
        return this.shift;
    }

    public Parser getParser() {
        return this.parser;
    }

    public OObject getValue() {
        return this.value;
    }

    public void setValue(OObject oObject) {
        this.value = oObject;
        if (this.value != null && this.displayPanel != null) {
            this.displayPanel.setValue();
        }
    }

    public void setMemory(OObject oObject) {
        this.memory = oObject;
    }

    public OObject getMemory() {
        return this.memory;
    }

    public void setAngleType(AngleType angleType) {
        this.angleType = angleType;
    }

    public AngleType getAngleType() {
        return this.angleType;
    }

    public boolean getStat() {
        return this.stat;
    }

    public void setStat(boolean bl) {
        this.stat = bl;
        if (bl) {
            this.setBase(Base.DECIMAL);
        }
        this.setShift(this.getShift());
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int n) {
        this.mode = n % (this.frame() != null && this.sizes.size() > 1 ? 4 : 3);
    }

    public void setMode(PObject pObject) {
        if (pObject instanceof Numeral) {
            Numeral numeral = (Numeral)pObject;
            if (this.mode == 3) {
                int n = 0;
                switch (numeral.get()) {
                    case '1': {
                        n = 1;
                        break;
                    }
                    case '2': {
                        n = 2;
                        break;
                    }
                    case '3': {
                        n = 3;
                        break;
                    }
                    case '4': {
                        n = 4;
                        break;
                    }
                    case '5': {
                        n = 5;
                        break;
                    }
                    case '6': {
                        n = 6;
                        break;
                    }
                    case '7': {
                        n = 7;
                        break;
                    }
                    case '8': {
                        n = 8;
                        break;
                    }
                    case '9': {
                        n = 9;
                        break;
                    }
                    default: {
                        n = 0;
                    }
                }
                if (n < this.sizes.size()) {
                    n = this.sizes.elementAt(n);
                    if (this.minSize() != n) {
                        this.setMinSize(n);
                    }
                    this.setMode(0);
                    this.updateDisplay(true, true);
                }
            } else if (numeral.name().equals("1")) {
                if (this.mode == 2) {
                    this.setAngleType(AngleType.DEGREES);
                } else if (this.mode == 1) {
                    this.setStat(false);
                }
                this.setMode(0);
                this.updateDisplay(true, true);
            } else if (numeral.name().equals("2")) {
                if (this.mode == 2) {
                    this.setAngleType(AngleType.RADIANS);
                } else if (this.mode == 1) {
                    this.setStat(true);
                }
                this.setMode(0);
                this.updateDisplay(true, true);
            } else if (numeral.name().equals("3")) {
                this.setMode(0);
                this.updateDisplay(true, true);
            }
        } else if (pObject instanceof Mode) {
            this.setMode(this.getMode() + 1);
        }
    }

    public void clearStatMemory() {
        this.statMemory.clear();
        this.statMemoryNeg.clear();
    }

    public Complex statAdd(Complex complex) {
        this.statMemory.add(complex);
        return new Complex(this.statSize());
    }

    public Complex statSub(Complex complex) {
        this.statMemoryNeg.add(complex);
        return new Complex(this.statSize());
    }

    private double statSize() {
        return this.statMemory.size() - this.statMemoryNeg.size();
    }

    public Mean statMean() {
        Mean mean = new Mean();
        Complex complex = new Complex();
        for (Complex complex2 : this.statMemory) {
            complex = complex.add(complex2);
        }
        for (Complex complex2 : this.statMemoryNeg) {
            complex = complex.subtract(complex2);
        }
        if (this.statSize() > 0.0) {
            mean.setValue(complex.divide(new Complex(this.statSize(), 0.0)));
        } else {
            mean.setError(true);
        }
        return mean;
    }

    public Complex statSumSquares() {
        Complex complex;
        Mean mean = this.statMean();
        if (mean.error() || !(mean.value() instanceof Complex)) {
            throw new RuntimeException("Stat Error");
        }
        Complex complex2 = (Complex)mean.value();
        Complex complex3 = new Complex();
        for (Complex complex4 : this.statMemory) {
            complex = complex4.subtract(complex2);
            complex3 = complex3.add(complex.square());
        }
        for (Complex complex4 : this.statMemoryNeg) {
            complex = complex4.subtract(complex2);
            complex3 = complex3.subtract(complex.square());
        }
        return complex3;
    }

    public StDev statSampleStDev() {
        StDev stDev = new StDev();
        try {
            Complex complex = this.statSumSquares();
            if (this.statSize() < 2.0) {
                stDev.setError(true);
                return stDev;
            }
            stDev.setValue(complex.divide(new Complex(this.statSize() - 1.0, 0.0)).sqrt());
            return stDev;
        }
        catch (Exception exception) {
            stDev.setError(true);
            return stDev;
        }
    }

    public PopStDev statPopulationStDev() {
        PopStDev popStDev = new PopStDev();
        try {
            Complex complex = this.statSumSquares();
            if (this.statSize() < 1.0) {
                popStDev.setError(true);
                return popStDev;
            }
            popStDev.setValue(complex.divide(new Complex(this.statSize(), 0.0)).sqrt());
            return popStDev;
        }
        catch (Exception exception) {
            popStDev.setError(true);
            return popStDev;
        }
    }

    public void frame(JFrame jFrame) {
        this.jframe = jFrame;
    }

    public JFrame frame() {
        return this.jframe;
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 37) {
            this.calculatorPanel.buttons().elementAt(40).actionPerformed(null);
        } else if (keyEvent.getKeyCode() == 39) {
            this.calculatorPanel.buttons().elementAt(41).actionPerformed(null);
        } else if (keyEvent.getKeyCode() == 38) {
            this.calculatorPanel.buttons().elementAt(43).actionPerformed(null);
        } else if (keyEvent.getKeyCode() == 40) {
            this.calculatorPanel.buttons().elementAt(44).actionPerformed(null);
        } else if (keyEvent.getKeyCode() == 65406) {
            if (!this.shiftDown) {
                this.calculatorPanel.buttons().elementAt(10).actionPerformed(null);
                this.shiftDown = true;
            }
        } else if (keyEvent.getKeyCode() == 65485) {
            if (!this.shiftDown) {
                this.copy();
            } else {
                this.calculatorPanel.buttons().elementAt(15).actionPerformed(null);
            }
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 65406) {
            this.shiftDown = false;
        } else {
            char c = keyEvent.getKeyChar();
            if ((keyEvent.getModifiersEx() & 0x80) != 0 && keyEvent.getKeyCode() == 67) {
                this.dataTransfer.copy();
            }
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
        if ((keyEvent.getModifiersEx() & 0x80) == 0) {
            CalculatorButton calculatorButton;
            char c = keyEvent.getKeyChar();
            if (c == '\n') {
                c = '=';
            }
            if ((calculatorButton = this.calculatorPanel.keyMap().get(Character.valueOf(c))) != null) {
                calculatorButton.actionPerformed(null);
            } else if (c == '\b' && !this.shift) {
                this.calculatorPanel.buttons().elementAt(30).actionPerformed(null);
            }
        }
    }

    private static Spring scale(Spring spring, int n) {
        if (n < 2) {
            return spring;
        }
        Spring spring2 = Spring.sum(spring, spring);
        for (int i = 2; i < n; ++i) {
            spring2 = Spring.sum(spring2, spring);
        }
        return spring2;
    }

    public Base getBase() {
        return this.parser.base();
    }

    public void setBase(Base base) {
        if (this.getBase() == base) {
            return;
        }
        this.parser.base(base);
        switch (base) {
            case DECIMAL: {
                this.setCalculatorPanel(SpecialButtonType.NONE);
                break;
            }
            default: {
                this.setCalculatorPanel(SpecialButtonType.HEX);
            }
        }
    }

    public void setTextComponent(JTextComponent jTextComponent) {
        this.textComponent = jTextComponent;
    }

    public final JTextComponent getTextComponent() {
        return this.textComponent;
    }

    public Notation getNotation() {
        return this.notation;
    }

    public void setNotation(Notation notation) {
        this.notation = notation;
    }

    public final Insets getFrameInsets() {
        if (this.jframe == null) {
            return new Insets(29, 4, 4, 4);
        }
        return this.jframe.getInsets();
    }

    private int getFrameWidth(int n) {
        int n2 = this.getFrameInsets().left + this.getFrameInsets().right;
        return 4 * this.strutSize(n) + 5 * n + 8 * this.buttonWidth(n) + n2;
    }

    private int getFrameHeight(int n) {
        int n2 = this.getFrameInsets().top + this.getFrameInsets().bottom;
        return 3 * this.strutSize(n) + 4 * n + 5 * this.buttonHeight(n) + this.displayHeight(n) + n2;
    }

    public int graphHeight() {
        if (this.jframe == null) {
            return this.getFrameHeight(this.mSize);
        }
        return this.jframe.getHeight();
    }

    private void setSizes() {
        int n;
        this.mSize = 4;
        if (this.jframe == null) {
            return;
        }
        int n2 = Toolkit.getDefaultToolkit().getScreenSize().width;
        int n3 = Toolkit.getDefaultToolkit().getScreenSize().height;
        int n4 = 3;
        for (n = 0; n < 11; ++n) {
            if (this.getFrameWidth(3 + n) > n2 || this.getFrameHeight(3 + n) > n3) {
                n4 = n;
                break;
            }
            if (n != 10) continue;
            n4 = n;
        }
        this.sizes = new Vector(n4);
        for (n = 3; n < 3 + n4; ++n) {
            this.sizes.add(n);
        }
        if (n4 < 4) {
            this.mSize = 3;
        }
    }

    public int getSizesSize() {
        return this.sizes.size();
    }

    public int getMinSize() {
        return 3;
    }

    private void setGraphical(boolean bl) {
        this.graphical = bl;
    }

    public boolean getGraphical() {
        return this.graphical;
    }

    private void setCaretToEntry() {
        this.displayPanel.setCaretToEntry();
    }

    private void setCaretToDisplay() {
        this.displayPanel.setCaretToDisplay();
    }

    public void displayGraph() {
        if (this.graph == null) {
            this.graph = new Graph(this);
        } else {
            this.graph.setVisible(true);
        }
        this.graph.setLocus(this.getValue());
    }
}

