/*
 * Decompiled with CFR 0.152.
 */
package net.ponec.jworksheet.gui.models;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import net.ponec.jworksheet.bo.Event;
import net.ponec.jworksheet.bo.Parameters;
import net.ponec.jworksheet.bo.Project;
import net.ponec.jworksheet.core.ApplContext;
import net.ponec.jworksheet.core.ApplTools;
import net.ponec.jworksheet.gui.component.UjoTable;
import org.ujoframework.UjoProperty;
import org.ujoframework.swing.UjoTableModel;

public class EventTableRenderer
extends DefaultTableCellRenderer {
    private final ApplContext context;
    protected Color colorAlt = null;
    protected final boolean nimbus = ApplTools.isNimbusLAF();

    public EventTableRenderer(ApplContext applContext) {
        this.context = applContext;
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        boolean bl3;
        boolean bl4;
        JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        UjoTable ujoTable = (UjoTable)jTable;
        UjoTableModel ujoTableModel = ujoTable.getModel();
        UjoProperty ujoProperty = ujoTable.getColumn(n2);
        Event event = (Event)ujoTableModel.getRow(n);
        boolean bl5 = bl4 = ujoProperty == Event.P_PROJ || ujoProperty == Event.P_TASK;
        boolean bl6 = (this.nimbus ? ujoProperty == Event.P_TIME || ujoProperty == Event.P_PERIOD : !bl4) && ujoTableModel.isCellEditable(n, ujoProperty);
        Project project = Event.P_PROJ.of(event);
        boolean bl7 = project != null && bl4 && event.isFinished(ujoProperty);
        boolean bl8 = bl3 = project != null && Project.P_PRIVATE.of(project) != false;
        jLabel.setForeground(bl ? jTable.getSelectionForeground() : (bl7 ? this.getColorOfFihishedProject() : (bl3 ? this.getColorOfPrivateProject() : ujoTable.getForeground())));
        jLabel.setBackground(bl ? jTable.getSelectionBackground() : (ujoProperty == Event.P_TIME ? this.getColorOfEditableArea(n) : (bl6 ? this.getColorOfEditableArea() : ujoTable.getBackground())));
        jLabel.setHorizontalAlignment(this.isNumericalType(ujoProperty) ? 4 : 2);
        if (ujoProperty == Event.P_PERIOD) {
            String string = this.context.getParameters().formatTime(((Short)object).shortValue());
            jLabel.setText(string);
        }
        return jLabel;
    }

    public boolean isNumericalType(UjoProperty ujoProperty) {
        if (ujoProperty == Event.P_TIME) {
            return true;
        }
        return ujoProperty == Event.P_PERIOD;
    }

    protected Color getColorOfPrivateProject() {
        Color color = Parameters.P_COLOR_PRIVATE.of(this.context.getParameters());
        return color;
    }

    protected Color getColorOfFihishedProject() {
        Color color = Parameters.P_COLOR_FINISHED_PROJ.of(this.context.getParameters());
        return color;
    }

    protected Color getColorOfEditableArea() {
        return Parameters.P_COLOR_EDITABLE.of(this.context.getParameters());
    }

    protected Color getColorOfEditableArea(int n) {
        Color color;
        if (n % 2 == 0) {
            color = this.getColorOfEditableArea();
        } else {
            if (this.colorAlt == null) {
                this.colorAlt = this.getColorOfEditableArea();
                if (ApplTools.isNimbusLAF()) {
                    this.colorAlt = ApplTools.modify(this.colorAlt, 30);
                }
            }
            color = this.colorAlt;
        }
        return color;
    }
}

