/*
 * Decompiled with CFR 0.152.
 */
package net.ponec.jworksheet.gui.models;

import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import net.ponec.jworksheet.bo.Event;
import net.ponec.jworksheet.bo.Parameters;
import net.ponec.jworksheet.bo.Project;
import net.ponec.jworksheet.bo.TaskType;
import net.ponec.jworksheet.bo.item.Time;
import net.ponec.jworksheet.core.ApplContext;
import org.ujoframework.UjoProperty;
import org.ujoframework.swing.UjoTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventTableModel
extends UjoTableModel<Event> {
    public static final int ACTION_SELECT_EVENT = 1001;
    public static final Event PROPS = null;
    protected ApplContext applContext;
    private boolean timeChange;

    public EventTableModel(ApplContext applContext) {
        UjoProperty[] ujoPropertyArray = new UjoProperty[5];
        ujoPropertyArray[0] = Event.P_TIME;
        ujoPropertyArray[1] = Event.P_PERIOD;
        ujoPropertyArray[2] = Event.P_PROJ;
        ujoPropertyArray[3] = Event.P_TASK;
        ujoPropertyArray[4] = Event.P_DESCR;
        super(ujoPropertyArray);
        this.applContext = applContext;
    }

    @Override
    public boolean isCellEditable(int n, UjoProperty ujoProperty) {
        if (Event.P_PERIOD == ujoProperty) {
            return n == this.getRowCount() - 1;
        }
        return Parameters.P_MODIFY_FINESHED_PROJ.of(this.applContext.getParameters()) != false || !((Event)this.getRow(n)).isFinished(ujoProperty);
    }

    @Override
    public String getColumnName(UjoProperty ujoProperty) {
        return this.applContext.getLanguageManager().getTextAllways(ujoProperty);
    }

    public void insertRow(Event event) {
        Event event2 = (Event)this.getRowLast();
        if (event2 != null) {
            event2.setPeriod(Event.P_TIME.of(event));
        }
        super.addRow(event);
    }

    public void insertRowAndDefault(Event event) {
        Project project = this.applContext.getWorkSpace().findDefaultProject();
        if (project != null) {
            Event.P_PROJ.setValue(event, project);
            TaskType taskType = project.findDefaultTask();
            if (taskType != null) {
                Event.P_TASK.setValue(event, taskType);
            }
        }
        this.insertRow(event);
    }

    public void setTimeOfLastPeriod() {
        if (this.getRowCount() > 0 && this.applContext.isToday()) {
            Event event = (Event)this.getRowLast();
            event.setPeriod(new Time(true));
        }
    }

    protected void performAfterInsertAction(Event event) {
        int n;
        short s;
        if (event != null && (s = Event.P_PERIOD.of(event).shortValue()) > 0 && (n = this.getRowIndex(event)) > 0 && n < this.getRowCount() - 1) {
            Time time = Event.P_TIME.of(event);
            Time time2 = Event.P_TIME.of((Event)this.getRow(n + 1));
            short s2 = time2.substract(time);
            if (s2 > s) {
                Event event2 = (Event)((Event)this.getRow(n - 1)).clone(2, this);
                Event.P_TIME.setValue(event2, time.cloneAdd(s));
                this.rows.add(n + 1, event2);
            }
        }
    }

    public void sort(boolean bl) {
        this.timeChange = false;
        Event event = (Event)this.getRowLast();
        super.sort(Event.P_TIME);
        if (bl) {
            this.performAfterInsertAction(event);
        }
        this.setTimeOfLastPeriod();
        Event event2 = null;
        for (int i = 0; i < this.getRowCount(); ++i) {
            Event event3 = (Event)this.getRow(i);
            if (event2 != null) {
                event2.setPeriod(Event.P_TIME.of(event3));
            }
            event2 = event3;
        }
        this.fireTableDataChanged();
    }

    public int getTotalTime() {
        int n = 0;
        for (Event event : this.rows) {
            if (event.isPrivate()) continue;
            n += Event.P_PERIOD.of(event).shortValue();
        }
        return n;
    }

    public String getTotalTimeHours() {
        String string = this.applContext.getParameters().formatTime(this.getTotalTime());
        return string;
    }

    @Override
    public Class getColumnClass(UjoProperty ujoProperty) {
        Class clazz = Event.P_PERIOD == ujoProperty ? Object.class : super.getColumnClass(ujoProperty);
        return clazz;
    }

    @Override
    public void setValueAt(Object object, int n, UjoProperty ujoProperty) {
        Object object2;
        block9: {
            block10: {
                block8: {
                    if (Event.P_PERIOD != ujoProperty) break block8;
                    object2 = String.valueOf(object);
                    int n2 = ((String)object2).indexOf(58);
                    if (n2 >= 0) {
                        int n3 = Integer.parseInt(((String)object2).substring(n2 + 1));
                        object = new Short((short)(n3 += 60 * Integer.parseInt(((String)object2).substring(0, n2))));
                    } else {
                        if (((String)object2).indexOf(44) >= 0) {
                            object2 = ((String)object2).replace(',', '.');
                        }
                        float f = Float.parseFloat((String)object2);
                        boolean bl = ((String)object2).indexOf(46) >= 0;
                        object = new Short((short)Math.round(f * (float)(bl ? 60 : 1)));
                    }
                    Event.P_TIME.of((Event)this.getRow(n)).cloneAdd(((Short)object).shortValue());
                    break block9;
                }
                if (Event.P_TIME == ujoProperty) break block10;
                if (Event.P_PROJ != ujoProperty) break block9;
            }
            this.timeChange = true;
        }
        if (ujoProperty == Event.P_PROJ && object != null && object != this.getValueAt(n, ujoProperty)) {
            object2 = ((Project)object).findDefaultTask();
            super.setValueAt(object2, n, Event.P_TASK);
        }
        super.setValueAt(object, n, ujoProperty);
        if (this.timeChange && Parameters.P_AUTOMATIC_SORTING_BY_TIME.of(this.applContext.getParameters()).booleanValue()) {
            object2 = (Event)this.getRow(n);
            SwingUtilities.invokeLater(new Runnable((Event)object2){
                final /* synthetic */ Event val$e;
                {
                    this.val$e = event;
                }

                public void run() {
                    Thread.yield();
                    EventTableModel.this.sort(true);
                    EventTableModel.this.fireTableChanged(new TableModelEvent(EventTableModel.this, EventTableModel.this.getRowIndex(this.val$e), 0, 0, 1001));
                }
            });
        }
    }

    @Override
    public void setRows(List<Event> list) {
        if (this.timeChange && this.rows != null) {
            this.sort(false);
        }
        super.setRows(list);
    }
}

