/*
 * Decompiled with CFR 0.152.
 */
package net.ponec.jworksheet.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.ListModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.ponec.jworksheet.bo.Event;
import net.ponec.jworksheet.bo.Parameters;
import net.ponec.jworksheet.bo.Project;
import net.ponec.jworksheet.bo.item.YearMonthDay;
import net.ponec.jworksheet.core.ApplContext;
import net.ponec.jworksheet.core.ApplTools;
import net.ponec.jworksheet.core.Calculator;
import net.ponec.jworksheet.core.LanguageManager;
import net.ponec.jworksheet.gui.TopDialog;
import net.ponec.jworksheet.report.MetaReport;
import net.ponec.jworksheet.report.ReportA;
import net.ponec.jworksheet.report.ReportB;
import net.ponec.jworksheet.report.ReportC;
import net.ponec.jworksheet.report.ReportTab;
import net.ponec.jworksheet.report.ReportTabProj;
import net.ponec.jworksheet.resources.ResourceProvider;
import org.ujoframework.UjoProperty;
import org.ujoframework.core.UjoActionImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReportDialog
extends TopDialog
implements ActionListener,
ChangeListener,
MouseListener {
    protected static final Logger LOGGER = Logger.getLogger(ReportDialog.class.getName());
    private String spinnerFormat;
    private long originalDay;
    private Boolean result = false;
    private boolean dateSynchroEnabled = true;
    private boolean sorted = false;
    private JButton bCancel;
    private JButton bOK;
    private JButton bReport;
    private JButton bTodayFrom;
    private JButton bTodayTo;
    private ButtonGroup currentDayGroup;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JLabel lDateFrom;
    private JLabel lDateTo;
    private JLabel lQuickSelection;
    private JLabel lReportType;
    private JPanel pButtons;
    private JRadioButton rbDay;
    private JRadioButton rbDayPrev;
    private JRadioButton rbMonth;
    private JRadioButton rbMonthPrev;
    private JRadioButton rbWeek;
    private JRadioButton rbWeekPrev;
    private JRadioButton rbYear;
    private JRadioButton rbYearPrev;
    private JList reportList;
    private JSeparator separator1;
    private JSeparator separator2;
    private JSeparator separator3;
    private JSpinner tDateFrom;
    private JSpinner tDateTo;

    public ReportDialog(Frame frame, ApplContext applContext) {
        super(applContext);
        Object object;
        this.originalDay = applContext.getSelectedDay().getCalendar().getTimeInMillis();
        this.setLocale(applContext.getLanguage());
        this.spinnerFormat = this.applContext.getParameters().getDateFormat(Parameters.P_DATE_REPORT_FORMAT, applContext);
        this.initComponents();
        this.selectDayAction(new ActionEvent(this.rbDay, -1, ""));
        this.setTitle("Report parameters");
        this.getRootPane().setDefaultButton(this.bOK);
        this.currentDayGroup.setSelected(this.rbDay.getModel(), true);
        if (!this.spinnerFormat.startsWith("EEEE")) {
            ApplTools.setAlign(this.tDateFrom, 2);
            ApplTools.setAlign(this.tDateTo, 2);
        }
        if (!Parameters.P_HIDE_ICONS.of(this.applContext.getParameters()).booleanValue()) {
            object = new ResourceProvider();
            this.bOK.setIcon(((ResourceProvider)object).getIcon("_tick.png"));
            this.bReport.setIcon(((ResourceProvider)object).getIcon("_empty.png"));
            this.bCancel.setIcon(((ResourceProvider)object).getIcon("_cross.png"));
        }
        this.reportList.setModel(this.createReportModel());
        this.reportList.setSelectionMode(0);
        this.reportList.setSelectedIndex(0);
        object = this.applContext.getLanguageManager();
        ((LanguageManager)object).setFirstRunTexts(this);
    }

    private String getTitle(String string) {
        try {
            return this.applContext.getLanguageManager().getText("rpt." + string);
        }
        catch (Throwable throwable) {
            return string;
        }
    }

    private String getText(String string) {
        return this.applContext.getLanguageManager().getTextAllways(string);
    }

    private ListModel createReportModel() {
        DefaultListModel<MetaReport> defaultListModel = new DefaultListModel<MetaReport>();
        defaultListModel.addElement(new MetaReport(this.getTitle("DetailInTable"), ReportTab.class));
        defaultListModel.addElement(new MetaReport(this.getTitle("DetailInTableProj"), ReportTabProj.class));
        defaultListModel.addElement(new MetaReport(this.getTitle("ProjectAndTaskSummary"), ReportA.class));
        defaultListModel.addElement(new MetaReport(this.getTitle("ProjectSummary"), ReportB.class));
        defaultListModel.addElement(new MetaReport(this.getTitle("DetailDayReports"), ReportC.class));
        for (MetaReport metaReport : this.applContext.getMetaReports()) {
            String string = metaReport.getTitle();
            metaReport.setTitle(this.getTitle(string));
            defaultListModel.addElement(metaReport);
        }
        return defaultListModel;
    }

    private JSpinner createDateSpinner() {
        return ApplTools.createSpinnerDate(this.spinnerFormat, this.getLocale());
    }

    private YearMonthDay getYearMonthDay(JSpinner jSpinner) {
        YearMonthDay yearMonthDay = new YearMonthDay();
        Date date = (Date)jSpinner.getValue();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        yearMonthDay.setYearMonthDay(calendar);
        return yearMonthDay;
    }

    public Boolean getResult() {
        return this.result;
    }

    @Override
    public final void escapeAction(ActionEvent actionEvent) {
        this.bCancelActionPerformed(actionEvent);
    }

    private ArrayList<String[]> getXslParams(MetaReport metaReport) {
        UjoProperty[] ujoPropertyArray;
        ArrayList<String[]> arrayList = new ArrayList<String[]>(16);
        arrayList.add(new String[]{"DateFrom", this.getYearMonthDay(this.tDateFrom).toString()});
        arrayList.add(new String[]{"DateTo", this.getYearMonthDay(this.tDateTo).toString()});
        arrayList.add(new String[]{"BaseUrl", this.applContext.getConfigDir().toURI().toString()});
        arrayList.add(new String[]{"JWSName", "jWorkSheet"});
        arrayList.add(new String[]{"JWSHomePage", "http://jworksheet.ponec.net/"});
        arrayList.add(new String[]{"Title", metaReport.getTitle()});
        arrayList.add(this.getXslParamItem(Parameters.P_WORKING_HOURS));
        arrayList.add(this.getXslParamItem(Parameters.P_COLOR_PRIVATE));
        arrayList.add(this.getXslParamItem(Parameters.P_COLOR_FINISHED_PROJ));
        arrayList.add(this.getXslParamItem(Parameters.P_REPORT_CSS));
        arrayList.add(new String[]{"labelCreated", this.getText("Created")});
        arrayList.add(new String[]{"labelDate", this.getText("Date")});
        arrayList.add(new String[]{"labelDateFrom", this.getText("DateFrom")});
        arrayList.add(new String[]{"labelDateTo", this.getText("DateTo")});
        arrayList.add(new String[]{"labelTasks", this.getText("Tasks")});
        for (UjoProperty ujoProperty : ujoPropertyArray = new UjoProperty[]{Event.P_DESCR, Event.P_PERIOD, Event.P_PROJ, Event.P_TASK, Event.P_TIME, Project.P_ID, Project.P_DEFAULT, Project.P_FINISHED, Project.P_PRIVATE, Project.P_TASKS}) {
            arrayList.add(this.getXslLabelItem(ujoProperty));
        }
        return arrayList;
    }

    private String[] getXslParamItem(UjoProperty ujoProperty) {
        String[] stringArray = new String[]{ujoProperty.getName(), this.applContext.getParameters().readValueString(ujoProperty, new UjoActionImpl(this))};
        return stringArray;
    }

    private String[] getXslLabelItem(UjoProperty ujoProperty) {
        String[] stringArray = new String[]{"label" + ujoProperty.getName(), this.applContext.getLanguageManager().getTextAllways(ujoProperty)};
        return stringArray;
    }

    private void initComponents() {
        this.currentDayGroup = new ButtonGroup();
        this.jPanel2 = new JPanel();
        this.lDateFrom = new JLabel();
        this.lDateTo = new JLabel();
        this.tDateFrom = this.createDateSpinner();
        this.tDateTo = this.createDateSpinner();
        this.separator1 = new JSeparator();
        this.lQuickSelection = new JLabel();
        this.separator2 = new JSeparator();
        this.separator3 = new JSeparator();
        this.pButtons = new JPanel();
        this.bOK = new JButton();
        this.bReport = new JButton();
        this.bCancel = new JButton();
        this.lReportType = new JLabel();
        this.bTodayFrom = new JButton();
        this.bTodayTo = new JButton();
        this.jPanel1 = new JPanel();
        this.rbDay = new JRadioButton();
        this.rbDayPrev = new JRadioButton();
        this.rbWeek = new JRadioButton();
        this.rbWeekPrev = new JRadioButton();
        this.rbMonth = new JRadioButton();
        this.rbMonthPrev = new JRadioButton();
        this.rbYear = new JRadioButton();
        this.rbYearPrev = new JRadioButton();
        this.jScrollPane1 = new JScrollPane();
        this.reportList = new JList();
        this.setDefaultCloseOperation(2);
        this.getContentPane().setLayout(new GridBagLayout());
        this.jPanel2.setLayout(new GridBagLayout());
        this.lDateFrom.setText("Date from:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 0, 0, 7);
        this.jPanel2.add((Component)this.lDateFrom, gridBagConstraints);
        this.lDateTo.setText("Date to:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 0, 0, 7);
        this.jPanel2.add((Component)this.lDateTo, gridBagConstraints);
        this.tDateFrom.setFont(new Font("Lucida Sans", 0, 11));
        this.tDateFrom.setPreferredSize(new Dimension(220, 18));
        this.tDateFrom.addChangeListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.jPanel2.add((Component)this.tDateFrom, gridBagConstraints);
        this.tDateTo.setFont(new Font("Lucida Sans", 0, 11));
        this.tDateTo.setPreferredSize(new Dimension(220, 18));
        this.tDateTo.addChangeListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.jPanel2.add((Component)this.tDateTo, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 0, 10, 0);
        this.jPanel2.add((Component)this.separator1, gridBagConstraints);
        this.lQuickSelection.setText("<html>Quick<br>date selection:</html>");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(0, 0, 0, 7);
        this.jPanel2.add((Component)this.lQuickSelection, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 0, 10, 0);
        this.jPanel2.add((Component)this.separator2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 0, 10, 0);
        this.jPanel2.add((Component)this.separator3, gridBagConstraints);
        this.pButtons.setLayout(new FlowLayout(1, 5, 0));
        this.bOK.setMnemonic('O');
        this.bOK.setText("OK");
        this.bOK.addActionListener(this);
        this.pButtons.add(this.bOK);
        this.bReport.setMnemonic('R');
        this.bReport.setText("DReport");
        this.bReport.setToolTipText("Open report but don't close this dialog");
        this.bReport.addActionListener(this);
        this.pButtons.add(this.bReport);
        this.bCancel.setMnemonic('C');
        this.bCancel.setText("Cancel");
        this.bCancel.addActionListener(this);
        this.pButtons.add(this.bCancel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 15;
        this.jPanel2.add((Component)this.pButtons, gridBagConstraints);
        this.lReportType.setDisplayedMnemonic('R');
        this.lReportType.setLabelFor(this.reportList);
        this.lReportType.setText("Report:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(0, 0, 0, 7);
        this.jPanel2.add((Component)this.lReportType, gridBagConstraints);
        this.bTodayFrom.setText("GoToday");
        this.bTodayFrom.setMargin(new Insets(1, 14, 1, 14));
        this.bTodayFrom.setMaximumSize(new Dimension(100, 21));
        this.bTodayFrom.setPreferredSize(new Dimension(73, 19));
        this.bTodayFrom.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.jPanel2.add((Component)this.bTodayFrom, gridBagConstraints);
        this.bTodayTo.setText("GoToday");
        this.bTodayTo.setMargin(new Insets(1, 14, 1, 14));
        this.bTodayTo.setMaximumSize(new Dimension(100, 21));
        this.bTodayTo.setPreferredSize(new Dimension(73, 19));
        this.bTodayTo.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.jPanel2.add((Component)this.bTodayTo, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        this.currentDayGroup.add(this.rbDay);
        this.rbDay.setText("Selected day");
        this.rbDay.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.rbDay.setMargin(new Insets(0, 0, 0, 0));
        this.rbDay.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.jPanel1.add((Component)this.rbDay, gridBagConstraints);
        this.currentDayGroup.add(this.rbDayPrev);
        this.rbDayPrev.setText("Previous day");
        this.rbDayPrev.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.rbDayPrev.setMargin(new Insets(0, 0, 0, 0));
        this.rbDayPrev.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        this.jPanel1.add((Component)this.rbDayPrev, gridBagConstraints);
        this.currentDayGroup.add(this.rbWeek);
        this.rbWeek.setText("Selected week");
        this.rbWeek.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.rbWeek.setMargin(new Insets(0, 0, 0, 0));
        this.rbWeek.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 16, 0, 0);
        this.jPanel1.add((Component)this.rbWeek, gridBagConstraints);
        this.currentDayGroup.add(this.rbWeekPrev);
        this.rbWeekPrev.setText("Previous week");
        this.rbWeekPrev.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.rbWeekPrev.setMargin(new Insets(0, 0, 0, 0));
        this.rbWeekPrev.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 16, 0, 0);
        this.jPanel1.add((Component)this.rbWeekPrev, gridBagConstraints);
        this.currentDayGroup.add(this.rbMonth);
        this.rbMonth.setText("Selected month");
        this.rbMonth.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.rbMonth.setMargin(new Insets(0, 0, 0, 0));
        this.rbMonth.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 16, 0, 0);
        this.jPanel1.add((Component)this.rbMonth, gridBagConstraints);
        this.currentDayGroup.add(this.rbMonthPrev);
        this.rbMonthPrev.setText("Previous month");
        this.rbMonthPrev.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.rbMonthPrev.setMargin(new Insets(0, 0, 0, 0));
        this.rbMonthPrev.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 16, 0, 0);
        this.jPanel1.add((Component)this.rbMonthPrev, gridBagConstraints);
        this.currentDayGroup.add(this.rbYear);
        this.rbYear.setText("Selected year");
        this.rbYear.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.rbYear.setMargin(new Insets(0, 0, 0, 0));
        this.rbYear.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 16, 0, 0);
        this.jPanel1.add((Component)this.rbYear, gridBagConstraints);
        this.currentDayGroup.add(this.rbYearPrev);
        this.rbYearPrev.setText("Previous year");
        this.rbYearPrev.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.rbYearPrev.setMargin(new Insets(0, 0, 0, 0));
        this.rbYearPrev.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 16, 0, 0);
        this.jPanel1.add((Component)this.rbYearPrev, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        this.jPanel2.add((Component)this.jPanel1, gridBagConstraints);
        this.reportList.addMouseListener(this);
        this.jScrollPane1.setViewportView(this.reportList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel2.add((Component)this.jScrollPane1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(15, 15, 15, 15);
        this.getContentPane().add((Component)this.jPanel2, gridBagConstraints);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((dimension.width - 563) / 2, (dimension.height - 404) / 2, 563, 404);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.bOK) {
            this.bOKActionPerformed(actionEvent);
        } else if (actionEvent.getSource() == this.bReport) {
            this.bOKActionPerformed(actionEvent);
        } else if (actionEvent.getSource() == this.bCancel) {
            this.bCancelActionPerformed(actionEvent);
        } else if (actionEvent.getSource() == this.bTodayFrom) {
            this.bTodayFromActionPerformed(actionEvent);
        } else if (actionEvent.getSource() == this.bTodayTo) {
            this.bTodayToActionPerformed(actionEvent);
        } else if (actionEvent.getSource() == this.rbDay) {
            this.selectDayAction(actionEvent);
        } else if (actionEvent.getSource() == this.rbDayPrev) {
            this.selectDayAction(actionEvent);
        } else if (actionEvent.getSource() == this.rbWeek) {
            this.selectDayAction(actionEvent);
        } else if (actionEvent.getSource() == this.rbWeekPrev) {
            this.selectDayAction(actionEvent);
        } else if (actionEvent.getSource() == this.rbMonth) {
            this.selectDayAction(actionEvent);
        } else if (actionEvent.getSource() == this.rbMonthPrev) {
            this.selectDayAction(actionEvent);
        } else if (actionEvent.getSource() == this.rbYear) {
            this.selectDayAction(actionEvent);
        } else if (actionEvent.getSource() == this.rbYearPrev) {
            this.selectDayAction(actionEvent);
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() == this.reportList) {
            this.reportListMouseClicked(mouseEvent);
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        if (changeEvent.getSource() == this.tDateFrom) {
            this.tDateFromStateChanged(changeEvent);
        } else if (changeEvent.getSource() == this.tDateTo) {
            this.tDateFromStateChanged(changeEvent);
        }
    }

    private void reportListMouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() == 1 && mouseEvent.getClickCount() == 2 && this.reportList.getSelectedIndex() >= 0) {
            this.bOKActionPerformed(null);
        }
    }

    private void tDateFromStateChanged(ChangeEvent changeEvent) {
        if (this.dateSynchroEnabled && this.isVisible()) {
            int n;
            JSpinner jSpinner = (JSpinner)changeEvent.getSource();
            JSpinner jSpinner2 = jSpinner == this.tDateFrom ? this.tDateTo : this.tDateFrom;
            Date date = (Date)jSpinner.getValue();
            Date date2 = (Date)jSpinner2.getValue();
            int n2 = n = jSpinner == this.tDateFrom ? date.compareTo(date2) : date2.compareTo(date);
            if (n > 0) {
                this.dateSynchroEnabled = false;
                jSpinner2.setValue(date);
                this.dateSynchroEnabled = true;
            }
        }
    }

    private void bTodayToActionPerformed(ActionEvent actionEvent) {
        this.tDateTo.setValue(new Date());
    }

    private void bTodayFromActionPerformed(ActionEvent actionEvent) {
        this.tDateFrom.setValue(new Date());
    }

    private void bOKActionPerformed(ActionEvent actionEvent) {
        this.bOK.setEnabled(false);
        ApplTools.setCursorWait(true, this.applContext);
        MetaReport metaReport = (MetaReport)this.reportList.getSelectedValue();
        if (metaReport != null) {
            try {
                if (!this.sorted) {
                    this.applContext.getWorkSpace().sortDays();
                    this.sorted = true;
                }
                if (metaReport.getXSL() != null) {
                    this.result = null;
                    this.applContext.showReport(null, metaReport.getXSL(), this.getXslParams(metaReport));
                } else {
                    Calculator calculator = metaReport.getTypeClass().newInstance();
                    calculator.init(this.applContext, this.getYearMonthDay(this.tDateFrom), this.getYearMonthDay(this.tDateTo), metaReport.getTitle());
                    String string = calculator.print();
                    this.applContext.showReport(string);
                    this.result = null;
                }
            }
            catch (Throwable throwable) {
                this.applContext.getTopFrame().showMessage("Report failed", throwable);
            }
        }
        this.bOK.setEnabled(true);
        ApplTools.setCursorWait(false, this.applContext);
        if (actionEvent == null || actionEvent.getSource() == this.bOK) {
            this.bCancelActionPerformed(null);
        }
    }

    private void bCancelActionPerformed(ActionEvent actionEvent) {
        this.setVisible(false);
        this.dispose();
    }

    private void selectDayAction(ActionEvent actionEvent) {
        Calendar calendar = Calendar.getInstance();
        Calendar calendar2 = Calendar.getInstance();
        calendar.setTimeInMillis(this.originalDay);
        calendar2.setTimeInMillis(this.originalDay);
        int n = Parameters.P_FIRST_DAY_OF_WEEK.of(this.applContext.getParameters());
        Object object = actionEvent.getSource();
        if (this.rbDayPrev == object) {
            calendar.add(6, -1);
        } else if (this.rbWeekPrev == object) {
            calendar.add(3, -1);
        } else if (this.rbMonthPrev == object) {
            calendar.add(2, -1);
        } else if (this.rbYearPrev == object) {
            calendar.add(1, -1);
        }
        if (object == this.rbDayPrev) {
            calendar2.setTimeInMillis(calendar.getTimeInMillis());
        } else if (object == this.rbWeek || object == this.rbWeekPrev) {
            int n2 = calendar2.get(7);
            calendar.add(6, n - n2);
            calendar2.setTimeInMillis(calendar.getTimeInMillis());
            calendar2.add(6, 6);
        } else if (object == this.rbMonth || object == this.rbMonthPrev) {
            int n3 = calendar2.get(5);
            calendar.add(6, 1 - n3);
            calendar2.setTimeInMillis(calendar.getTimeInMillis());
            calendar2.add(2, 1);
            calendar2.add(6, -1);
        } else if (object == this.rbYear || object == this.rbYearPrev) {
            int n4 = calendar2.get(6);
            calendar.add(6, 1 - n4);
            calendar2.setTimeInMillis(calendar.getTimeInMillis());
            calendar2.add(1, 1);
            calendar2.add(6, -1);
        }
        this.dateSynchroEnabled = false;
        this.tDateFrom.setValue(calendar.getTime());
        this.tDateTo.setValue(calendar2.getTime());
        this.dateSynchroEnabled = true;
    }
}

