/*
 * Decompiled with CFR 0.152.
 */
package org.ujoframework.listener;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.ujoframework.Ujo;
import org.ujoframework.UjoProperty;
import org.ujoframework.listener.UjoPropertyChangeEvent;
import org.ujoframework.listener.UjoPropertyChangeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UjoPropertyChangeSupport {
    private final Ujo source;
    private final Boolean before;
    private HashMap<UjoProperty, List<UjoPropertyChangeListener>> listenerMapBefore;
    private HashMap<UjoProperty, List<UjoPropertyChangeListener>> listenerMapAfter;

    public UjoPropertyChangeSupport(Ujo ujo) {
        this(ujo, null);
    }

    public UjoPropertyChangeSupport(Ujo ujo, Boolean bl) {
        this.source = ujo;
        this.before = bl;
    }

    private final List<UjoPropertyChangeListener> getListeners(UjoProperty ujoProperty, boolean bl) {
        List<UjoPropertyChangeListener> list;
        HashMap hashMap;
        HashMap<UjoProperty, List<UjoPropertyChangeListener>> hashMap2 = hashMap = bl ? this.listenerMapBefore : this.listenerMapAfter;
        if (hashMap == null) {
            hashMap = new HashMap();
            if (bl) {
                this.listenerMapBefore = hashMap;
            } else {
                this.listenerMapAfter = hashMap;
            }
        }
        if ((list = hashMap.get(ujoProperty)) == null) {
            list = new ArrayList<UjoPropertyChangeListener>(1);
            hashMap.put(ujoProperty, list);
        }
        return list;
    }

    public boolean addPropertyChangeListener(UjoProperty ujoProperty, Boolean bl, UjoPropertyChangeListener ujoPropertyChangeListener) {
        this.testSupport(bl);
        if (bl == null) {
            boolean bl2 = this.getListeners(ujoProperty, true).add(ujoPropertyChangeListener);
            boolean bl3 = this.getListeners(ujoProperty, false).add(ujoPropertyChangeListener);
            return bl2 && bl3;
        }
        return this.getListeners(ujoProperty, bl).add(ujoPropertyChangeListener);
    }

    public boolean removePropertyChangeListener(UjoProperty ujoProperty, Boolean bl, UjoPropertyChangeListener ujoPropertyChangeListener) {
        this.testSupport(bl);
        if (bl == null) {
            boolean bl2 = this.getListeners(ujoProperty, true).remove(ujoPropertyChangeListener);
            boolean bl3 = this.getListeners(ujoProperty, false).remove(ujoPropertyChangeListener);
            return bl2 && bl3;
        }
        return this.getListeners(ujoProperty, bl).remove(ujoPropertyChangeListener);
    }

    public void firePropertyChange(UjoProperty ujoProperty, Object object, Object object2, boolean bl) {
        HashMap<UjoProperty, List<UjoPropertyChangeListener>> hashMap;
        HashMap<UjoProperty, List<UjoPropertyChangeListener>> hashMap2 = hashMap = bl ? this.listenerMapBefore : this.listenerMapAfter;
        if (hashMap == null) {
            return;
        }
        List<UjoPropertyChangeListener> list = hashMap.get(ujoProperty);
        if (list != null) {
            UjoPropertyChangeEvent ujoPropertyChangeEvent = new UjoPropertyChangeEvent(this.source, ujoProperty, object, object2, bl);
            for (UjoPropertyChangeListener ujoPropertyChangeListener : list) {
                ujoPropertyChangeListener.propertyChange(ujoPropertyChangeEvent);
            }
        }
    }

    private void testSupport(Boolean bl) {
        if (this.before == null || this.before == bl || this.before.equals(bl)) {
            return;
        }
        String string = bl == null ? "before or after" : (bl == true ? "before" : "after");
        throw new UnsupportedOperationException("Action is not supported : " + string);
    }

    public Boolean getBefore() {
        return this.before;
    }
}

