/*
 * Decompiled with CFR 0.152.
 */
package borland.jbcl.model;

import borland.jbcl.model.ItemEditMaskCharObj;
import borland.jbcl.model.ItemEditMaskRegionChar;
import borland.jbcl.model.ItemEditMaskStr;
import borland.jbcl.model.SystemResourceBundle;
import java.util.ResourceBundle;
import java.util.Vector;

public class ItemEditMaskRegion
implements ItemEditMaskRegionChar {
    ItemEditMaskStr ems;
    boolean optional;
    int capacity;
    int minRequired;
    int offset;
    Vector charObjects;
    boolean rightToLeft;
    int charCount;
    char c;

    public ItemEditMaskRegion(ItemEditMaskStr itemEditMaskStr, boolean bl) {
        int n;
        this.ems = itemEditMaskStr;
        this.optional = bl;
        this.charObjects = new Vector(0);
        this.capacity = 0;
        this.rightToLeft = true;
        this.charCount = 0;
        this.minRequired = 0;
        ItemEditMaskRegion itemEditMaskRegion = null;
        this.offset = 0;
        if (itemEditMaskStr.editRegions != null && (n = itemEditMaskStr.editRegions.size()) > 0 && (itemEditMaskRegion = (ItemEditMaskRegion)itemEditMaskStr.editRegions.elementAt(n - 1)) != null) {
            this.offset = itemEditMaskRegion.offset + itemEditMaskRegion.capacity;
        }
    }

    public boolean isValid(int n, char c) {
        ItemEditMaskCharObj itemEditMaskCharObj = this.emoFromPosition(n);
        return itemEditMaskCharObj == null ? false : itemEditMaskCharObj.isValid(c);
    }

    public boolean isOptional(int n) {
        boolean bl = true;
        if (this.optional) {
            return bl;
        }
        ItemEditMaskCharObj itemEditMaskCharObj = this.emoFromPosition(n);
        if (itemEditMaskCharObj != null && itemEditMaskCharObj.isOptional()) {
            bl = true;
        } else if (this.minRequired > 0) {
            int n2 = n - this.offset;
            if (n2 < 0) {
                return true;
            }
            if (n2 >= this.capacity) {
                return true;
            }
            bl = this.rightToLeft ? this.capacity - n2 > this.minRequired : n2 > this.minRequired - 1;
        } else {
            bl = false;
        }
        return bl;
    }

    public char setCharAt(StringBuffer stringBuffer, int n, char c) {
        stringBuffer.setCharAt(n, c);
        return c;
    }

    public char getCharAt(StringBuffer stringBuffer, int n) {
        char c = stringBuffer.charAt(n);
        return c;
    }

    public boolean isLiteral(int n) {
        return false;
    }

    public void deleteCharAt(StringBuffer stringBuffer, int n, char c) {
        this.setCharAt(stringBuffer, n, c);
    }

    protected final ItemEditMaskCharObj emoFromPosition(int n) {
        int n2 = n - this.offset;
        if (this.charObjects == null) {
            return null;
        }
        if (n2 < 0) {
            return null;
        }
        if (n2 >= this.capacity) {
            return null;
        }
        if (n2 >= this.charObjects.size()) {
            n2 = 0;
        }
        if (n2 >= this.charObjects.size()) {
            // empty if block
        }
        return (ItemEditMaskCharObj)this.charObjects.elementAt(n2);
    }

    protected final void extentsOfResource(String string) {
        ResourceBundle resourceBundle = SystemResourceBundle.getBundle("java.text.resources.LocaleElements", this.ems.locale);
        String[] stringArray = resourceBundle.getStringArray(string);
        int n = stringArray.length;
        this.capacity = 0;
        this.minRequired = 30000;
        for (int i = 0; i < n; ++i) {
            int n2 = stringArray[i].length();
            if (n2 == 0) continue;
            this.capacity = Math.max(this.capacity, n2);
            this.minRequired = Math.min(this.minRequired, n2);
        }
    }
}

