/*
 * Decompiled with CFR 0.152.
 */
package jpdftweak.gui;

import com.itextpdf.text.DocumentException;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;
import javax.swing.filechooser.FileFilter;
import jpdftweak.core.PdfInputFile;
import jpdftweak.core.PdfTweak;
import jpdftweak.gui.tabs.AttachmentTab;
import jpdftweak.gui.tabs.BookmarkTab;
import jpdftweak.gui.tabs.DocumentInfoTab;
import jpdftweak.gui.tabs.EncryptSignTab;
import jpdftweak.gui.tabs.InputTab;
import jpdftweak.gui.tabs.InteractionTab;
import jpdftweak.gui.tabs.OutputTab;
import jpdftweak.gui.tabs.PageNumberTab;
import jpdftweak.gui.tabs.PageSizeTab;
import jpdftweak.gui.tabs.ShuffleTab;
import jpdftweak.gui.tabs.Tab;
import jpdftweak.gui.tabs.WatermarkTab;

public class MainForm
extends JFrame {
    private InputTab inputTab = new InputTab(this);
    private Tab[] tabs = new Tab[]{this.inputTab, new PageSizeTab(this), new WatermarkTab(this), new ShuffleTab(this), new PageNumberTab(this), new BookmarkTab(this), new AttachmentTab(this), new InteractionTab(this), new DocumentInfoTab(this), new EncryptSignTab(this), new OutputTab(this)};
    private PdfInputFile inputFile;
    private JFileChooser pdfChooser = new JFileChooser();

    public MainForm() {
        super("jPDF Tweak 1.1");
        this.setIconImage(Toolkit.getDefaultToolkit().createImage(MainForm.class.getResource("/icon.png")));
        this.pdfChooser.setFileFilter(new FileFilter(){

            public String getDescription() {
                return "PDF files (*.pdf)";
            }

            public boolean accept(File file) {
                return file.isDirectory() || file.getName().toLowerCase().endsWith("pdf");
            }
        });
        this.setLayout((LayoutManager)new FormLayout("f:p:g,f:p,f:p", "f:p:g,f:p"));
        CellConstraints cellConstraints = new CellConstraints();
        JTabbedPane jTabbedPane = new JTabbedPane();
        this.add((Component)jTabbedPane, cellConstraints.xyw(1, 1, 3));
        for (Tab tab : this.tabs) {
            jTabbedPane.addTab(tab.getTabName(), tab);
        }
        JButton jButton = new JButton("Run");
        this.add((Component)jButton, cellConstraints.xy(2, 2));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MainForm.this.runTweaks();
            }
        });
        JButton jButton2 = new JButton("Quit");
        this.add((Component)jButton2, cellConstraints.xy(3, 2));
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MainForm.this.dispose();
            }
        });
        this.pack();
        this.getRootPane().setDefaultButton(jButton);
        this.setLocationRelativeTo(null);
        this.setDefaultCloseOperation(3);
        this.setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runTweaks() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        PdfTweak pdfTweak = null;
        try {
            for (Tab tab : this.tabs) {
                tab.checkRun();
            }
            for (int i = 0; i < this.inputTab.getBatchLength(); ++i) {
                this.inputTab.selectBatchTask(i);
                pdfTweak = null;
                for (Tab tab : this.tabs) {
                    pdfTweak = tab.run(pdfTweak);
                }
            }
            JOptionPane.showMessageDialog(this, "Finished", "JPDFTweak", 1);
        }
        catch (DocumentException documentException) {
            documentException.printStackTrace();
            JOptionPane.showMessageDialog(this, documentException.getMessage(), "Error", 0);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            JOptionPane.showMessageDialog(this, iOException.getMessage(), "Error", 0);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            outOfMemoryError.printStackTrace();
            JOptionPane.showMessageDialog(this, "jPDF Tweak has run out of memory. You may configure Java so that it may use more RAM, or you can enable the Tempfile option on the output tab.", "Out of memory: " + outOfMemoryError.getMessage(), 0);
        }
        finally {
            if (pdfTweak != null) {
                pdfTweak.cleanup();
            }
        }
        this.setCursor(null);
    }

    public JFileChooser getPdfChooser() {
        return this.pdfChooser;
    }

    public PdfInputFile getInputFile() {
        return this.inputFile;
    }

    public void setInputFile(PdfInputFile pdfInputFile) {
        this.inputFile = pdfInputFile;
    }

    public InputTab getInputTab() {
        return this.inputTab;
    }
}

