/*
 * Decompiled with CFR 0.152.
 */
package jpdftweak.cli;

import com.itextpdf.text.DocumentException;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jpdftweak.cli.CommandOption;
import jpdftweak.core.PdfInputFile;
import jpdftweak.core.PdfTweak;

public class WatermarkOptions
implements CommandOption {
    private String background = null;
    private String text = null;
    private int textsize;
    private float textopacity;
    private Color textcolor;
    private int position = -1;
    private boolean flipEven = false;
    private int nsize;
    private float xoff;
    private float yoff;
    private String mask;

    public boolean supportsOption(String string) {
        return string.equals("-background") || string.equals("-watermark") || string.equals("-numbers");
    }

    public boolean setOption(String string, String string2) {
        Matcher matcher;
        if (string.equals("-background")) {
            this.background = string2;
        }
        if (string.equals("-watermark")) {
            matcher = Pattern.compile("(.*),([0-9]+),([0-9.]+)(,#[0-9a-fA-F]{6})?").matcher(string2);
            if (!matcher.matches()) {
                System.err.println("Error: Invalid parameter for -watermark option");
                return false;
            }
            this.text = matcher.group(1);
            this.textsize = Integer.parseInt(matcher.group(2));
            this.textopacity = Float.parseFloat(matcher.group(3));
            if (matcher.group(4) != null) {
                this.textcolor = new Color(Integer.parseInt(matcher.group(4).substring(2, 4), 16), Integer.parseInt(matcher.group(4).substring(4, 6), 16), Integer.parseInt(matcher.group(4).substring(6, 8), 16));
            }
        }
        if (string.equals("-numbers")) {
            matcher = Pattern.compile("([LRIOTBC]|[LRIO][TB]),([0-9]+),(-?[0-9]+),(-?[0-9]+)(,.+)?").matcher(string2);
            if (!matcher.matches()) {
                System.err.println("Error: Invalid parameter for -numbers option");
                return false;
            }
            this.position = Arrays.asList("LB", "B", "RB", "L", "C", "R", "LT", "T", "RT").indexOf(matcher.group(1));
            if (this.position == -1) {
                this.position = Arrays.asList("IB", "B", "OB", "I", "C", "O", "IT", "T", "OT").indexOf(matcher.group(1));
                this.flipEven = true;
            }
            if (this.position == -1) {
                throw new RuntimeException(matcher.group(1));
            }
            this.nsize = Integer.parseInt(matcher.group(2));
            this.xoff = Integer.parseInt(matcher.group(3));
            this.yoff = Integer.parseInt(matcher.group(4));
            this.mask = matcher.group(5) == null ? null : matcher.group(5).substring(1);
        }
        return true;
    }

    public void run(PdfTweak pdfTweak, PdfInputFile pdfInputFile) throws IOException, DocumentException {
        if (this.background != null || this.text != null || this.position != -1) {
            pdfTweak.addWatermark(this.background == null ? null : new PdfInputFile(new File(this.background), ""), this.text, this.textsize, this.textopacity, this.textcolor, this.position, this.flipEven, this.nsize, this.xoff, this.yoff, this.mask);
        }
    }

    public String getSummary() {
        return " -background             Add file as background watermark\n -watermark              Add text watermark\n -numbers                Add page numbers\n";
    }

    public String getHelp(String string) {
        if (string.equals("-background")) {
            return " -background {FILENAME}\n    Add first page of file {FILENAME} as background watermark.\n    This watermark file may not be password protected.";
        }
        if (string.equals("-watermark")) {
            return " -watermark {TEXT},{FONTSIZE},{OPACITY}[,#{RRGGBB}]\n    Add a text watermark. {OPACITY} is a float between 0 and 1,\n    for example 0.25. {RRGGBB} is a HTML color.";
        }
        if (string.equals("-numbers")) {
            return " -numbers {POSITION},{FONTSIZE},{XOFFSET},{YOFFSET}{,MASK}\n    Add page numbers. {XOFFSET} and {YOFFSET} are in PostScript\n    points. {POSITION} may be one of:\n\n        L left edge\n        R right edge\n        I inner edge\n        O outer edge\n        T top edge\n        B bottom edge\n        LB left bottom corner\n        RB right bottom corner\n        IB inner bottom corner\n        OB outer bottom corner\n        LT left top corner\n        RT right top corner\n        IT inner top corner\n        OT outer top corner\n        C center of page";
        }
        throw new RuntimeException();
    }
}

