/*
 * jNPad v0.3 - jNPad's an Simple Text Editor written in Java
 *
 * Copyright (C) 2014-2017  rgs
 *
 * Require JDK 1.6 (or later)
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 *
 *
 * Info, Questions, Suggestions & Bugs Report to rgsevero@gmail.com
 */

package jnpad.ui.table;

import java.text.NumberFormat;

import javax.swing.JTable;

import jnpad.util.Utilities;

/**
 * The Class DoubleTableCellRenderer.
 *
 * @version 0.3
 * @since   jNPad v0.1
 */
public class DoubleTableCellRenderer extends NumberTableCellRenderer {
  private NumberFormat      formatter;

  /** UID */
  private static final long serialVersionUID = 1041002277552820888L;

  /**
   * Instantiates a new double table cell renderer.
   */
  public DoubleTableCellRenderer() {
    super();
  }

  /**
   * Instantiates a new double table cell renderer.
   *
   * @param tooltipEnabled boolean
   */
  public DoubleTableCellRenderer(boolean tooltipEnabled) {
    super(tooltipEnabled);
  }

  /**
   * Sets the value.
   *
   * @param table the table
   * @param value the value
   * @param row the row
   * @param column the column
   * @see jnpad.ui.table.LabelTableCellRenderer#setValue(javax.swing.JTable, java.lang.Object, int, int)
   */
  @Override
  protected void setValue(JTable table, Object value, int row, int column) {
    if (formatter == null) {
      formatter = NumberFormat.getInstance();
    }
    String s = (value == null) ? Utilities.EMPTY_STRING : formatter.format(value);
    setText(s);
    if (isTooltipEnabled()) {
      if (s.length() > 0) {
        setToolTipText(s);
      }
      else {
        setToolTipText(null);
      }
    }
  }
}
