/*
 * jNPad v0.3 - jNPad's an Simple Text Editor written in Java
 *
 * Copyright (C) 2014-2017  rgs
 *
 * Require JDK 1.6 (or later)
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 *
 *
 * Info, Questions, Suggestions & Bugs Report to rgsevero@gmail.com
 */

package jnpad.ui.status;

import jnpad.util.LinePosition;
import jnpad.util.LineSeparator;

/**
 * 
 * @version 0.3
 * @since   jNPad v0.1
 */
public interface ITextStatusBar extends StatusDisplayable {
  /**
   * The Enum StatusMessage.
   */
  enum StatusMessage {
    STATUS,
    LINE,
    POSITION,
    CHARACTER,
    SELECTION,
    OCCURRENCES,
    EOL,
    ENCODING,
    TEXT_MODE,
    READ_ONLY,
    CAPS_LOCK,
    NUM_LOCK,
  }
  
  /**
   * 
   * @param p LinePosition
   */
  void setLinePosition(LinePosition p);

  /**
   * 
   * @param pos int
   * @param len int
   */
  void setPosition(int pos, int len);

  /**
   * 
   * @param c char
   */
  void setCharacter(char c);

  /**
   * 
   * @param sel int
   */
  void setSelection(int sel);

  /**
   * 
   * @param occ int
   */
  void setOccurrences(int occ);

  /**
   * 
   * @param ls LineSeparator
   */
  void setEOL(LineSeparator ls);

  /**
   * 
   * @param encoding String
   */
  void setEncoding(String encoding);

  /**
   * 
   * @return boolean
   */
  boolean isOverwriteTextMode();

  /**
   * 
   * @param b boolean
   */
  void setAsOverwriteTextMode(boolean b);

  /**
   * 
   * @return boolean
   */
  boolean isReadOnlyIndicatorEnabled();

  /**
   * 
   * @param b boolean
   */
  void setReadOnlyIndicatorEnabled(boolean b);

  /**
   * 
   * @return boolean
   */
  boolean isCapsLockIndicatorEnabled();

  /**
   * 
   * @param b boolean
   */
  void setCapsLockIndicatorEnabled(boolean b);

  /**
   * 
   * @return boolean
   */
  boolean isNumLockIndicatorEnabled();

  /**
   * 
   * @param b boolean
   */
  void setNumLockIndicatorEnabled(boolean b);

  /**
   * Gets the message.
   *
   * @param message_type the message_type
   * @return the message
   */
  String getMessage(StatusMessage message_type);

  /**
   * Sets the message.
   *
   * @param message_type the message_type
   * @param message the message
   */
  void setMessage(StatusMessage message_type, String message);

}
