/*
 * jNPad v0.3 - jNPad's an Simple Text Editor written in Java
 *
 * Copyright (C) 2014-2017  rgs
 *
 * Require JDK 1.6 (or later)
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 *
 *
 * Info, Questions, Suggestions & Bugs Report to rgsevero@gmail.com
 */

package jnpad.ui.plaf;

import jnpad.GUIUtilities;
import jnpad.util.Platform;

import javax.swing.*;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import javax.swing.plaf.metal.DefaultMetalTheme;
import java.awt.*;
import java.util.logging.Level;
import java.util.logging.Logger;

/**
 * The Class JNPadDarkMetalTheme.
 *
 * @version 0.3
 * @since   jNPad v0.1
 */
@SuppressWarnings("all")
public class JNPadDarkMetalTheme extends DefaultMetalTheme {
  private static final ColorUIResource PRIMARY1 = new ColorUIResource(121, 121, 125);
  private static final ColorUIResource PRIMARY2 = new ColorUIResource(71,71,75);
  private static final ColorUIResource PRIMARY3 = new ColorUIResource(99,99,99);

  private static final ColorUIResource SECUNDARY1 = new ColorUIResource(113,113,113);
  private static final ColorUIResource SECUNDARY2 = new ColorUIResource(91,91,95);
  private static final ColorUIResource SECUNDARY3 = new ColorUIResource(51,51,55);

  static final ColorUIResource         BLACK        = new ColorUIResource(222,222,222);
  static final ColorUIResource         WHITE        = new ColorUIResource(18,30,49);

  private static final FontUIResource  PLAIN_FONT, BOLD_FONT;

  static {
    label0: {
      if (Platform.isWindows) {
        Font font = (Font) Toolkit.getDefaultToolkit().getDesktopProperty("win.messagebox.font"); //$NON-NLS-1$
        if (font != null) {
          PLAIN_FONT = new FontUIResource(font.getName(), Font.PLAIN, font.getSize());
          BOLD_FONT = new FontUIResource(font.getName(), Font.BOLD, font.getSize());
          break label0;
        }
      }
      PLAIN_FONT = new FontUIResource("Dialog", Font.PLAIN, 12); //$NON-NLS-1$
      BOLD_FONT = new FontUIResource("Dialog", Font.BOLD, 12); //$NON-NLS-1$
    }
  }

  /** Logger */
  private final static Logger          LOGGER       = Logger.getLogger(JNPadDarkMetalTheme.class.getName());

  @Override public String getName() {return "jNPad (Dark)";} //$NON-NLS-1$

  @Override protected ColorUIResource getPrimary1() {return PRIMARY1;}
  @Override protected ColorUIResource getPrimary2() {return PRIMARY2;}
  @Override protected ColorUIResource getPrimary3() {return PRIMARY3;}

  @Override protected ColorUIResource getSecondary1() {return SECUNDARY1;}
  @Override protected ColorUIResource getSecondary2() {return SECUNDARY2;}
  @Override protected ColorUIResource getSecondary3() {return SECUNDARY3;}

  @Override protected ColorUIResource getWhite() {return WHITE;}
  @Override protected ColorUIResource getBlack() {return BLACK;}
  
  @Override public FontUIResource getControlTextFont() {return PLAIN_FONT;}
  @Override public FontUIResource getMenuTextFont()    {return PLAIN_FONT;}
  @Override public FontUIResource getSystemTextFont()  {return PLAIN_FONT;}
  @Override public FontUIResource getUserTextFont()    {return PLAIN_FONT;}
  @Override public FontUIResource getWindowTitleFont() {return BOLD_FONT ;}
  
  /**
   * Adds the custom entries to table.
   * 
   * @param table the table
   * @see javax.swing.plaf.metal.MetalTheme#addCustomEntriesToTable(javax.swing.UIDefaults)
   */
  @Override
  public void addCustomEntriesToTable(UIDefaults table) {
    try {
      Object[] defaults = new Object[] {
		"jnpad.dark.theme"                         , Boolean.TRUE                                      ,
		"jnpad.imageicon.filter"                   , new DarkIconFilter()                              ,

		"FileChooser.upFolderIcon"                 , GUIUtilities.getIcon("plaf/upFolder.png")         ,
		"FileChooser.newFolderIcon"                , GUIUtilities.getIcon("plaf/newFolder.png")        ,
		"FileChooser.homeFolderIcon"               , GUIUtilities.getIcon("plaf/homeFolder.png")       ,
		"FileChooser.listViewIcon"                 , GUIUtilities.getIcon("plaf/listView.png")         ,
		"FileChooser.detailsViewIcon"              , GUIUtilities.getIcon("plaf/detailsView.png")      ,

		"OptionPane.errorIcon"                     , GUIUtilities.getIcon("plaf/errorDialog.png")      ,
		"OptionPane.informationIcon"               , GUIUtilities.getIcon("plaf/informationDialog.png"),
		"OptionPane.warningIcon"                   , GUIUtilities.getIcon("plaf/warningDialog.png")    ,
		"OptionPane.questionIcon"                  , GUIUtilities.getIcon("plaf/questionDialog.png")   ,
		
		"LabelUI"                                  , JNPadLabelUI.class.getName()                      ,
		"ButtonUI"                                 , JNPadButtonUI.class.getName()                     ,
		"ToggleButtonUI"                           , JNPadToggleButtonUI.class.getName()               ,
		"ToolBarUI"                                , JNPadToolBarUI.class.getName()                    ,
		"ToolBarSeparatorUI"                       , JNPadToolbarSeparatorUI.class.getName()           ,

		"SplitPaneUI"                              , BasicSplitPaneUI.class.getName()                  ,
		//"SplitPane.dividerSize"                  , 3                                                 ,

		"ScrollBarUI"                              , JNPadScrollBarUI.class.getName()                  ,
		"ScrollBar.track"                          , getControlShadow()                                ,
		"ScrollBar.trackHighlight"                 , getControl()                                      ,

		//"TabbedPaneUI"                           , JNPadTabbedPaneUI.class.getName()                 ,
		"TabbedPane.selected"                      , WHITE                                             ,

		"MenuUI"                                   , JNPadMenuUI.class.getName()                       ,

		//"PopupMenu.background"                   , WHITE                                             ,
		//"MenuItem.background"                    , WHITE                                             ,
		//"RadioButtonMenuItem.background"         , WHITE                                             ,
		//"CheckBoxMenuItem.background"            , WHITE                                             ,

		"TitledBorder.titleColor"                  , PRIMARY1                                          ,

		"ToolTip.background"                       , WHITE                                             ,
		
		"MenuItem.acceleratorForeground"           , JNPadLightMetalTheme.LIGHT_GRAY_0                      ,
		"CheckBoxMenuItem.acceleratorForeground"   , JNPadLightMetalTheme.LIGHT_GRAY_0                      ,
		"RadioButtonMenuItem.acceleratorForeground", JNPadLightMetalTheme.LIGHT_GRAY_0                      ,
      };
      table.putDefaults(defaults);
    }
    catch (Exception ex) {
      LOGGER.log(Level.WARNING, ex.getMessage(), ex);
    }
  }
  
}
