/*
 * jNPad v0.3 - jNPad's an Simple Text Editor written in Java
 *
 * Copyright (C) 2014-2017  rgs
 *
 * Require JDK 1.6 (or later)
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 *
 *
 * Info, Questions, Suggestions & Bugs Report to rgsevero@gmail.com
 */

package jnpad.text.syntax;

import java.awt.Color;
import java.awt.Font;

import jnpad.config.Config;
import jnpad.text.Scheme;

/**
 * The Class PlainScheme.
 *
 * @version 0.3
 * @since   jNPad v0.1
 */
public class PlainScheme extends Scheme {
  /** The text font. */
  Font                      textFont;

  /** The text color. */
  Color                     textColor;

  /** The selected text color. */
  Color                     selectedTextColor;

  /** UID */
  private static final long serialVersionUID = 6403432643578009476L;

  /**
   * Instantiates a new plain scheme.
   *
   * @param mini the mini
   */
  public PlainScheme(boolean mini) {
    super(mini);
    doUpdateColors();
    doUpdateFonts();
  }

  /**
   * Do update colors.
   */
  private void doUpdateColors() {
    textColor         = Config.TEXT_FOREGROUND.getValue();
    selectedTextColor = Config.TEXT_SELECTION_FOREGROUND.getValue();
  }

  /**
   * Do update fonts.
   */
  private void doUpdateFonts() {
    // minimap support [v0.3]
    textFont = !mini ? Config.TEXT_FONT.getValue() :
        Config.TEXT_FONT.getValue().deriveFont(Config.MINIMAP_FONT_SIZE.getValue());
  }

  /**
   * Configure.
   * 
   * @param cfg the cfg
   * @see jnpad.config.Configurable#configure(int)
   */
  @Override
  public void configure(final int cfg) {
    if ((cfg & CFG_COLOR) != 0) {
      doUpdateColors();
    }
    if ((cfg & CFG_FONT) != 0) {
      doUpdateFonts();
    }
  }

  /**
   * Gets the selected text color.
   *
   * @return the selected text color
   * @see jnpad.text.Scheme#getSelectedTextColor()
   */
  @Override
  public Color getSelectedTextColor() {
    return selectedTextColor;
  }

  /**
   * Gets the text color.
   *
   * @return the text color
   * @see jnpad.text.Scheme#getTextColor()
   */
  @Override
  public Color getTextColor() {
    return textColor;
  }
  
  /**
   * Sets the text color.
   *
   * @param c the new text color
   * @see jnpad.text.Scheme#setTextColor(java.awt.Color)
   */
  @Override
  public void setTextColor(Color c) {
    textColor = c;
  }

  /**
   * Gets the text font.
   *
   * @return the text font
   * @see jnpad.text.Scheme#getTextFont()
   */
  @Override
  public Font getTextFont() {
    return textFont;
  }

  /**
   * Sets the text font.
   *
   * @param f the new text font
   * @see jnpad.text.Scheme#setTextFont(java.awt.Font)
   */
  @Override
  public void setTextFont(Font f) {
    textFont = f;
  }

  /**
   * Gets the content type.
   *
   * @return the content type
   * @see jnpad.text.Scheme#getContentType()
   */
  @Override
  public String getContentType() {
    return ContentTypes.PLAIN;
  }

  /**
   * Gets the start comment.
   *
   * @return the start comment
   * @see jnpad.text.Scheme#getStartComment()
   */
  @Override
  public String[] getStartComment() {
    return null;
  }

  /**
   * Gets the end comment.
   *
   * @return the end comment
   * @see jnpad.text.Scheme#getEndComment()
   */
  @Override
  public String[] getEndComment() {
    return null;
  }
  
  /**
   * Gets the start multiline comment.
   *
   * @return the start multiline comment
   * @see jnpad.text.Scheme#getStartMultilineComment()
   */
  @Override
  public String[] getStartMultilineComment() {
    return null;
  }

  /**
   * Gets the end multiline comment.
   *
   * @return the end multiline comment
   * @see jnpad.text.Scheme#getEndMultilineComment()
   */
  @Override
  public String[] getEndMultilineComment() {
    return null;
  }
  
}
