/*
 * jNPad v0.3 - jNPad's an Simple Text Editor written in Java
 *
 * Copyright (C) 2014-2017  rgs
 *
 * Require JDK 1.6 (or later)
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 *
 *
 * Info, Questions, Suggestions & Bugs Report to rgsevero@gmail.com
 */

package jnpad.text;

import javax.swing.text.Position;

/**
 * The Class DocumentRange.
 *
 * @version 0.3
 * @since   jNPad v0.1
 */
public class DocumentRange implements Comparable<DocumentRange> {
  Position start;
  Position end;
  boolean  first;

  /**
   * Instantiates a new document range.
   */
  DocumentRange() {
    //empty
  }

  /**
   * Instantiates a new document range.
   *
   * @param start Position
   * @param end Position
   * @param first boolean
   */
  public DocumentRange(Position start, Position end, boolean first) {
    this.start = start;
    this.end   = end;
    this.first = first;
  }

  /**
   * Compare to.
   *
   * @param other DocumentRange
   * @return int
   * @see java.lang.Comparable#compareTo(java.lang.Object)
   */
  @Override
  public int compareTo(DocumentRange other) {
    if (other == null) {
      return 1;
    }
    int diff = getStartOffset() - other.getStartOffset();
    if (diff != 0) {
      return diff;
    }
    return getEndOffset() - other.getEndOffset();
  }

  /**
   * Equals.
   *
   * @param other the other
   * @return true, if successful
   * @see java.lang.Object#equals(java.lang.Object)
   */
  @Override
  public boolean equals(Object other) {
    return other == this || other instanceof DocumentRange && compareTo((DocumentRange) other) == 0;
  }

  /**
   * Hash code.
   *
   * @return the int
   * @see java.lang.Object#hashCode()
   */
  @Override
  public int hashCode() {
    return getStartOffset() + getEndOffset();
  }

  /**
   * Gets the end offset.
   *
   * @return the end offset
   */
  public int getEndOffset() {
    return end.getOffset();
  }

  /**
   * Gets the start offset.
   *
   * @return the start offset
   */
  public int getStartOffset() {
    return first ? start.getOffset() - 1 : start.getOffset();
  }

  /**
   * To string.
   *
   * @return the string
   * @see java.lang.Object#toString()
   */
  @Override
  public String toString() {
    return "[DocumentRange: " + start.getOffset() + "-" + end.getOffset() + "]"; //$NON-NLS-1$//$NON-NLS-2$ //$NON-NLS-3$
  }
}
