/*
 * jNPad v0.3 - jNPad's an Simple Text Editor written in Java
 *
 * Copyright (C) 2014-2017  rgs
 *
 * Require JDK 1.6 (or later)
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 *
 *
 * Info, Questions, Suggestions & Bugs Report to rgsevero@gmail.com
 */

package jnpad.search;

import jnpad.config.Config;
import jnpad.util.Utilities;

/**
 * The Class SearchContext.
 *
 * @version 0.3
 * @since   jNPad v0.1
 */
public class SearchContext {
  /** The search for. */
  private String  searchFor;
  
  /** The replace with. */
  private String  replaceWith;
  
  /** The forward. */
  private boolean forward      = Config.FIND_DIRECTION_DOWN.getValue();
  
  /** The match case. */
  private boolean matchCase    = Config.FIND_MATCH_CASE.getValue();
  
  /** The whole word. */
  private boolean wholeWord    = Config.FIND_MATCH_WHOLEWORD.getValue();
  
  /** The highlight all. */
  private boolean highlightAll = Config.FIND_HIGHLIGHT_ALL.getValue();
  
  /** The regex. */
  private boolean regex        = Config.FIND_REGEX.getValue();

  /**
   * Instantiates a new search context.
   */
  public SearchContext() {
    this(null, null);
  }

  /**
   * Instantiates a new search context.
   *
   * @param searchFor the search for
   */
  public SearchContext(String searchFor) {
    this(searchFor, null);
  }

  /**
   * Instantiates a new search context.
   *
   * @param searchFor the search for
   * @param replaceWith the replace with
   */
  public SearchContext(String searchFor, String replaceWith) {
    this.searchFor = searchFor;
    this.replaceWith = replaceWith;
  }

  /**
   * Equals2.
   *
   * @param obj the obj
   * @return true, if successful
   */
  public boolean equals2(Object obj) {
    if (highlightAll && obj instanceof SearchContext) {
      return Utilities.equals(searchFor, ((SearchContext) obj).searchFor) &&
          Utilities.equals(replaceWith, ((SearchContext) obj).replaceWith) &&
          matchCase == ((SearchContext) obj).matchCase &&
          wholeWord == ((SearchContext) obj).wholeWord &&
          highlightAll == ((SearchContext) obj).highlightAll &&
          regex == ((SearchContext) obj).regex;
    }
    return equals(obj);
  }

  /**
   * Equals.
   *
   * @param obj the obj
   * @return true, if successful
   * @see java.lang.Object#equals(java.lang.Object)
   */
  @Override
  public boolean equals(Object obj) {
    return this == obj || obj != null && (obj instanceof SearchContext) && Utilities.equals(searchFor, ((SearchContext) obj).searchFor)
        && Utilities.equals(replaceWith, ((SearchContext) obj).replaceWith) && forward == ((SearchContext) obj).forward
        && matchCase == ((SearchContext) obj).matchCase && wholeWord == ((SearchContext) obj).wholeWord
        && highlightAll == ((SearchContext) obj).highlightAll && regex == ((SearchContext) obj).regex;
  }

  /**
   * Hash code.
   *
   * @return the int
   * @see java.lang.Object#hashCode()
   */
  @Override
  public int hashCode() {
    return Utilities.hashCode(searchFor,
                              replaceWith,
                              forward,
                              matchCase,
                              wholeWord,
                              highlightAll,
                              regex);
  }

  /**
   * Gets the search for.
   *
   * @return the search for
   */
  public String getSearchFor() {
    return searchFor;
  }

  /**
   * Sets the search for.
   *
   * @param searchFor the new search for
   */
  public void setSearchFor(String searchFor) {
    this.searchFor = searchFor;
  }

  /**
   * Gets the replace with.
   *
   * @return the replace with
   */
  public String getReplaceWith() {
    return replaceWith;
  }

  /**
   * Sets the replace with.
   *
   * @param replaceWith the new replace with
   */
  public void setReplaceWith(String replaceWith) {
    this.replaceWith = replaceWith;
  }

  /**
   * Gets the search forward.
   *
   * @return the search forward
   */
  public boolean getSearchForward() {
    return forward;
  }

  /**
   * Sets the search forward.
   *
   * @param b the new search forward
   */
  public void setSearchForward(boolean b) {
    forward = b;
  }

  /**
   * Gets the whole word.
   *
   * @return the whole word
   */
  public boolean getWholeWord() {
    return wholeWord;
  }

  /**
   * Sets the whole word.
   *
   * @param b the new whole word
   */
  public void setWholeWord(boolean b) {
    wholeWord = b;
  }

  /**
   * Gets the match case.
   *
   * @return the match case
   */
  public boolean getMatchCase() {
    return matchCase;
  }

  /**
   * Sets the match case.
   *
   * @param b the new match case
   */
  public void setMatchCase(boolean b) {
    matchCase = b;
  }

  /**
   * Gets the highlight all.
   *
   * @return the highlight all
   */
  public boolean getHighlightAll() {
    return highlightAll;
  }

  /**
   * Sets the highlight all.
   *
   * @param b the new highlight all
   */
  public void setHighlightAll(boolean b) {
    highlightAll = b;
  }

  /**
   * Checks if is regular expression.
   *
   * @return true, if is regular expression
   */
  public boolean isRegularExpression() {
    return regex;
  }

  /**
   * Sets the regular expression.
   *
   * @param b the new regular expression
   */
  public void setRegularExpression(boolean b) {
    regex = b;
  }

  /**
   * To string.
   *
   * @return the string
   * @see java.lang.Object#toString()
   */
  @Override
  public String toString() {
    return "[SearchContext: " +                         //$NON-NLS-1$
           "searchFor='" + getSearchFor() + "'" +       //$NON-NLS-1$ //$NON-NLS-2$
           ", replaceWith='" + getReplaceWith() + "'" + //$NON-NLS-1$ //$NON-NLS-2$
           ", matchCase=" + getMatchCase() +            //$NON-NLS-1$
           ", wholeWord=" + getWholeWord() +            //$NON-NLS-1$
           ", highlightAll=" + getHighlightAll() +      //$NON-NLS-1$
           ", regex=" + isRegularExpression() +         //$NON-NLS-1$
           "]";                                         //$NON-NLS-1$
  }

}
