/*
 * jNPad v0.3 - jNPad's an Simple Text Editor written in Java
 *
 * Copyright (C) 2014-2017  rgs
 *
 * Require JDK 1.6 (or later)
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 *
 *
 * Info, Questions, Suggestions & Bugs Report to rgsevero@gmail.com
 */

package jnpad.filebrowser;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.Locale;
import java.util.ResourceBundle;

import jnpad.JNPadBundle;
import jnpad.config.Config;

/**
 * The Class FileBrowserBundle.
 *
 * @version 0.3
 * @since   jNPad v0.1
 */
public final class FileBrowserBundle {
  /** The Constant BUNDLE_NAME. */
  private static final String              BUNDLE_NAME = "jnpad.i18n.FileBrowserBundle"; //$NON-NLS-1$

  /** The bundle. */
  private static Reference<ResourceBundle> ourBundle;

  /** no instances */
  private FileBrowserBundle() {
    super();
  }

  /**
   *
   * @param key String
   * @param params Object[]
   * @return String
   */
  public static String getString(final String key, final Object... params) {
    return JNPadBundle.getString(getBundle(), key, params);
  }

  /**
   *
   * @param key String
   * @param defaultValue String
   * @param params Object[]
   * @return String
   */
  public static String getMessage(final String key, final String defaultValue, final Object... params) {
    return JNPadBundle.getMessage(getBundle(), key, defaultValue, params);
  }

  /**
   *
   * @return ResourceBundle
   */
  private static ResourceBundle getBundle() {
    ResourceBundle bundle = null;
    if (ourBundle != null) {
      bundle = ourBundle.get();
    }
    if (bundle == null) {
      Locale locale = Config.getLocale();
      bundle = (locale != null) ?
          ResourceBundle.getBundle(BUNDLE_NAME, locale) :
          ResourceBundle.getBundle(BUNDLE_NAME);
      ourBundle = new SoftReference<ResourceBundle>(bundle);
    }
    return bundle;
  }

}
