/*
 * jNPad v0.3 - jNPad's an Simple Text Editor written in Java
 *
 * Copyright (C) 2014-2017  rgs
 *
 * Require JDK 1.6 (or later)
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 *
 *
 * Info, Questions, Suggestions & Bugs Report to rgsevero@gmail.com
 */

package jnpad.config;

/**
 * The Class ModeProp.
 *
 * @version 0.3
 * @since   jNPad v0.1
 */
public class ModeProp extends Prop<Mode> {
  /** UID */
  private static final long serialVersionUID = 7174673534863216808L;

  /**
   * Instantiates a new mode prop.
   *
   * @param name the name
   * @param def the def
   */
  public ModeProp(String name, Mode def) {
    super(name, def);
  }

  /**
   * Gets the default string.
   *
   * @return the default string
   * @see jnpad.config.Prop#getDefaultString()
   */
  @Override
  public String getDefaultString() {
    return format(defaultValue);
  }

  /**
   * Parses the.
   *
   * @param value the value
   * @return the mode
   * @throws NumberFormatException the number format exception
   */
  public static Mode parse(String value) throws NumberFormatException {
    switch(IntProp.parse(value)) {
      case 0 : return Mode.DEFAULT;
      case 1 : return Mode.MINIMALIST;
      case 2 : return Mode.BASIC;
      case 3 : return Mode.DISTRACTION_FREE;
      default: return null;
    }
  }
  
  /**
   * Format.
   *
   * @param value the value
   * @return the string
   */
  public static String format(Mode value) {
    return IntProp.format(value.ordinal());
  }

  /**
   * Gets the value.
   *
   * @return the value
   * @see jnpad.config.Prop#getValue()
   */
  @Override
  public Mode getValue() {
    return Config.getModeProp(this);
  }

  /**
   * Do set value.
   *
   * @param value the value
   * @see jnpad.config.Prop#doSetValue(java.lang.Object)
   */
  @Override
  protected void doSetValue(Mode value) {
    Config.setModeProp(this, value);
  }

}
