/*
 * jNPad v0.3 - jNPad's an Simple Text Editor written in Java
 *
 * Copyright (C) 2014-2017  rgs
 *
 * Require JDK 1.6 (or later)
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 *
 *
 * Info, Questions, Suggestions & Bugs Report to rgsevero@gmail.com
 */

package jnpad.action;

import static jnpad.action.JNPadActions.ACTION_NAME_REMOVE_EMPTY_LINES;

import java.util.logging.Level;
import java.util.logging.Logger;

import jnpad.JNPadFrame;
import jnpad.action.JNPadActions.Group;
import jnpad.config.Accelerators;
import jnpad.text.JNPadTextArea;
import jnpad.text.Buffer;
import jnpad.text.IEditAction;
import jnpad.ui.status.StatusDisplayable.StatusType;
import jnpad.util.Utilities;

/**
 * The Class RemoveEmptyLinesAction.
 *
 * @version 0.3
 * @since jNPad 0.1
 */
public final class RemoveEmptyLinesAction extends JNPadAction implements IEditAction {
  /** Logger */
  private static final Logger LOGGER           = Logger.getLogger(RemoveEmptyLinesAction.class.getName());

  /** UID */
  private static final long   serialVersionUID = -6430269063436442536L;

  /**
   * Instantiates a new removes the empty lines action.
   *
   * @param jNPad the jNPad's frame
   */
  public RemoveEmptyLinesAction(JNPadFrame jNPad) {
    super(jNPad,
          ACTION_NAME_REMOVE_EMPTY_LINES,
          Group.EDIT,
          Accelerators.REMOVE_EMPTY_LINES, null);
  }

  /**
   * Perform action.
   *
   * @see jnpad.action.JNPadAction#performAction()
   */
  @Override
  public void performAction() {
    Buffer buffer = jNPad.getActiveBuffer();
    if (buffer != null) {
      try {
        buffer.beginCompoundEdit();

        JNPadTextArea textArea = buffer.getSelectedTextArea();
        if (textArea.hasSelection()) {
          textArea.replaceSelection(removeEmptyLines(textArea.getSelectedText()));
        }
        else {
          textArea.setText(removeEmptyLines(textArea.getText()));
        }
      }
      catch (Exception ex) {
        LOGGER.log(Level.WARNING, ex.getMessage(), ex);
        jNPad.setStatus(StatusType.ERROR, "Error - ".concat(getLabel())); //$NON-NLS-1$
      }
      finally {
        buffer.endCompoundEdit();
      }
    }
  }

  /**
   * 
   * @param s String
   * @return String
   */
  private String removeEmptyLines(String s) {
    s = s.replaceAll("(?m)^[ \t]*\r?\n", Utilities.EMPTY_STRING); //$NON-NLS-1$
    s = Utilities.removeNewLine(s);
    return s;
  }
}
