/*
 * jNPad v0.3 - jNPad's an Simple Text Editor written in Java
 *
 * Copyright (C) 2014-2017  rgs
 *
 * Require JDK 1.6 (or later)
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 *
 *
 * Info, Questions, Suggestions & Bugs Report to rgsevero@gmail.com
 */

package jnpad.action;

import static jnpad.action.JNPadActions.ACTION_NAME_MARK_STRIP;

import java.awt.event.ItemEvent;

import jnpad.JNPadFrame;
import jnpad.action.JNPadActions.Group;
import jnpad.config.Accelerators;
import jnpad.config.Config;
import jnpad.config.ViewActionScope;
import jnpad.text.Viewer;

/**
 * The Class MarkStripAction.
 *
 * @version 0.3
 * @since   jNPad v0.1
 */
public final class MarkStripAction extends JNPadAction {
  /** UID */
  private static final long serialVersionUID = 6573490740354622093L;

  /**
   * Instantiates a new mark strip action.
   *
   * @param jNPad the jNPad's frame
   */
  public MarkStripAction(JNPadFrame jNPad) {
    super(jNPad,
          ACTION_NAME_MARK_STRIP,
          Group.VIEW,
          Accelerators.MARK_STRIP, "mark-strip.png"); //$NON-NLS-1$

    setSelected(Config.MARKER_VISIBLE.getValue());
    setStateAction(true);
  }

  /**
   * Handle state changed.
   * 
   * @param e the ItemEvent
   * @see jnpad.action.JNPadAction#handleStateChanged(java.awt.event.ItemEvent)
   */
  @Override
  public void handleStateChanged(final ItemEvent e) {
    final ViewActionScope scope = Config.VIEW_ACTION_SCOPE.getValue();

    Viewer viewer = jNPad.getViewer();

    switch (scope) {
      case VIEWER:
        viewer.setMarkStripVisible(ItemEvent.SELECTED == e.getStateChange());
        break;
      case BUFFER_SET:
        viewer.getActiveBufferSet().setMarkStripVisible(ItemEvent.SELECTED == e.getStateChange());
        break;
      case EDIT_PANE:
        viewer.getActiveEditPane().setMarkStripVisible(ItemEvent.SELECTED == e.getStateChange());
        break;
      case BUFFER:
      default:
        viewer.getActiveBuffer().setMarkStripVisible(ItemEvent.SELECTED == e.getStateChange());
        break;
    }
  }

}
