/*
 * jNPad v0.3 - jNPad's an Simple Text Editor written in Java
 *
 * Copyright (C) 2014-2017  rgs
 *
 * Require JDK 1.6 (or later)
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 *
 *
 * Info, Questions, Suggestions & Bugs Report to rgsevero@gmail.com
 */

package jnpad.action;

import static jnpad.action.JNPadActions.ACTION_NAME_INSERT_FILE_FULL_NAME;

import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;

import javax.swing.text.Document;
import javax.swing.text.JTextComponent;

import jnpad.JNPadFrame;
import jnpad.action.JNPadActions.Group;
import jnpad.config.Accelerators;
import jnpad.text.EditPane;
import jnpad.text.IEditAction;

/**
 * The Class InsertFileFullNameAction.
 *
 * @version 0.3
 * @since   jNPad v0.1
 */
public final class InsertFileFullNameAction extends JNPadAction implements IEditAction {
  /** Logger */
  private static final Logger LOGGER           = Logger.getLogger(InsertFileFullNameAction.class.getName());

  /** UID */
  private static final long   serialVersionUID = -4651213839679323573L;

  /**
   * Instantiates a new insert file full name action.
   *
   * @param jNPad the jNPad's frame
   */
  public InsertFileFullNameAction(JNPadFrame jNPad) {
    super(jNPad,
          ACTION_NAME_INSERT_FILE_FULL_NAME,
          Group.EDIT,
          Accelerators.INSERT_FILE_FULL_NAME, null);
  }

  /**
   * Perform action.
   *
   * @see jnpad.action.JNPadAction#performAction()
   */
  @Override
  public void performAction() {
    EditPane editPane = jNPad.getActiveEditPane();

    if (editPane != null) {
      File file = new File(editPane.getFilePath());
      if (!file.exists()) {
        return;
      }

      try {
        String fullName = file.getName();
        JTextComponent target = editPane.getTextArea();
        Document doc = target.getDocument();
        int caretPosition = target.getCaretPosition();
        doc.insertString(caretPosition, fullName, null);
      }
      catch (Exception ex) {
        LOGGER.log(Level.WARNING, ex.getMessage(), ex);
      }
    }
  }

}
