/*
 * jNPad v0.3 - jNPad's an Simple Text Editor written in Java
 *
 * Copyright (C) 2014-2017  rgs
 *
 * Require JDK 1.6 (or later)
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 *
 *
 * Info, Questions, Suggestions & Bugs Report to rgsevero@gmail.com
 */

package jnpad.action;

import static jnpad.action.JNPadActions.ACTION_NAME_GO_TO_LINE;

import javax.swing.JOptionPane;

import jnpad.JNPadFrame;
import jnpad.action.JNPadActions.Group;
import jnpad.config.Accelerators;
import jnpad.text.EditPane;
import jnpad.text.JNPadTextArea;
import jnpad.text.TextUtilities;
import jnpad.util.Utilities;

/**
 * The Class GoToLineAction.
 *
 * @version 0.3
 * @since   jNPad v0.1
 */
public final class GoToLineAction extends JNPadAction {
  /** UID */
  private static final long serialVersionUID = -2107743998850078847L;

  /**
   * Instantiates a new go to line action.
   *
   * @param jNPad the jNPad's frame
   */
  public GoToLineAction(JNPadFrame jNPad) {
    super(jNPad,
          ACTION_NAME_GO_TO_LINE,
          Group.SEARCH,
          Accelerators.GO_TO_LINE, "go-to-line.png"); //$NON-NLS-1$
  }

  /**
   * Perform action.
   *
   * @see jnpad.action.JNPadAction#performAction()
   */
  @Override
  public void performAction() {
    EditPane editPane = jNPad.getActiveEditPane();
    if (editPane != null) {
      JNPadTextArea textArea = editPane.getTextArea();

      int nro_of_lines = textArea.getLineCount();

      if (nro_of_lines < 1) {
        return;
      }

      String response = JOptionPane.showInputDialog(editPane,
                                                    ActionBundle.getString(ACTION_NAME_GO_TO_LINE.concat(".message"), nro_of_lines), //$NON-NLS-1$
                                                    ActionBundle.getString(ACTION_NAME_GO_TO_LINE.concat(".title")), //$NON-NLS-1$
                                                    JOptionPane.QUESTION_MESSAGE);

      if (Utilities.isBlankString(response)) {
        return;
      }

      try {
        int line, column = 0;

        int index = response.indexOf(':');
        if (index != -1) {
          line = Integer.parseInt(response.substring(0, index).trim());
          column = Integer.parseInt(response.substring(index + 1).trim());
        }
        else {
          line = Integer.parseInt(response.trim());
        }

        if (line < 1) {
          line = 1;
        }
        else if (line > nro_of_lines) {
          line = nro_of_lines;
        }

        int pos = TextUtilities.getDocPositionFor(textArea.getDocument(), line, column);

        textArea.jumpToOffset(pos);
      }
      catch (Exception ex) {
        JOptionPane.showConfirmDialog(editPane,
                                      ActionBundle.getString(ACTION_NAME_GO_TO_LINE.concat(".error.message"), response), //$NON-NLS-1$
                                      ActionBundle.getString(ACTION_NAME_GO_TO_LINE.concat(".error.title")), //$NON-NLS-1$
                                      JOptionPane.DEFAULT_OPTION,
                                      JOptionPane.ERROR_MESSAGE);
      }

    }
  }

}
