#!/bin/sh

# Clean:
# 1) remove logs
# 2) remove props/jnpad.properties
# 3) remove props/jnpad.defaults.properties
# 4) remove props/search.properties

function removeDir {
	if [ -d $1 ]; then
		rm -rf $1
	fi 
}

function removeFile {
	if [ -x $1 ]; then
		rm -f $1
	fi 
}

echo 
echo -ne " ==         20% -> remove logs...                            \r"
removeDir logs

echo -ne " ====       40% -> remove props/jnpad.properties...          \r"
removeFile props/jnpad.properties

echo -ne " ======     60% -> remove props/jnpad.defaults.properties... \r"
removeFile props/jnpad.defaults.properties

echo -ne " ========   80% -> remove props/search.properties...         \r"
removeFile props/search.properties

echo -ne " ========== 100% -> Task finished                            \r"
echo -ne '\n'
