/*
 * Decompiled with CFR 0.152.
 */
package jnpad.ui.toolbar;

import java.awt.Insets;
import java.awt.event.MouseEvent;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JToggleButton;
import jnpad.GUIUtilities;
import jnpad.action.JNPadAction;
import jnpad.config.Config;
import jnpad.ui.plaf.LAFUtils;
import jnpad.ui.status.StatusDisplayable;

public class ToolBarToggleButton
extends JToggleButton {
    private String _description;
    private boolean _descriptionSet;
    private StatusDisplayable _displayable;
    private static final long serialVersionUID = -3837240388108543023L;

    public ToolBarToggleButton() {
        this(null, null, false);
    }

    public ToolBarToggleButton(Icon icon) {
        this(null, icon, false);
    }

    public ToolBarToggleButton(Icon icon, boolean selected) {
        this(null, icon, selected);
    }

    public ToolBarToggleButton(String text) {
        this(text, null, false);
    }

    public ToolBarToggleButton(String text, boolean selected) {
        this(text, null, selected);
    }

    public ToolBarToggleButton(Action a) {
        this();
        this.setAction(a);
    }

    public ToolBarToggleButton(String text, Icon icon) {
        this(text, icon, false);
    }

    public ToolBarToggleButton(String text, Icon icon, boolean selected) {
        super(text, icon, selected);
        this.setRequestFocusEnabled(false);
        this.setMargin(LAFUtils.isNimbusLAF() ? new Insets(1, 1, 1, 1) : new Insets(2, 2, 2, 2));
    }

    @Override
    public void setAction(Action a) {
        if (a instanceof JNPadAction) {
            if (!Config.isBasicMode()) {
                this.setHideActionText(true);
            }
            super.setAction(a);
            this.setDescription(((JNPadAction)a).getDescription());
            this.setToolTipText(((JNPadAction)a).getButtonToolTipText());
            this.setMnemonic('\u0000');
            if (Config.isBasicMode()) {
                this.setHorizontalTextPosition(0);
                this.setVerticalTextPosition(3);
                this.setText(((JNPadAction)a).getButtonText());
            }
            this.addItemListener((JNPadAction)a);
        } else {
            super.setAction(a);
        }
    }

    public void setDescription(String description) {
        this._description = description;
    }

    public String getDescription() {
        return this._description;
    }

    public void setStatusDisplayable(StatusDisplayable displayable) {
        this._displayable = displayable;
    }

    public StatusDisplayable getStatusDisplayable() {
        return this._displayable;
    }

    private StatusDisplayable getStatusDisplayable(MouseEvent e) {
        if (this._displayable == null) {
            this._displayable = GUIUtilities.getJNPadFrame(e);
        }
        return this._displayable;
    }

    @Override
    protected void processMouseEvent(MouseEvent e) {
        if (this._description != null) {
            switch (e.getID()) {
                case 504: {
                    this.getStatusDisplayable(e).setStatus(this._description);
                    this._descriptionSet = true;
                    break;
                }
                case 502: 
                case 505: {
                    if (!this._descriptionSet) break;
                    this.getStatusDisplayable(e).clearStatus();
                    this._descriptionSet = false;
                    break;
                }
            }
        }
        super.processMouseEvent(e);
    }
}

