/*
 * Decompiled with CFR 0.152.
 */
package jnpad.ui.toolbar;

import java.awt.Color;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import jnpad.JNPadBundle;
import jnpad.ui.plaf.LAFUtils;
import jnpad.ui.toolbar.DropDownIcon;
import jnpad.ui.toolbar.PopupToolBox;
import jnpad.ui.toolbar.ToolBarButton;
import jnpad.ui.toolbar.ToolBoxButton;
import jnpad.util.Utilities;

public class PopupToolBoxButton
extends ToolBarButton {
    private PopupToolBox _popupToolBox;
    private Icon _standardIcon;
    private Icon _realIcon;
    private JButton _button;
    private String _tooltip;
    private boolean _showSplitter;
    private String _dropDownToolTip;
    private boolean _popupMenuIsShowing;
    private boolean _innerActionEnabled;
    private ActionListener _actionListener;
    private Action _action;
    private PropertyChangeListener _actionPropertyChangeListener;
    private static final Logger LOGGER = Logger.getLogger(PopupToolBoxButton.class.getName());
    private static final long serialVersionUID = -577818802286323894L;

    public PopupToolBoxButton() {
        this(0, 1, true);
    }

    public PopupToolBoxButton(int rows, int cols) {
        this(rows, cols, true);
    }

    public PopupToolBoxButton(int rows, int cols, boolean rollover) {
        this._popupToolBox = new PopupToolBox(rows, cols, rollover);
        MouseHandler mouseHandler = new MouseHandler();
        this.addMouseMotionListener(mouseHandler);
        this.addMouseListener(mouseHandler);
        this._actionListener = new ActionListenerImpl();
        super.addActionListener(this._actionListener);
    }

    @Override
    public void addActionListener(ActionListener l) {
        super.addActionListener(l);
        this._innerActionEnabled = true;
    }

    public JButton add(JButton button) {
        JButton toolbutton = (JButton)this._popupToolBox.add(button);
        toolbutton.addActionListener(this._actionListener);
        return toolbutton;
    }

    public void setDefault(JButton button) {
        Icon icon;
        this._button = button;
        this._tooltip = this._button.getToolTipText();
        if (Utilities.isEmptyString(this._tooltip)) {
            this._tooltip = this._button.getText();
        }
        this.setToolTipText(this._tooltip);
        String text = button.getText();
        if (text != null) {
            this.setText(text);
        }
        if ((icon = button.getIcon()) != null) {
            this.setIcon(button.getIcon());
        }
        this.setEnabled(button.isEnabled());
        this.setMargin(button.getMargin());
        if (this._action != null && this._actionPropertyChangeListener != null) {
            this._action.removePropertyChangeListener(this._actionPropertyChangeListener);
            this._actionPropertyChangeListener = null;
        }
        this._action = button.getAction();
        if (this._action == null && button instanceof ToolBoxButton) {
            this._action = ((ToolBoxButton)button)._action;
        }
        if (this._action != null) {
            this._actionPropertyChangeListener = new PropertyChangeListenerImpl();
            this._action.addPropertyChangeListener(this._actionPropertyChangeListener);
        }
    }

    public JButton getDefault() {
        return this._button;
    }

    @Override
    public final void setIcon(Icon icon) {
        this._realIcon = icon;
        if (icon != null && icon instanceof ImageIcon) {
            this._standardIcon = new DropDownIcon((ImageIcon)icon);
            super.setIcon(this._standardIcon);
        } else {
            super.setIcon(icon);
        }
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        try {
            if (this._showSplitter) {
                boolean b = super.isEnabled();
                this.showSplitter(b ? LAFUtils.getControlDkShadow() : LAFUtils.getToolBarShadow(), g, this.getSplitterPosn(), 1, this.getHeight() - 4);
                this.showSplitter(b ? LAFUtils.getControlHighlight() : LAFUtils.getToolBarHighlight(), g, this.getSplitterPosn() + 1, 1, this.getHeight() - 4);
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, ex.getMessage(), ex);
        }
    }

    private int getSplitterPosn() {
        return this.getIconPosn() + this._realIcon.getIconWidth() + 3;
    }

    private int getIconPosn() {
        return (this.getWidth() - this._standardIcon.getIconWidth()) / 2;
    }

    public void setDropDownToolTip(String dropDownToolTip) {
        this._dropDownToolTip = dropDownToolTip;
    }

    private void showSplitter(Color c, Graphics g, int x, int y, int height) {
        g.setColor(c);
        g.drawLine(x, y, x, y + height);
    }

    private void showSplitter(boolean show) {
        if (show && !this._showSplitter) {
            this._showSplitter = true;
            this.repaint();
            String tooltip = null;
            Container parent = this.getParent();
            if (parent instanceof JComponent) {
                tooltip = this._dropDownToolTip;
            }
            if (tooltip == null) {
                tooltip = JNPadBundle.getString("PopupButton.select", new Object[0]);
            }
            this.setToolTipText(tooltip);
        } else if (!show && this._showSplitter) {
            this._showSplitter = false;
            this.repaint();
            this.setToolTipText(this._tooltip);
        }
    }

    private void popup() {
        final JPopupMenu popupMenu = new JPopupMenu();
        PopupMenuListenerImpl pml = new PopupMenuListenerImpl();
        popupMenu.addPopupMenuListener(pml);
        MouseAdapter m = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                PopupToolBoxButton.this._popupMenuIsShowing = false;
                popupMenu.setVisible(false);
            }
        };
        this._popupToolBox.setButtonMouseListener(m);
        this._popupToolBox.rebuild();
        popupMenu.add(this._popupToolBox);
        SwingUtilities.updateComponentTreeUI(popupMenu);
        popupMenu.show(this, 0, this.getHeight());
        this._popupMenuIsShowing = true;
    }

    @Override
    public void updateUI() {
        super.updateUI();
        try {
            SwingUtilities.updateComponentTreeUI(this._popupToolBox);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    protected void fireActionPerformed(ActionEvent event) {
        if (this._showSplitter) {
            if (!this._popupMenuIsShowing) {
                this.popup();
            }
        } else {
            super.fireActionPerformed(event);
        }
    }

    private class ActionListenerImpl
    implements ActionListener,
    Serializable {
        private static final long serialVersionUID = -8814455331658962299L;

        private ActionListenerImpl() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object obj = e.getSource();
            if (!PopupToolBoxButton.this._innerActionEnabled) {
                if (obj == PopupToolBoxButton.this) {
                    if (PopupToolBoxButton.this._button != null && PopupToolBoxButton.this._button != obj) {
                        ActionListener[] listeners;
                        ActionListener[] actionListenerArray = listeners = PopupToolBoxButton.this._button.getActionListeners();
                        int n = listeners.length;
                        int n2 = 0;
                        while (n2 < n) {
                            ActionListener listener = actionListenerArray[n2];
                            listener.actionPerformed(new ActionEvent(PopupToolBoxButton.this._button, e.getID(), e.getActionCommand(), e.getWhen(), e.getModifiers()));
                            ++n2;
                        }
                    }
                } else if (obj instanceof JButton) {
                    PopupToolBoxButton.this.setDefault((JButton)obj);
                }
            }
        }
    }

    private class MouseHandler
    extends MouseInputAdapter {
        private MouseHandler() {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (PopupToolBoxButton.this._standardIcon != null) {
                PopupToolBoxButton.this.showSplitter(e.getX() >= PopupToolBoxButton.this.getSplitterPosn());
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            if (PopupToolBoxButton.this._standardIcon != null) {
                PopupToolBoxButton.this.showSplitter(e.getX() >= PopupToolBoxButton.this.getSplitterPosn());
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            if (PopupToolBoxButton.this._standardIcon != null) {
                PopupToolBoxButton.this.showSplitter(false);
            }
        }
    }

    private class PopupMenuListenerImpl
    implements PopupMenuListener {
        private PopupMenuListenerImpl() {
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent e) {
            PopupToolBoxButton.this._popupMenuIsShowing = false;
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        }
    }

    private class PropertyChangeListenerImpl
    implements PropertyChangeListener,
    Serializable {
        private static final long serialVersionUID = -276468994510092616L;

        private PropertyChangeListenerImpl() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if ("enabled".equals(e.getPropertyName())) {
                PopupToolBoxButton.this.setEnabled((Boolean)e.getNewValue());
            }
        }
    }
}

