/*
 * Decompiled with CFR 0.152.
 */
package jnpad.ui.toolbar;

import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JPopupMenu;
import jnpad.ui.icon.ArrowIcon;
import jnpad.ui.toolbar.JNPadToolBar;
import jnpad.ui.toolbar.PopupToolBox;
import jnpad.ui.toolbar.ToolBarButton;

class NavigationButton
extends ToolBarButton {
    private JNPadToolBar _toolBar;
    private static Icon iiVertical = new ArrowIcon(5);
    private static Icon iiHorizontal = new ArrowIcon(3);
    private static final long serialVersionUID = 2934778029232424274L;

    public NavigationButton(JNPadToolBar toolbar) {
        this._toolBar = toolbar;
        this.setAction(new NavigationAction());
        this.setOrientation(toolbar.getOrientation());
    }

    void setOrientation(int orientation) {
        switch (orientation) {
            case 0: {
                this.setIcon(iiHorizontal);
                this.setMargin(new Insets(2, 0, 2, 0));
                break;
            }
            case 1: {
                this.setIcon(iiVertical);
                this.setMargin(new Insets(0, 2, 0, 2));
                break;
            }
        }
    }

    private void popup() {
        Component[] components = this._toolBar.getOverflowComponents();
        PopupToolBox popuptoolbox = new PopupToolBox(components.length, 1, this.isRolloverEnabled());
        Component[] componentArray = components;
        int n = components.length;
        int n2 = 0;
        while (n2 < n) {
            Component component = componentArray[n2];
            if (component instanceof AbstractButton) {
                AbstractButton button = (AbstractButton)component;
                popuptoolbox.add(button);
            }
            ++n2;
        }
        final JPopupMenu popup = new JPopupMenu();
        MouseAdapter mouse_adapter = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                popup.setVisible(false);
            }
        };
        popuptoolbox.setButtonMouseListener(mouse_adapter);
        popuptoolbox.rebuild();
        popup.add(popuptoolbox);
        popup.show(this, 0, this.getHeight());
    }

    private class NavigationAction
    extends AbstractAction {
        private static final long serialVersionUID = -4171959259495145172L;

        NavigationAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            NavigationButton.this.popup();
        }
    }
}

