/*
 * Decompiled with CFR 0.152.
 */
package jnpad.ui.toolbar;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JToolBar;
import jnpad.ui.toolbar.NavigationButton;

public class JNPadToolBar
extends JToolBar {
    private NavigationButton _navigationButton = new NavigationButton(this);
    private List<Component> l_hiddenComponents;
    private static final long serialVersionUID = -7494045572706190958L;

    public JNPadToolBar() {
        this(0);
    }

    public JNPadToolBar(int orientation) {
        this(null, orientation);
    }

    public JNPadToolBar(String name) {
        this(name, 0);
    }

    public JNPadToolBar(String name, int orientation) {
        super(name, orientation);
        this.addComponentListener(new ResizeListener());
        this.addPropertyChangeListener("orientation", new OrientationListener());
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(0, 0);
    }

    @Override
    public void setOrientation(int orientation) {
        super.setOrientation(orientation);
        if (this._navigationButton != null) {
            this._navigationButton.setOrientation(orientation);
        }
    }

    @Override
    public void updateUI() {
        super.updateUI();
    }

    public JButton getNavigationButton() {
        return this._navigationButton;
    }

    @Override
    protected void addImpl(Component comp, Object constraints, int index) {
        if (comp instanceof NavigationButton) {
            this._navigationButton = (NavigationButton)comp;
        }
        super.addImpl(comp, constraints, index);
    }

    public Component[] getOverflowComponents() {
        return this.l_hiddenComponents.toArray(new Component[this.l_hiddenComponents.size()]);
    }

    private class OrientationListener
    implements PropertyChangeListener {
        private OrientationListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if (JNPadToolBar.this._navigationButton != null) {
                JNPadToolBar.this._navigationButton.setOrientation(JNPadToolBar.this.getOrientation());
            }
        }
    }

    private class ResizeListener
    extends ComponentAdapter {
        private ResizeListener() {
        }

        @Override
        public void componentResized(ComponentEvent e) {
            super.componentResized(e);
            if (JNPadToolBar.this.l_hiddenComponents != null) {
                JNPadToolBar.this.remove(JNPadToolBar.this._navigationButton);
                for (Component l_hiddenComponent : JNPadToolBar.this.l_hiddenComponents) {
                    JNPadToolBar.this.add(l_hiddenComponent);
                }
                JNPadToolBar.this.l_hiddenComponents = null;
            }
            boolean flag = false;
            switch (JNPadToolBar.this.getOrientation()) {
                case 1: {
                    Component c;
                    int height = JNPadToolBar.this.getHeight() - JNPadToolBar.this._navigationButton.getHeight();
                    JNPadToolBar.this._navigationButton.setLocation(JNPadToolBar.this._navigationButton.getWidth(), height);
                    int k = 0;
                    while (k < JNPadToolBar.this.getComponentCount() && !flag) {
                        c = JNPadToolBar.this.getComponent(k);
                        if (c != JNPadToolBar.this._navigationButton && c.getY() + c.getHeight() > JNPadToolBar.this.getHeight()) {
                            flag = true;
                        }
                        ++k;
                    }
                    if (!flag) break;
                    JNPadToolBar.this.l_hiddenComponents = new ArrayList();
                    int jj = 0;
                    while (jj < JNPadToolBar.this.getComponentCount()) {
                        c = JNPadToolBar.this.getComponent(jj);
                        if (c != JNPadToolBar.this._navigationButton && c.getY() + c.getHeight() > height) {
                            JNPadToolBar.this.l_hiddenComponents.add(c);
                            JNPadToolBar.this.remove(c);
                            continue;
                        }
                        ++jj;
                    }
                    JNPadToolBar.this.remove(JNPadToolBar.this._navigationButton);
                    JNPadToolBar.this.add(JNPadToolBar.this._navigationButton);
                    JNPadToolBar.this.validate();
                    break;
                }
                case 0: {
                    Component c;
                    int width = JNPadToolBar.this.getWidth() - JNPadToolBar.this._navigationButton.getWidth();
                    JNPadToolBar.this._navigationButton.setLocation(width, JNPadToolBar.this._navigationButton.getHeight());
                    int k = 0;
                    while (k < JNPadToolBar.this.getComponentCount() && !flag) {
                        c = JNPadToolBar.this.getComponent(k);
                        if (c != JNPadToolBar.this._navigationButton && c.getX() + c.getWidth() > JNPadToolBar.this.getWidth()) {
                            flag = true;
                        }
                        ++k;
                    }
                    if (!flag) break;
                    JNPadToolBar.this.l_hiddenComponents = new ArrayList();
                    int jj = 0;
                    while (jj < JNPadToolBar.this.getComponentCount()) {
                        c = JNPadToolBar.this.getComponent(jj);
                        if (c != JNPadToolBar.this._navigationButton && c.getX() + c.getWidth() > width) {
                            JNPadToolBar.this.l_hiddenComponents.add(c);
                            JNPadToolBar.this.remove(c);
                            continue;
                        }
                        ++jj;
                    }
                    JNPadToolBar.this.remove(JNPadToolBar.this._navigationButton);
                    JNPadToolBar.this.add(JNPadToolBar.this._navigationButton);
                    JNPadToolBar.this.validate();
                    break;
                }
            }
        }
    }
}

