/*
 * Decompiled with CFR 0.152.
 */
package jnpad.ui.table;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.TableModelListener;
import javax.swing.plaf.UIResource;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import jnpad.ui.ColorUtilities;
import jnpad.ui.plaf.LAFUtils;
import jnpad.util.Utilities;

public final class TableUtilities {
    private TableUtilities() {
    }

    public static void setColors(JComponent comp, JTable table, boolean isSelected, int row, boolean alternateRowColorEnabled, Color alternateRowColor) {
        if (isSelected && table.isEnabled()) {
            comp.setForeground(table.getSelectionForeground());
            comp.setBackground(table.getSelectionBackground());
        } else if (!table.isEnabled()) {
            comp.setForeground(LAFUtils.getTextFieldInactiveForeground());
            comp.setBackground(LAFUtils.getTextFieldInactiveBackground());
        } else {
            Color fg;
            Color bg;
            if (alternateRowColorEnabled && row % 2 == 0) {
                if (alternateRowColor != null) {
                    bg = alternateRowColor;
                    fg = ColorUtilities.computeForeground(bg);
                } else {
                    Color alternateColor = UIManager.getColor("Table.alternateRowColor");
                    if (alternateColor != null) {
                        bg = alternateColor;
                    } else {
                        bg = table.getBackground();
                        if (LAFUtils.isNimbusLAF() && bg instanceof UIResource) {
                            bg = ColorUtilities.createPureColor(bg);
                        }
                    }
                    fg = table.getForeground();
                }
            } else {
                bg = table.getBackground();
                if (LAFUtils.isNimbusLAF() && bg instanceof UIResource) {
                    bg = ColorUtilities.createPureColor(bg);
                }
                fg = table.getForeground();
            }
            comp.setForeground(fg);
            comp.setBackground(bg);
        }
    }

    public static void setBorder(JComponent comp, JTable table, boolean isSelected, boolean hasFocus, int row, int column, Border noFocusBorder) {
        if (hasFocus) {
            Border border = null;
            if (isSelected) {
                border = UIManager.getBorder("Table.focusSelectedCellHighlightBorder");
            }
            if (border == null) {
                border = LAFUtils.getTableFocusCellHighlightBorder();
            }
            comp.setBorder(border);
            if (!isSelected && table.isCellEditable(row, column)) {
                comp.setForeground(LAFUtils.getTableFocusCellForeground());
                comp.setBackground(LAFUtils.getTableFocusCellBackground());
            }
        } else {
            comp.setBorder(noFocusBorder);
        }
    }

    public static void setValue(JLabel label, Object value, boolean tooltipEnabled) {
        if (!tooltipEnabled) {
            label.setText(Utilities.toString(value));
            return;
        }
        if (value != null) {
            String s = value.toString();
            if (s.length() > 0) {
                label.setText(s);
                label.setToolTipText(s);
            } else {
                label.setText("");
                label.setToolTipText(null);
            }
        } else {
            label.setText("");
            label.setToolTipText(null);
        }
    }

    public static void packTableColumns(JTable table, int margin) {
        int c = 0;
        while (c < table.getColumnCount()) {
            TableUtilities.packTableColumn(table, c, margin);
            ++c;
        }
    }

    public static void packTableColumn(JTable table, int colIndex, int margin) {
        DefaultTableColumnModel colModel = (DefaultTableColumnModel)table.getColumnModel();
        TableColumn col = colModel.getColumn(colIndex);
        TableCellRenderer renderer = col.getHeaderRenderer();
        if (renderer == null) {
            renderer = table.getTableHeader().getDefaultRenderer();
        }
        Component comp = renderer.getTableCellRendererComponent(table, col.getHeaderValue(), false, false, 0, 0);
        int width = comp.getPreferredSize().width;
        int r = 0;
        while (r < table.getRowCount()) {
            renderer = table.getCellRenderer(r, colIndex);
            comp = renderer.getTableCellRendererComponent(table, table.getValueAt(r, colIndex), false, false, r, colIndex);
            width = Math.max(width, comp.getPreferredSize().width);
            ++r;
        }
        col.setPreferredWidth(width += 2 * margin);
    }

    public static void packTableRows(JTable table, int margin) {
        int r = 0;
        while (r < table.getRowCount()) {
            int h = TableUtilities.getTablePreferredRowHeight(table, r, margin);
            if (table.getRowHeight(r) != h) {
                table.setRowHeight(r, h);
            }
            ++r;
        }
    }

    public static int getTablePreferredRowHeight(JTable table, int rowIndex, int margin) {
        int height = table.getRowHeight();
        int c = 0;
        while (c < table.getColumnCount()) {
            TableCellRenderer renderer = table.getCellRenderer(rowIndex, c);
            Component comp = table.prepareRenderer(renderer, rowIndex, c);
            int h = comp.getPreferredSize().height + 2 * margin;
            height = Math.max(height, h);
            ++c;
        }
        return height;
    }

    public static void free(JTable table) {
        TableModel tm = table.getModel();
        if (tm != null) {
            table.setModel(new EmptyTableModel());
        }
    }

    static class EmptyTableModel
    implements TableModel {
        EmptyTableModel() {
        }

        @Override
        public int getRowCount() {
            return 0;
        }

        @Override
        public int getColumnCount() {
            return 0;
        }

        @Override
        public String getColumnName(int columnIndex) {
            return "";
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return String.class;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return "";
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        }

        @Override
        public void addTableModelListener(TableModelListener l) {
        }

        @Override
        public void removeTableModelListener(TableModelListener l) {
        }
    }
}

