/*
 * Decompiled with CFR 0.152.
 */
package jnpad.ui.table;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.ListSelectionModel;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import jnpad.ui.ColorUtilities;
import jnpad.ui.plaf.LAFUtils;
import jnpad.ui.table.DefaultRowHeader;
import jnpad.ui.table.JNPadDefaultTableModel;
import jnpad.ui.table.JNPadTableModel;
import jnpad.ui.table.LineHeaderTableCellRenderer;
import jnpad.ui.table.MultiLineHeaderTableCellRenderer;

public class JNPadTable
extends JTable {
    private int sortedColumnIndex = -1;
    private boolean isSortedColumnAscending = true;
    private boolean isSortingEnabled = true;
    private boolean isEditable = true;
    private boolean isRowHeaderEnabled = false;
    private DefaultRowHeader rowHeader;
    private int rowHeaderWidth = 20;
    private int rowHeaderSelected = -1;
    private static final long serialVersionUID = 1803896768020595693L;

    public JNPadTable() {
        this((TableModel)new JNPadDefaultTableModel(), false, 0);
    }

    public JNPadTable(int numRows, int numColumns) {
        this((TableModel)new JNPadDefaultTableModel(numRows, numColumns), false, 0);
    }

    public JNPadTable(Object[][] rowData, Object[] columnNames) {
        this((TableModel)new JNPadDefaultTableModel(rowData, columnNames), false, 0);
    }

    public JNPadTable(Vector<?> rowData, Vector<?> columnNames) {
        this((TableModel)new JNPadDefaultTableModel(rowData, columnNames), false, 0);
    }

    public JNPadTable(TableModel tm) {
        this(tm, false, 0);
    }

    public JNPadTable(TableModel tm, boolean multiLineHeader) {
        super(tm);
        if (multiLineHeader) {
            this.init(true, 1);
        } else {
            this.init(false, 0);
        }
    }

    public JNPadTable(TableModel tm, boolean multiLineHeader, int align) {
        super(tm);
        this.init(multiLineHeader, align);
    }

    public JNPadTable(TableModel tm, TableColumnModel tcm) {
        super(tm, tcm);
        this.init(false, 0);
    }

    public JNPadTable(TableModel tm, TableColumnModel tcm, ListSelectionModel lsm) {
        super(tm, tcm, lsm);
        this.init(false, 0);
    }

    private void init(boolean multiLineHeader, int align) {
        JComponent renderer = multiLineHeader ? new MultiLineHeaderTableCellRenderer(align) : new LineHeaderTableCellRenderer(align);
        this.tableHeader.setDefaultRenderer((TableCellRenderer)((Object)renderer));
        Enumeration<TableColumn> e = this.columnModel.getColumns();
        while (e.hasMoreElements()) {
            TableColumn tableColumn = e.nextElement();
            tableColumn.setHeaderRenderer((TableCellRenderer)((Object)renderer));
        }
        this.tableHeader.addMouseListener(new MouseHandler());
    }

    public void setSortingEnabled(boolean b) {
        this.isSortingEnabled = b;
    }

    public boolean isSortingEnabled() {
        return this.isSortingEnabled;
    }

    public int getSortedColumnIndex() {
        return this.sortedColumnIndex;
    }

    public void setSortedColumnIndex(int column) {
        this.sortedColumnIndex = column;
    }

    public boolean isSortedColumnAscending() {
        return this.isSortedColumnAscending;
    }

    public void setSortedColumnAscending(boolean b) {
        this.isSortedColumnAscending = b;
    }

    public void setEditable(boolean b) {
        this.isEditable = b;
    }

    public boolean isEditable() {
        return this.isEditable;
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return this.isEditable && super.isCellEditable(row, column);
    }

    public void setColumnPreferredWidth(int width) {
        int max = this.columnModel.getColumnCount();
        int i = 0;
        while (i < max) {
            TableColumn tableColumn = this.columnModel.getColumn(i);
            tableColumn.setPreferredWidth(width);
            ++i;
        }
    }

    public void setRowHeaderSelected(int row) {
        if (row != this.rowHeaderSelected) {
            this.rowHeaderSelected = row;
            if (this.rowHeader != null) {
                this.rowHeader.repaint();
            }
        }
    }

    public int getRowHeaderSelected() {
        return this.rowHeaderSelected;
    }

    public void setRowHeaderEnabled(boolean b) {
        if (b != this.isRowHeaderEnabled) {
            this.isRowHeaderEnabled = b;
            this.setRowHeaderView();
        }
    }

    public boolean getRowHeaderEnabled() {
        return this.isRowHeaderEnabled;
    }

    public Component getRowHeader() {
        if (!this.isRowHeaderEnabled) {
            return null;
        }
        if (this.rowHeader == null) {
            this.setRowHeaderView();
        }
        return this.rowHeader;
    }

    public void setRowHeaderWidth(int width) {
        this.rowHeaderWidth = width;
        if (this.rowHeader != null) {
            this.rowHeader.setFixedCellWidth(width);
        }
    }

    public int getRowHeaderWidth() {
        return this.rowHeaderWidth;
    }

    @Override
    public void setRowHeight(int rowHeight) {
        super.setRowHeight(rowHeight);
        if (this.rowHeader != null) {
            this.rowHeader.setFixedCellHeight(this.getRowHeight());
        }
    }

    @Override
    protected void configureEnclosingScrollPane() {
        super.configureEnclosingScrollPane();
        this.setRowHeaderView();
    }

    private void setRowHeaderView() {
        Container c1 = this.getParent();
        if (!(c1 instanceof JViewport)) {
            return;
        }
        Container c2 = c1.getParent();
        if (!(c2 instanceof JScrollPane)) {
            return;
        }
        JScrollPane scrollPane = (JScrollPane)c2;
        JViewport viewport = scrollPane.getViewport();
        if (viewport == null || viewport.getView() != this) {
            return;
        }
        if (this.isRowHeaderEnabled) {
            if (this.rowHeader == null) {
                this.rowHeader = new DefaultRowHeader(this);
                Color bg = scrollPane.getBackground();
                if (LAFUtils.isNimbusLAF()) {
                    bg = ColorUtilities.createPureColor(bg);
                }
                this.rowHeader.setBackground(bg);
                scrollPane.setRowHeaderView(this.rowHeader);
            }
            scrollPane.setRowHeaderView(this.rowHeader);
        } else if (this.rowHeader != null) {
            scrollPane.setRowHeaderView(null);
        }
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        super.tableChanged(e);
        if (this.rowHeader != null) {
            this.rowHeader.repaint();
        }
    }

    private class MouseHandler
    extends MouseAdapter {
        private MouseHandler() {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            try {
                int vColumnIndex;
                if (!JNPadTable.this.isSortingEnabled) {
                    return;
                }
                TableModel tableModel = JNPadTable.this.getModel();
                if (!(tableModel instanceof JNPadTableModel)) {
                    return;
                }
                TableColumnModel tableColumnModel = JNPadTable.this.getColumnModel();
                int mColumnIndex = tableColumnModel.getColumn(vColumnIndex = tableColumnModel.getColumnIndexAtX(e.getX())).getModelIndex();
                if (!((JNPadTableModel)tableModel).isSortable(mColumnIndex)) {
                    return;
                }
                if (JNPadTable.this.sortedColumnIndex == vColumnIndex) {
                    JNPadTable.this.isSortedColumnAscending = !JNPadTable.this.isSortedColumnAscending;
                }
                JNPadTable.this.sortedColumnIndex = vColumnIndex;
                ((JNPadTableModel)tableModel).setSortByColumn(mColumnIndex, JNPadTable.this.isSortedColumnAscending);
                JNPadTable.this.tableHeader.repaint();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

