/*
 * Decompiled with CFR 0.152.
 */
package jnpad.ui.tab;

import java.awt.CardLayout;
import java.awt.Component;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jnpad.GUIUtilities;
import jnpad.config.Configurable;
import jnpad.ui.tab.ITabbedPane;
import jnpad.util.Platform;

public class CardTabbedPane
extends JPanel
implements ITabbedPane {
    protected List<TabInfo> myTabs = new ArrayList<TabInfo>();
    protected TabInfo selected;
    protected CopyOnWriteArraySet<ChangeListener> myListeners = new CopyOnWriteArraySet();
    private boolean _suppressStateChangedEvents = false;
    private boolean _autoFocusOnTabHideClose = true;
    private boolean _suppressSetSelectedIndex = false;
    private boolean _autoRequestFocus = true;
    protected CardLayout layout = new CardLayout();
    protected transient ChangeEvent changeEvent = null;
    private static final long serialVersionUID = -8761739554084513445L;

    public CardTabbedPane() {
        this.setLayout(this.layout);
    }

    @Override
    public void addChangeListener(ChangeListener listener) {
        this.myListeners.add(listener);
    }

    @Override
    public void removeChangeListener(ChangeListener listener) {
        this.myListeners.remove(listener);
    }

    @Override
    public JComponent toComponent() {
        return this;
    }

    @Override
    public void focusOnSelectedComponent() {
        Component selectedComponent = this.getSelectedComponent();
        if (selectedComponent != null) {
            GUIUtilities.requestFocus(selectedComponent);
        }
    }

    @Override
    public void configure(int cfg) {
        int i = 0;
        while (i < this.getTabCount()) {
            Component c = this.getComponentAt(i);
            if (c instanceof Configurable) {
                ((Configurable)((Object)c)).configure(cfg);
            }
            ++i;
        }
    }

    @Override
    public void nextTab() {
        if (this.getTabCount() > 1) {
            int i = this.getSelectedIndex();
            i = i == 0 ? this.getTabCount() - 1 : --i;
            this.setSelectedIndex(i);
        }
    }

    @Override
    public void previousTab() {
        if (this.getTabCount() > 1) {
            int i = this.getSelectedIndex();
            i = i == this.getTabCount() - 1 ? 0 : ++i;
            this.setSelectedIndex(i);
        }
    }

    @Override
    public int getTabCount() {
        return this.myTabs.size();
    }

    private TabInfo getTabAt(int index) {
        this.checkIndex(index);
        return this.myTabs.get(index);
    }

    private void checkIndex(int index) {
        if (index < 0 || index >= this.getTabCount()) {
            throw new ArrayIndexOutOfBoundsException("tabCount=" + this.getTabCount() + " index=" + index);
        }
    }

    @Override
    public Component getComponentAt(int index) {
        return this.getTabAt(index).getComponent();
    }

    @Override
    public Icon getIconAt(int index) {
        return this.getTabAt(index).getIcon();
    }

    @Override
    public Component getSelectedComponent() {
        return this.selected != null ? this.selected.getComponent() : null;
    }

    @Override
    public int getSelectedIndex() {
        return this.selected != null ? this.myTabs.indexOf(this.selected) : -1;
    }

    @Override
    public String getTitleAt(int index) {
        return this.getTabAt(index).getTitle();
    }

    @Override
    public int indexOfComponent(Component c) {
        int i = 0;
        while (i < this.myTabs.size()) {
            TabInfo tab = this.myTabs.get(i);
            if (tab.getComponent().equals(c)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public void insertTab(String title, Icon icon, Component component, String tip, int index) {
        int elementCount;
        if (component == null) {
            return;
        }
        int newIndex = index;
        int removeIndex = this.indexOfComponent(component);
        if (removeIndex != -1) {
            this.removeTabAt(removeIndex);
            if (newIndex > removeIndex) {
                --newIndex;
            }
        }
        if (index > (elementCount = this.getTabCount())) {
            throw new ArrayIndexOutOfBoundsException(String.valueOf(index) + " > " + elementCount);
        }
        int selectedIndex = this.getSelectedIndex();
        if (newIndex == elementCount) {
            this.myTabs.add(new TabInfo(title != null ? title : "", icon, component, tip));
        } else {
            this.myTabs.set(newIndex, new TabInfo(title != null ? title : "", icon, component, tip));
        }
        this.add(component, tip);
        if (this.myTabs.size() == 1) {
            this.setSelectedIndex(0);
        }
        if (selectedIndex >= newIndex) {
            this.setSelectedIndex(selectedIndex + 1);
        }
        this.revalidate();
        this.repaint();
    }

    @Override
    public void removeTabAt(int index) {
        this.checkIndex(index);
        int selectedIndex = this.getSelectedIndex();
        Component selectedComponent = this.getSelectedComponent();
        this.remove(selectedComponent);
        this.myTabs.remove(index);
        if (selectedIndex > index || selectedIndex >= this.getTabCount()) {
            this.setSelectedIndex(selectedIndex - 1);
        } else if (index == selectedIndex) {
            this.setSelectedIndex(index >= this.getTabCount() ? this.getTabCount() - 1 : index);
        }
        this.revalidate();
        this.repaint();
    }

    @Override
    public void setComponentAt(int index, Component c) {
        this.getTabAt(index).setComponent(c);
    }

    @Override
    public void setIconAt(int index, Icon icon) {
        this.getTabAt(index).setIcon(icon);
    }

    @Override
    public void setSelectedComponent(Component c) {
        int index = this.indexOfComponent(c);
        if (index == -1) {
            throw new IllegalArgumentException("component not found in tabbed pane");
        }
        this.setSelectedIndex(index);
    }

    @Override
    public void setSelectedIndex(int index) {
        if (index >= this.getTabCount() || this.isSuppressSetSelectedIndex()) {
            return;
        }
        int oldIndex = this.getSelectedIndex();
        if (oldIndex != index) {
            this.selected = this.getTabAt(index);
            this.layout.show(this, this.selected.getTooltipText());
            this.fireStateChanged();
        }
    }

    @Override
    public void setTitleAt(int index, String title) {
        this.getTabAt(index).setTitle(title);
    }

    @Override
    public void setToolTipTextAt(int index, String toolTipText) {
        this.getTabAt(index).setTooltipText(toolTipText);
    }

    @Override
    public String getToolTipTextAt(int index) {
        return this.getTabAt(index).getTooltipText();
    }

    @Override
    public boolean isAutoRequestFocus() {
        return this._autoRequestFocus;
    }

    @Override
    public void setAutoRequestFocus(boolean autoRequestFocus) {
        this._autoRequestFocus = autoRequestFocus;
    }

    @Override
    public boolean isSuppressSetSelectedIndex() {
        return this._suppressSetSelectedIndex;
    }

    @Override
    public void setSuppressSetSelectedIndex(boolean suppressSetSelectedIndex) {
        this._suppressSetSelectedIndex = suppressSetSelectedIndex;
    }

    @Override
    public void setSuppressStateChangedEvents(boolean suppress) {
        this._suppressStateChangedEvents = suppress;
    }

    @Override
    public boolean isSuppressStateChangedEvents() {
        return this._suppressStateChangedEvents;
    }

    @Override
    public void setAutoFocusOnTabHideClose(boolean autoFocusOnTabHideClose) {
        this._autoFocusOnTabHideClose = autoFocusOnTabHideClose;
    }

    @Override
    public boolean isAutoFocusOnTabHideClose() {
        return this._autoFocusOnTabHideClose;
    }

    protected void fireStateChanged() {
        if (this.isSuppressStateChangedEvents()) {
            return;
        }
        if (this.changeEvent == null) {
            this.changeEvent = new ChangeEvent(this);
        }
        for (ChangeListener l : this.myListeners) {
            l.stateChanged(this.changeEvent);
        }
    }

    @Override
    public void moveSelectedTabTo(int tabIndex) {
        int selectedIndex = this.getSelectedIndex();
        if (selectedIndex == tabIndex || tabIndex < 0 || tabIndex >= this.getTabCount() || selectedIndex == -1) {
            return;
        }
        Component selectedComponent = this.getComponentAt(selectedIndex);
        boolean old = this.isAutoRequestFocus();
        boolean shouldChangeFocus = false;
        if (selectedComponent != null && GUIUtilities.isAncestorOfFocusOwner(selectedComponent) && this.isAutoFocusOnTabHideClose()) {
            shouldChangeFocus = true;
        }
        try {
            this.setSuppressStateChangedEvents(true);
            this.setAutoRequestFocus(false);
            if (selectedIndex - tabIndex == 1 || tabIndex - selectedIndex == 1) {
                Component frame = this.getComponentAt(tabIndex);
                String title = this.getTitleAt(tabIndex);
                String tooltip = this.getToolTipTextAt(tabIndex);
                Icon icon = this.getIconAt(tabIndex);
                this.setSuppressStateChangedEvents(true);
                try {
                    if (tabIndex > selectedIndex) {
                        this.insertTab(title, icon, frame, tooltip, selectedIndex);
                    }
                    this.insertTab(title, icon, frame, tooltip, selectedIndex + 1);
                }
                finally {
                    this.setSuppressStateChangedEvents(false);
                }
            } else {
                Component frame = this.getComponentAt(selectedIndex);
                String title = this.getTitleAt(selectedIndex);
                String tooltip = this.getToolTipTextAt(selectedIndex);
                Icon icon = this.getIconAt(selectedIndex);
                this.setSuppressStateChangedEvents(true);
                try {
                    if (tabIndex > selectedIndex) {
                        this.insertTab(title, icon, frame, tooltip, tabIndex + 1);
                    } else {
                        this.insertTab(title, icon, frame, tooltip, tabIndex);
                    }
                }
                finally {
                    this.setSuppressStateChangedEvents(false);
                }
            }
            if (!Platform.isJRE5Above() && tabIndex == this.getTabCount() - 2) {
                this.setSelectedIndex(this.getTabCount() - 1);
            }
            this.setAutoRequestFocus(old);
            this.setSelectedIndex(tabIndex);
        }
        finally {
            this.setSuppressStateChangedEvents(false);
            if (shouldChangeFocus) {
                this.requestFocusInWindow();
            }
        }
    }

    @Override
    public void scrollTabToVisible(int index) {
    }

    @Override
    public int getTabLayoutPolicy() {
        return 0;
    }

    @Override
    public void setTabLayoutPolicy(int policy) {
    }

    public static class TabInfo
    implements Serializable {
        private Component component;
        private Icon icon;
        private String title;
        private String tooltipText;
        private static final long serialVersionUID = 2291983360274382291L;

        TabInfo(String title, Icon icon, Component component, String tooltipText) {
            this.title = title;
            this.icon = icon;
            this.component = component;
            this.tooltipText = tooltipText;
        }

        public void setComponent(Component component) {
            this.component = component;
        }

        public Component getComponent() {
            return this.component;
        }

        public void setIcon(Icon icon) {
            this.icon = icon;
        }

        public Icon getIcon() {
            return this.icon;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public String getTitle() {
            return this.title;
        }

        public void setTooltipText(String tooltipText) {
            this.tooltipText = tooltipText;
        }

        public String getTooltipText() {
            return this.tooltipText;
        }
    }
}

