/*
 * Decompiled with CFR 0.152.
 */
package jnpad.ui.plaf;

import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JComponent;
import javax.swing.JSeparator;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicToolBarSeparatorUI;

public final class JNPadToolbarSeparatorUI
extends BasicToolBarSeparatorUI {
    private JNPadToolbarSeparatorUI() {
        this.shadow = UIManager.getColor("controlDkShadow");
        this.highlight = UIManager.getColor("controlLtHighlight");
    }

    public static ComponentUI createUI(JComponent c) {
        return new JNPadToolbarSeparatorUI();
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        Dimension size = super.getPreferredSize(c);
        if (size != null) {
            size = size.getSize();
        } else {
            size = new Dimension(2, 2);
            if (((JSeparator)c).getOrientation() == 1) {
                size.height = 0;
            } else {
                size.width = 0;
            }
        }
        return size;
    }

    @Override
    public Dimension getMaximumSize(JComponent c) {
        Dimension pref = this.getPreferredSize(c);
        if (((JSeparator)c).getOrientation() == 1) {
            return new Dimension(pref.width, Short.MAX_VALUE);
        }
        return new Dimension(Short.MAX_VALUE, pref.height);
    }

    @Override
    public final void paint(Graphics g, JComponent c) {
        boolean vertical = ((JSeparator)c).getOrientation() == 1;
        Dimension size = c.getSize();
        if (vertical) {
            int x = size.width / 2 - 1;
            g.setColor(this.shadow);
            g.drawLine(x, 2, x, size.height - 2);
            g.setColor(this.highlight);
            g.drawLine(x + 1, 2, x + 1, size.height - 2);
        } else {
            int y = size.height / 2 - 1;
            g.setColor(this.shadow);
            g.drawLine(2, y, size.width - 2, y);
            g.setColor(this.highlight);
            g.drawLine(2, y + 1, size.width - 2, y + 1);
        }
    }
}

