/*
 * Decompiled with CFR 0.152.
 */
package jnpad.ui.plaf;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.RoundRectangle2D;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.basic.BasicTabbedPaneUI;

public final class JNPadTabbedPaneUI
extends BasicTabbedPaneUI {
    private static final int ROUNDED_TAB_ARC_HEIGHT = 20;
    private static final int ROUNDED_TAB_ARC_WIDTH = 20;
    private static final BasicStroke DEFAULT_STROKE = new BasicStroke(1.0f);
    private static final BasicStroke TAB_SELECTED_STROKE = new BasicStroke(1.2f);
    private static final BasicStroke TAB_STROKE = new BasicStroke(0.75f);
    private static final BasicStroke DASHED_STROKE = new BasicStroke(1.0f, 0, 0, 10.0f, new float[]{2.0f}, 0.0f);
    private static final Insets TABBED_PANE_MARGIN = new Insets(0, 0, 0, 0);
    private Color selectedColor;
    private boolean borderPainted;

    public static ComponentUI createUI(JComponent c) {
        return new JNPadTabbedPaneUI();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.selectedColor = UIManager.getColor("TabbedPane.selected");
        this.borderPainted = UIManager.getBoolean("TabbedPane.contentBorderPainted");
    }

    @Override
    protected int getTabLabelShiftX(int tabPlacement, int tabIndex, boolean isSelected) {
        return 0;
    }

    @Override
    protected int getTabLabelShiftY(int tabPlacement, int tabIndex, boolean isSelected) {
        return 0;
    }

    @Override
    protected int calculateTabWidth(int tabPlacement, int tabIndex, FontMetrics metrics) {
        return super.calculateTabWidth(tabPlacement, tabIndex, metrics) + 5;
    }

    @Override
    protected void paintTabBorder(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        Graphics2D g2D = (Graphics2D)g;
        Object oldRendering = g2D.getRenderingHint(RenderingHints.KEY_RENDERING);
        Object oldAntialiasing = g2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        g2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        h -= 2;
        if (isSelected) {
            h -= 2;
            g2D.setStroke(TAB_SELECTED_STROKE);
        } else {
            g2D.setStroke(TAB_STROKE);
        }
        Color shadow1 = null;
        Color darkShadow1 = null;
        shadow1 = this.shadow;
        darkShadow1 = this.shadow;
        g.setColor(shadow1);
        switch (tabPlacement) {
            case 2: {
                g.drawLine(x + 1, y + h - 2, x + 1, y + h - 2);
                g.drawLine(x, y + 2, x, y + h - 3);
                g.drawLine(x + 1, y + 1, x + 1, y + 1);
                g.drawLine(x + 2, y, x + w - 1, y);
                g.setColor(shadow1);
                g.drawLine(x + 2, y + h - 2, x + w - 1, y + h - 2);
                g.setColor(darkShadow1);
                g.drawLine(x + 2, y + h - 1, x + w - 1, y + h - 1);
                break;
            }
            case 4: {
                g.drawLine(x, y, x + w - 3, y);
                g.setColor(shadow1);
                g.drawLine(x, y + h - 2, x + w - 3, y + h - 2);
                g.drawLine(x + w - 2, y + 2, x + w - 2, y + h - 3);
                g.setColor(darkShadow1);
                g.drawLine(x + w - 2, y + 1, x + w - 2, y + 1);
                g.drawLine(x + w - 2, y + h - 2, x + w - 2, y + h - 2);
                g.drawLine(x + w - 1, y + 2, x + w - 1, y + h - 3);
                g.drawLine(x, y + h - 1, x + w - 3, y + h - 1);
                break;
            }
            case 3: {
                g2D.draw(new RoundRectangle2D.Double(x + 2, y - 2, w - 5, h + 1, 20.0, 20.0));
                break;
            }
            default: {
                g2D.draw(new RoundRectangle2D.Double(x + 2, y, w - 5, h + 1, 20.0, 20.0));
            }
        }
        g2D.setRenderingHint(RenderingHints.KEY_RENDERING, oldRendering);
        g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldAntialiasing);
        g2D.setStroke(DEFAULT_STROKE);
    }

    @Override
    protected void paintTabBackground(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        Graphics2D g2D = (Graphics2D)g;
        Object oldRendering = g2D.getRenderingHint(RenderingHints.KEY_RENDERING);
        Object oldAntialiasing = g2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        g2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setColor(!isSelected || this.selectedColor == null ? this.tabPane.getBackgroundAt(tabIndex) : this.selectedColor);
        h -= 2;
        if (isSelected) {
            h -= 2;
        }
        switch (tabPlacement) {
            case 2: {
                g.fillRect(x + 1, y + 1, w - 1, h - 3);
                break;
            }
            case 4: {
                g.fillRect(x, y + 1, w - 2, h - 3);
                break;
            }
            case 3: {
                g2D.draw(new RoundRectangle2D.Double(x + 2, y - 2, w - 5, h + 1, 20.0, 20.0));
                break;
            }
            default: {
                g2D.fill(new RoundRectangle2D.Double(x + 2, y, w - 5, h + 1, 20.0, 20.0));
            }
        }
        g2D.setRenderingHint(RenderingHints.KEY_RENDERING, oldRendering);
        g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldAntialiasing);
    }

    @Override
    protected void paintFocusIndicator(Graphics g, int tabPlacement, Rectangle[] rects, int tabIndex, Rectangle iconRect, Rectangle textRect, boolean isSelected) {
        Rectangle tabRect = rects[tabIndex];
        if (this.tabPane.hasFocus() && isSelected) {
            Graphics2D g2D = (Graphics2D)g;
            Object oldRendering = g2D.getRenderingHint(RenderingHints.KEY_RENDERING);
            Object oldAntialiasing = g2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            g2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.setColor(this.focus);
            switch (tabPlacement) {
                case 2: 
                case 4: {
                    int x = tabRect.x + 3;
                    int y = tabRect.y + 2;
                    int w = tabRect.width - 6;
                    int h = tabRect.height - 6;
                    BasicGraphicsUtils.drawDashedRect(g, x, y, w, h);
                    break;
                }
                default: {
                    int x = tabRect.x + 4;
                    int y = tabRect.y + 2;
                    int w = tabRect.width - 9;
                    int h = tabRect.height - 6;
                    g2D.setStroke(DASHED_STROKE);
                    g2D.draw(new RoundRectangle2D.Double(x, y, w, h, 20.0, 20.0));
                }
            }
            g2D.setRenderingHint(RenderingHints.KEY_RENDERING, oldRendering);
            g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldAntialiasing);
            g2D.setStroke(DEFAULT_STROKE);
        }
    }

    @Override
    protected Insets getContentBorderInsets(int tabPlacement) {
        if (this.borderPainted) {
            return super.getContentBorderInsets(tabPlacement);
        }
        return TABBED_PANE_MARGIN;
    }

    @Override
    protected void paintContentBorder(Graphics g, int tabPlacement, int selectedIndex) {
        if (this.borderPainted) {
            super.paintContentBorder(g, tabPlacement, selectedIndex);
        }
    }
}

