/*
 * Decompiled with CFR 0.152.
 */
package jnpad.ui.icon;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.SwingConstants;
import javax.swing.UIManager;

public class ArrowIcon
implements Icon,
SwingConstants {
    private static final float DB = -0.06f;
    private int direction;
    private int size;
    private Color color;
    private BufferedImage arrowImage;

    public ArrowIcon(int direction) {
        this(direction, 10, null);
    }

    public ArrowIcon(int direction, Color color) {
        this(direction, 10, color);
    }

    public ArrowIcon(int direction, int size, Color color) {
        this.size = size;
        this.direction = direction;
        this.color = color;
    }

    @Override
    public int getIconHeight() {
        return this.size;
    }

    @Override
    public int getIconWidth() {
        return this.size;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        g.drawImage(this.getArrowImage(), x, y, c);
    }

    public static BufferedImage createTranslucentImage(int width, int height) {
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().createCompatibleImage(width, height, 3);
    }

    protected Image getArrowImage() {
        if (this.arrowImage == null) {
            this.arrowImage = ArrowIcon.createTranslucentImage(this.size, this.size);
            AffineTransform atx = this.direction != 5 ? new AffineTransform() : null;
            switch (this.direction) {
                case 1: {
                    atx.setToRotation(Math.PI, (double)this.size / 2.0, (double)this.size / 2.0);
                    break;
                }
                case 3: {
                    atx.setToRotation(-1.5707963267948966, (double)this.size / 2.0, (double)this.size / 2.0);
                    break;
                }
                case 7: {
                    atx.setToRotation(1.5707963267948966, (double)this.size / 2.0, (double)this.size / 2.0);
                    break;
                }
            }
            Graphics2D ig = (Graphics2D)this.arrowImage.getGraphics();
            if (atx != null) {
                ig.setTransform(atx);
            }
            int width = this.size;
            int height = this.size / 2 + 1;
            int xx = (this.size - width) / 2;
            int yy = (this.size - height + 1) / 2;
            Color base = this.color != null ? this.color : UIManager.getColor("controlDkShadow").darker();
            this.paintArrow(ig, base, xx, yy);
            this.paintArrowBevel(ig, base, xx, yy);
            this.paintArrowBevel(ig, ArrowIcon.deriveColorHSB(base, 0.0f, 0.0f, 0.2f), xx, yy + 1);
        }
        return this.arrowImage;
    }

    protected void paintArrow(Graphics2D g, Color base, int x, int y) {
        g.setColor(base);
        int len = this.size - 2;
        int xx = x;
        int yy = y - 1;
        while (len >= 2) {
            g.fillRect(++xx, ++yy, len, 1);
            len -= 2;
        }
    }

    protected void paintArrowBevel(Graphics g, Color base, int x, int y) {
        int len = this.size;
        int xx = x;
        int yy = y;
        Color c2 = ArrowIcon.deriveColorHSB(base, 0.0f, 0.0f, 0.06f * ((float)this.size / 2.0f));
        while (len >= 2) {
            c2 = ArrowIcon.deriveColorHSB(c2, 0.0f, 0.0f, -0.06f);
            g.setColor(c2);
            g.fillRect(xx, yy, 1, 1);
            g.fillRect(xx + len - 1, yy, 1, 1);
            len -= 2;
            ++xx;
            ++yy;
        }
    }

    public static Color deriveColorHSB(Color base, float dH, float dS, float dB) {
        float[] hsb = Color.RGBtoHSB(base.getRed(), base.getGreen(), base.getBlue(), null);
        hsb[0] = hsb[0] + dH;
        hsb[1] = hsb[1] + dS;
        hsb[2] = hsb[2] + dB;
        return Color.getHSBColor(hsb[0] < 0.0f ? 0.0f : (hsb[0] > 1.0f ? 1.0f : hsb[0]), hsb[1] < 0.0f ? 0.0f : (hsb[1] > 1.0f ? 1.0f : hsb[1]), hsb[2] < 0.0f ? 0.0f : (hsb[2] > 1.0f ? 1.0f : hsb[2]));
    }
}

