/*
 * Decompiled with CFR 0.152.
 */
package jnpad.ui;

import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;

public class MnemonicHelper {
    private List<Character> l_mnemonics = new ArrayList<Character>();

    public char getMnemonic(String text) {
        if (text == null || text.length() == 0) {
            return '\u0000';
        }
        int mnemonicPos = 0;
        text = text.toLowerCase();
        int textLength = text.length();
        do {
            char mnemonic;
            if (!this.checkIsOk(mnemonic = text.charAt(mnemonicPos++))) continue;
            this.l_mnemonics.add(Character.valueOf(mnemonic));
            return mnemonic;
        } while (mnemonicPos < textLength);
        return '\u0000';
    }

    private boolean checkIsOk(char mnemonic) {
        return !this.isMnemonicUsed(mnemonic) && !Character.isWhitespace(mnemonic) && (mnemonic >= 'A' && mnemonic <= 'Z' || mnemonic >= 'a' && mnemonic <= 'z' || mnemonic >= '0' && mnemonic <= '9');
    }

    public char getMnemonic(JButton button) {
        return this.getMnemonic(button.getText());
    }

    public boolean isMnemonicUsed(char ch) {
        return this.l_mnemonics.indexOf(Character.valueOf(ch)) != -1;
    }

    public void clear() {
        this.l_mnemonics.clear();
    }
}

